/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.choose;

import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.core.spell.Spell;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractQualifiedChooseToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class SpellsToken
extends AbstractQualifiedChooseToken<Spell> {
    private static final Class<Spell> SPELL_CLASS = Spell.class;

    @Override
    public String getTokenName() {
        return "SPELLS";
    }

    @Override
    public String getParentToken() {
        return "CHOOSE";
    }

    @Override
    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    @Override
    protected String getDefaultTitle() {
        return "Spell choice";
    }

    @Override
    protected AssociationListKey<Spell> getListKey() {
        return AssociationListKey.getKeyFor(SPELL_CLASS, "CHOOSE*SPELL");
    }

    @Override
    public Spell decodeChoice(LoadContext context, String s) {
        return context.getReferenceContext().silentlyGetConstructedCDOMObject(SPELL_CLASS, s);
    }

    @Override
    public String encodeChoice(Spell choice) {
        return choice.getKeyName();
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, CDOMObject obj, String value) {
        return super.parseTokenWithSeparator(context, context.getReferenceContext().getManufacturer(SPELL_CLASS), obj, this.processMagicalWords(value));
    }

    private String processMagicalWords(String value) {
        StringTokenizer st = new StringTokenizer(value, "|", true);
        StringBuilder sb = new StringBuilder(value.length() + 40);
        while (st.hasMoreTokens()) {
            String profKey;
            String tok = st.nextToken();
            if ("DOMAIN.".regionMatches(true, 0, tok, 0, 7)) {
                profKey = tok.substring(7);
                Logging.errorPrint("CHOOSE:SPELLS|DOMAIN is deprecated, has been changed to DOMAINLIST=");
                sb.append("DOMAINLIST=").append(profKey);
                continue;
            }
            if ("CLASS.".regionMatches(true, 0, tok, 0, 6)) {
                profKey = tok.substring(6);
                Logging.errorPrint("CHOOSE:SPELLS|CLASS is deprecated, has been changed to CLASSLIST=");
                sb.append("CLASSLIST=").append(profKey);
                continue;
            }
            if ("DOMAIN=".regionMatches(true, 0, tok, 0, 7)) {
                profKey = tok.substring(7);
                Logging.errorPrint("CHOOSE:SPELLS|DOMAIN is deprecated, has been changed to DOMAINLIST=");
                sb.append("DOMAINLIST=").append(profKey);
                continue;
            }
            if ("CLASS=".regionMatches(true, 0, tok, 0, 6)) {
                profKey = tok.substring(6);
                Logging.errorPrint("CHOOSE:SPELLS|CLASS is deprecated, has been changed to CLASSLIST=");
                sb.append("CLASSLIST=").append(profKey);
                continue;
            }
            if ("ANY".regionMatches(true, 0, tok, 0, 3)) {
                String remainder = tok.length() > 3 ? tok.substring(3) : "";
                Logging.errorPrint("CHOOSE:SPELLS|ANY is deprecated, has been changed to ALL");
                sb.append("ALL").append(remainder);
                continue;
            }
            sb.append(tok);
        }
        return sb.toString();
    }
}

