/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.persistence;

import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.cdom.base.Loadable;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;

public class CDOMSubLineLoader<T extends Loadable> {
    private final Class<T> targetClass;
    private final String targetPrefix;
    private final String targetPrefixColon;

    public CDOMSubLineLoader(String prefix, Class<T> cl) {
        this.targetPrefix = prefix;
        this.targetClass = cl;
        this.targetPrefixColon = prefix + ":";
    }

    public boolean parseLine(LoadContext context, T obj, String val) throws PersistenceLayerException {
        if (val == null) {
            return true;
        }
        boolean returnValue = true;
        StringTokenizer st = new StringTokenizer(val, "\t");
        while (st.hasMoreTokens()) {
            String value;
            String token = st.nextToken().trim();
            int colonLoc = token.indexOf(58);
            if (colonLoc == -1) {
                Logging.errorPrint("Invalid Token - does not contain a colon: " + token);
                returnValue = false;
                continue;
            }
            if (colonLoc == 0) {
                Logging.errorPrint("Invalid Token - starts with a colon: " + token);
                returnValue = false;
                continue;
            }
            String key = token.substring(0, colonLoc);
            String string = value = colonLoc == token.length() - 1 ? null : token.substring(colonLoc + 1);
            if (key == null || value == null) {
                Logging.errorPrint("Invalid token - key or value missing: " + token + " in line " + val, context);
                returnValue = false;
                continue;
            }
            boolean passed = context.processToken(obj, key.intern(), value.intern());
            if (passed) {
                context.commit();
                continue;
            }
            context.rollback();
            returnValue = false;
        }
        return returnValue;
    }

    public T getCDOMObject() {
        try {
            return (T)((Loadable)this.targetClass.newInstance());
        }
        catch (InstantiationException e) {
            Logging.errorPrint("Exception in Instantiation: ", e);
        }
        catch (IllegalAccessException e) {
            Logging.errorPrint("Exception in Instantiation: ", e);
        }
        throw new IllegalArgumentException();
    }

    public String getPrefix() {
        return this.targetPrefix;
    }

    public Class<T> getLoadedClass() {
        return this.targetClass;
    }

    public void unloadObject(LoadContext lc, T object, StringBuilder sb) {
        Collection<String> unparse = lc.unparse(object);
        StringBuilder temp = new StringBuilder();
        if (unparse != null) {
            for (String s : unparse) {
                if (s.startsWith(this.targetPrefixColon)) {
                    sb.append(s);
                    continue;
                }
                temp.append('\t');
                temp.append(s);
            }
            sb.append((CharSequence)temp);
            sb.append('\n');
        }
    }
}

