/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs.equip;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import pcgen.base.util.HashMapToList;
import pcgen.base.util.MapToList;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.EquipmentFacade;
import pcgen.facade.core.EquipmentListFacade;
import pcgen.facade.core.EquipmentSetFacade;
import pcgen.facade.util.ReferenceFacade;
import pcgen.facade.util.event.ReferenceEvent;
import pcgen.facade.util.event.ReferenceListener;
import pcgen.gui2.filter.DisplayableFilter;
import pcgen.gui2.filter.FilterHandler;
import pcgen.gui2.tabs.equip.EquipmentTableModel;
import pcgen.gui2.tabs.equip.UnequippedList;
import pcgen.gui2.tools.Icons;
import pcgen.gui2.util.JTableEx;
import pcgen.gui2.util.JTreeTable;
import pcgen.gui2.util.table.SortableTableModel;
import pcgen.gui2.util.table.TableCellUtilities;
import pcgen.system.LanguageBundle;

public class EquipmentModels {
    private final CharacterFacade character;
    private final EquipmentTableModel fullModel;
    private final EquipmentTableModel unequippedModel;
    private final EquipmentTableModel equippedModel;
    private final UnequippedList unequippedList;
    private final EquipViewHandler viewHandler;
    private final EquipAction equipAction;
    private final UnequipAction unequipAction;
    private final MoveUpAction moveUpAction;
    private final MoveDownAction moveDownAction;
    private final EquipFilterHandler filterHandler;
    private EquipView selectedView;
    private EquipmentTableModel selectedModel;
    private JComboBox equipViewBox;
    private JTableEx equipmentTable;
    private JTreeTable equipmentSetTable;

    public EquipmentModels(CharacterFacade character) {
        this.character = character;
        this.unequippedList = new UnequippedList(character);
        this.fullModel = new EquipmentTableModel(character);
        this.fullModel.setEquipmentList(character.getPurchasedEquipment());
        this.fullModel.setEquipmentSet(character.getEquipmentSetRef().getReference());
        this.unequippedModel = new EquipmentTableModel(character);
        this.unequippedModel.setEquipmentList(this.unequippedList);
        this.unequippedModel.setEquipmentSet(character.getEquipmentSetRef().getReference());
        this.equippedModel = new EquippedTableModel(character);
        this.selectedModel = this.fullModel;
        this.selectedView = EquipView.UNEQUIPPED;
        this.viewHandler = new EquipViewHandler();
        this.equipAction = new EquipAction();
        this.unequipAction = new UnequipAction();
        this.moveUpAction = new MoveUpAction();
        this.moveDownAction = new MoveDownAction();
        this.filterHandler = new EquipFilterHandler();
    }

    public void install(JComboBox equipBox, JTableEx eqTable, DisplayableFilter<? super CharacterFacade, ? super EquipmentFacade> filter, JTreeTable eqSetTable, JButton equipButton, JButton unequipButton, JButton moveUpButton, JButton moveDownButton) {
        this.equipViewBox = equipBox;
        this.equipmentTable = eqTable;
        this.equipmentSetTable = eqSetTable;
        this.viewHandler.install();
        equipButton.setAction(this.equipAction);
        unequipButton.setAction(this.unequipAction);
        moveUpButton.setAction(this.moveUpAction);
        moveDownButton.setAction(this.moveDownAction);
        this.equipAction.install();
        this.unequipAction.install();
        filter.setFilterHandler(this.filterHandler);
        this.fullModel.setFilter(filter);
        this.unequippedModel.setFilter(filter);
        this.equippedModel.setFilter(filter);
    }

    public void uninstall() {
        if (this.equipmentTable != null) {
            this.equipAction.uninstall();
            this.unequipAction.uninstall();
        }
    }

    private List<EquipmentSetFacade.EquipNode> getSelectedEquipmentSetNodes() {
        int[] rows = this.equipmentSetTable.getSelectedRows();
        ArrayList<EquipmentSetFacade.EquipNode> paths = new ArrayList<EquipmentSetFacade.EquipNode>();
        for (int i = 0; i < rows.length; ++i) {
            EquipmentSetFacade.EquipNode path = (EquipmentSetFacade.EquipNode)this.equipmentSetTable.getValueAt(rows[i], 0);
            if (path.getNodeType() != EquipmentSetFacade.EquipNode.NodeType.EQUIPMENT) continue;
            paths.add(path);
        }
        return paths;
    }

    private void selectNodeInEquipmentSetTable(EquipmentSetFacade.EquipNode nodeToSelect) {
        SortableTableModel model = this.equipmentSetTable.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            if (nodeToSelect != model.getValueAt(i, 0)) continue;
            this.equipmentSetTable.getSelectionModel().setSelectionInterval(i, i);
            break;
        }
    }

    private static JScrollPane prepareScrollPane(JTable table) {
        JScrollPane pane = new JScrollPane(table);
        Dimension size = table.getPreferredSize();
        size.height += 30;
        int decorationHeight = 80;
        int decorationWidth = 70;
        Rectangle screenBounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        if (size.height > screenBounds.height - 80) {
            size.height = screenBounds.height - 80;
        }
        if (size.width > screenBounds.width - 70) {
            size.width = screenBounds.width - 70;
        }
        pane.setHorizontalScrollBarPolicy(31);
        pane.setPreferredSize(size);
        return pane;
    }

    private class MoveDownAction
    extends AbstractAction {
        public MoveDownAction() {
            super(LanguageBundle.getString("in_equipMoveDownMenuCommand"));
            this.putValue("SmallIcon", Icons.Down16.getImageIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EquipmentSetFacade equipSet = EquipmentModels.this.character.getEquipmentSetRef().getReference();
            List paths = EquipmentModels.this.getSelectedEquipmentSetNodes();
            if (!paths.isEmpty()) {
                for (EquipmentSetFacade.EquipNode node : paths) {
                    equipSet.moveEquipment(node, 1);
                }
                EquipmentModels.this.selectNodeInEquipmentSetTable((EquipmentSetFacade.EquipNode)paths.get(0));
            }
        }

        public void install() {
            EquipmentModels.this.equipmentSetTable.addActionListener(this);
        }

        public void uninstall() {
            EquipmentModels.this.equipmentSetTable.removeActionListener(this);
        }
    }

    private class MoveUpAction
    extends AbstractAction {
        public MoveUpAction() {
            super(LanguageBundle.getString("in_equipMoveUpMenuCommand"));
            this.putValue("SmallIcon", Icons.Up16.getImageIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EquipmentSetFacade equipSet = EquipmentModels.this.character.getEquipmentSetRef().getReference();
            List paths = EquipmentModels.this.getSelectedEquipmentSetNodes();
            if (!paths.isEmpty()) {
                for (EquipmentSetFacade.EquipNode node : paths) {
                    equipSet.moveEquipment(node, -1);
                }
                EquipmentModels.this.selectNodeInEquipmentSetTable((EquipmentSetFacade.EquipNode)paths.get(0));
            }
        }

        public void install() {
            EquipmentModels.this.equipmentSetTable.addActionListener(this);
        }

        public void uninstall() {
            EquipmentModels.this.equipmentSetTable.removeActionListener(this);
        }
    }

    private static class ComboEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private JComboBox comboBox = null;
        private MapToList<EquipmentFacade, EquipmentSetFacade.EquipNode> equipMap;

        public ComboEditor(MapToList<EquipmentFacade, EquipmentSetFacade.EquipNode> equipMap) {
            this.equipMap = equipMap;
        }

        @Override
        public Object getCellEditorValue() {
            return this.comboBox.getSelectedItem();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            EquipmentFacade equipment = (EquipmentFacade)table.getValueAt(row, 0);
            if (this.comboBox != null) {
                this.comboBox.removeActionListener(this);
            }
            this.comboBox = new JComboBox<Object>(this.equipMap.getListFor((Object)equipment).toArray());
            this.comboBox.setSelectedItem(value);
            this.comboBox.addActionListener(this);
            return this.comboBox;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.stopCellEditing();
        }
    }

    private class SpinnerEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ChangeListener {
        private JSpinner spinner = new JSpinner();
        private final EquipmentListFacade equipmentList;

        public SpinnerEditor(EquipmentListFacade equipmentList) {
            this.equipmentList = equipmentList;
            this.spinner.addChangeListener(this);
        }

        @Override
        public Object getCellEditorValue() {
            return this.spinner.getValue();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            EquipmentFacade equipment = (EquipmentFacade)table.getValueAt(row, 0);
            int maxQuantity = this.equipmentList.getQuantity(equipment);
            int minQuantity = 1;
            if (maxQuantity <= 0) {
                maxQuantity = 0;
                minQuantity = 0;
            }
            SpinnerNumberModel model = new SpinnerNumberModel((Integer)value, minQuantity, maxQuantity, 1);
            this.spinner.setModel(model);
            return this.spinner;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.stopCellEditing();
        }

        @Override
        public boolean stopCellEditing() {
            try {
                this.spinner.commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return super.stopCellEditing();
        }
    }

    public class EquipAction
    extends AbstractAction {
        public EquipAction() {
            super(LanguageBundle.getString("in_equipEquipSel"));
            this.putValue("SmallIcon", Icons.Forward16.getImageIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selectedRows = EquipmentModels.this.equipmentTable.getSelectedRows();
            HashMapToList equipMap = new HashMapToList();
            EquipmentSetFacade equipSet = EquipmentModels.this.character.getEquipmentSetRef().getReference();
            ArrayList<EquipmentFacade> equipment = new ArrayList<EquipmentFacade>();
            for (int i = 0; i < selectedRows.length; ++i) {
                EquipmentFacade equipmentFacade = EquipmentModels.this.selectedModel.getValue(selectedRows[i]);
                for (EquipmentSetFacade.EquipNode path : equipSet.getNodes()) {
                    if (!equipSet.canEquip(path, equipmentFacade)) continue;
                    equipMap.addToListFor((Object)equipmentFacade, (Object)path);
                }
                if (!equipMap.containsListFor((Object)equipmentFacade)) continue;
                equipment.add(equipmentFacade);
            }
            if (!equipment.isEmpty()) {
                Object[][] data = new Object[equipment.size()][3];
                for (int i = 0; i < equipment.size(); ++i) {
                    EquipmentFacade equipmentFacade = (EquipmentFacade)equipment.get(i);
                    data[i][0] = equipmentFacade;
                    data[i][1] = EquipmentModels.this.unequippedList.getQuantity(equipmentFacade);
                    data[i][2] = this.getInitialNode((MapToList<EquipmentFacade, EquipmentSetFacade.EquipNode>)equipMap, equipSet, equipmentFacade);
                }
                Object[] columns = new Object[]{LanguageBundle.getString("in_equipItem"), LanguageBundle.getString("in_equipQuantityAbbrev"), LanguageBundle.getString("in_equipContainer")};
                DefaultTableModel tableModel = new DefaultTableModel(data, columns){

                    @Override
                    public Class<?> getColumnClass(int columnIndex) {
                        if (columnIndex == 1) {
                            return Integer.class;
                        }
                        return Object.class;
                    }

                    @Override
                    public boolean isCellEditable(int row, int column) {
                        return column != 0;
                    }
                };
                JTable table = new JTable(tableModel);
                table.setFocusable(false);
                table.setCellSelectionEnabled(false);
                table.setDefaultEditor(Object.class, new ComboEditor((MapToList<EquipmentFacade, EquipmentSetFacade.EquipNode>)equipMap));
                table.setDefaultRenderer(Integer.class, new TableCellUtilities.SpinnerRenderer());
                table.setDefaultEditor(Integer.class, new SpinnerEditor(EquipmentModels.this.unequippedList));
                table.setRowHeight(22);
                table.getColumnModel().getColumn(0).setPreferredWidth(140);
                table.getColumnModel().getColumn(1).setPreferredWidth(50);
                table.getColumnModel().getColumn(2).setPreferredWidth(120);
                table.setPreferredScrollableViewportSize(table.getPreferredSize());
                JTableHeader header = table.getTableHeader();
                header.setReorderingAllowed(false);
                JScrollPane pane = EquipmentModels.prepareScrollPane(table);
                JPanel panel = new JPanel(new BorderLayout());
                JLabel help = new JLabel(LanguageBundle.getString("in_equipSelectQtyLoc"));
                panel.add((Component)help, "North");
                panel.add((Component)pane, "Center");
                int res = JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(EquipmentModels.this.equipmentTable), panel, LanguageBundle.getString("in_equipEquipSel"), 2, -1);
                if (res == 0) {
                    for (int i = 0; i < equipment.size(); ++i) {
                        EquipmentSetFacade.EquipNode path = (EquipmentSetFacade.EquipNode)tableModel.getValueAt(i, 2);
                        equipSet.addEquipment(path, (EquipmentFacade)equipment.get(i), (Integer)tableModel.getValueAt(i, 1));
                    }
                }
            }
        }

        private EquipmentSetFacade.EquipNode getInitialNode(MapToList<EquipmentFacade, EquipmentSetFacade.EquipNode> equipMap, EquipmentSetFacade equipSet, EquipmentFacade equipmentFacade) {
            List possibleNodeList = equipMap.getListFor((Object)equipmentFacade);
            int[] rows = EquipmentModels.this.equipmentSetTable.getSelectedRows();
            ArrayList paths = new ArrayList();
            for (int i = 0; i < rows.length; ++i) {
                EquipmentSetFacade.EquipNode path = (EquipmentSetFacade.EquipNode)EquipmentModels.this.equipmentSetTable.getValueAt(rows[i], 0);
                if (!possibleNodeList.contains(path)) continue;
                return path;
            }
            String preferredNodeName = equipSet.getPreferredLoc(equipmentFacade);
            for (EquipmentSetFacade.EquipNode node : possibleNodeList) {
                if (!preferredNodeName.equals(node.toString())) continue;
                return node;
            }
            return (EquipmentSetFacade.EquipNode)equipMap.getElementInList((Object)equipmentFacade, 0);
        }

        public void install() {
            EquipmentModels.this.equipmentTable.addActionListener(this);
        }

        public void uninstall() {
            EquipmentModels.this.equipmentTable.removeActionListener(this);
        }
    }

    private class UnequipAction
    extends AbstractAction {
        public UnequipAction() {
            super(LanguageBundle.getString("in_equipUnequipSel"));
            this.putValue("SmallIcon", Icons.Back16.getImageIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EquipmentSetFacade equipSet = EquipmentModels.this.character.getEquipmentSetRef().getReference();
            List paths = EquipmentModels.this.getSelectedEquipmentSetNodes();
            if (!paths.isEmpty()) {
                Object[][] data = new Object[paths.size()][3];
                for (int i = 0; i < paths.size(); ++i) {
                    EquipmentSetFacade.EquipNode path = (EquipmentSetFacade.EquipNode)paths.get(i);
                    data[i][0] = path.getEquipment();
                    data[i][1] = equipSet.getQuantity(path);
                }
                Object[] columns = new Object[]{LanguageBundle.getString("in_equipItem"), LanguageBundle.getString("in_equipQuantityAbbrev")};
                DefaultTableModel tableModel = new DefaultTableModel(data, columns){

                    @Override
                    public Class<?> getColumnClass(int columnIndex) {
                        if (columnIndex == 1) {
                            return Integer.class;
                        }
                        return Object.class;
                    }

                    @Override
                    public boolean isCellEditable(int row, int column) {
                        return column != 0;
                    }
                };
                JTable table = new JTable(tableModel);
                table.setFocusable(false);
                table.setCellSelectionEnabled(false);
                table.setDefaultRenderer(Integer.class, new TableCellUtilities.SpinnerRenderer());
                table.setDefaultEditor(Integer.class, new SpinnerEditor(equipSet.getEquippedItems()));
                table.setRowHeight(22);
                table.getColumnModel().getColumn(0).setPreferredWidth(140);
                table.getColumnModel().getColumn(1).setPreferredWidth(50);
                table.setPreferredScrollableViewportSize(table.getPreferredSize());
                JTableHeader header = table.getTableHeader();
                header.setReorderingAllowed(false);
                JScrollPane pane = EquipmentModels.prepareScrollPane(table);
                JPanel panel = new JPanel(new BorderLayout());
                JLabel help = new JLabel(LanguageBundle.getString("in_equipSelectUnequipQty"));
                panel.add((Component)help, "North");
                panel.add((Component)pane, "Center");
                int res = JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(EquipmentModels.this.equipmentTable), panel, LanguageBundle.getString("in_equipUnequipSel"), 2, -1);
                if (res == 0) {
                    for (int i = 0; i < paths.size(); ++i) {
                        equipSet.removeEquipment((EquipmentSetFacade.EquipNode)paths.get(i), (Integer)tableModel.getValueAt(i, 1));
                    }
                }
            }
        }

        public void install() {
            EquipmentModels.this.equipmentSetTable.addActionListener(this);
        }

        public void uninstall() {
            EquipmentModels.this.equipmentSetTable.removeActionListener(this);
        }
    }

    private static class EquippedTableModel
    extends EquipmentTableModel
    implements ReferenceListener<EquipmentSetFacade> {
        public EquippedTableModel(CharacterFacade character) {
            super(character);
            ReferenceFacade<EquipmentSetFacade> ref = character.getEquipmentSetRef();
            ref.addReferenceListener(this);
            this.setEquipmentList(ref.getReference().getEquippedItems());
            this.setEquipmentSet(ref.getReference());
        }

        @Override
        public void referenceChanged(ReferenceEvent<EquipmentSetFacade> e) {
            this.setEquipmentList(e.getNewReference().getEquippedItems());
            this.setEquipmentSet(e.getNewReference());
        }
    }

    private class EquipViewHandler
    extends AbstractAction {
        private EquipViewHandler() {
        }

        public void install() {
            EquipmentModels.this.equipViewBox.setAction(this);
            EquipmentModels.this.equipViewBox.setSelectedItem((Object)EquipmentModels.this.selectedView);
            EquipmentModels.this.equipmentTable.setModel(EquipmentModels.this.selectedModel);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EquipmentModels.this.selectedView = (EquipView)((Object)EquipmentModels.this.equipViewBox.getSelectedItem());
            switch (EquipmentModels.this.selectedView) {
                case FULL: {
                    EquipmentModels.this.selectedModel = EquipmentModels.this.fullModel;
                    EquipmentModels.this.equipAction.setEnabled(true);
                    break;
                }
                case UNEQUIPPED: {
                    EquipmentModels.this.selectedModel = EquipmentModels.this.unequippedModel;
                    EquipmentModels.this.equipAction.setEnabled(true);
                    break;
                }
                case EQUIPPED: {
                    EquipmentModels.this.selectedModel = EquipmentModels.this.equippedModel;
                    EquipmentModels.this.equipAction.setEnabled(false);
                }
            }
            EquipmentModels.this.equipmentTable.setModel(EquipmentModels.this.selectedModel);
            EquipmentModels.this.filterHandler.refilter();
        }
    }

    private class EquipFilterHandler
    implements FilterHandler {
        private EquipFilterHandler() {
        }

        @Override
        public void refilter() {
            EquipmentModels.this.selectedModel.refilter();
        }

        @Override
        public void setSearchEnabled(boolean enable) {
        }

        @Override
        public void scrollToTop() {
        }
    }

    public static enum EquipView {
        FULL,
        UNEQUIPPED,
        EQUIPPED;


        public String toString() {
            switch (this) {
                case FULL: {
                    return LanguageBundle.getString("in_equipListFull");
                }
                case UNEQUIPPED: {
                    return LanguageBundle.getString("in_equipListUnequipped");
                }
                case EQUIPPED: {
                    return LanguageBundle.getString("in_equipListEquipped");
                }
            }
            throw new InternalError();
        }
    }
}

