/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.prefs;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.apache.commons.lang.BooleanUtils;
import pcgen.cdom.enumeration.SkillFilter;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui2.UIPropertyContext;
import pcgen.gui2.prefs.PCGenPrefsPanel;
import pcgen.gui2.tools.Utility;
import pcgen.gui2.util.JComboBoxEx;
import pcgen.system.ConfigurationSettings;
import pcgen.system.LanguageBundle;
import pcgen.system.PCGenSettings;

public class OutputPanel
extends PCGenPrefsPanel {
    private static String in_output = LanguageBundle.getString("in_Prefs_output");
    private static String in_alwaysOverwrite = LanguageBundle.getString("in_Prefs_alwaysOverwrite");
    private static String in_invalidToHitText = LanguageBundle.getString("in_Prefs_invalidToHitText");
    private static String in_invalidDmgText = LanguageBundle.getString("in_Prefs_invalidDmgText");
    private static String in_outputSheetEqSet = LanguageBundle.getString("in_Prefs_templateEqSet");
    private static String in_paperType = LanguageBundle.getString("in_Prefs_paperType");
    private static String in_postExportCommandStandard = LanguageBundle.getString("in_Prefs_postExportCommandStandard");
    private static String in_postExportCommandPDF = LanguageBundle.getString("in_Prefs_postExportCommandPDF");
    private static String in_removeTemp = LanguageBundle.getString("in_Prefs_removeTemp");
    private static String in_saveOutputSheetWithPC = LanguageBundle.getString("in_Prefs_saveOutputSheetWithPC");
    private static String in_showSingleBoxPerBundle = LanguageBundle.getString("in_Prefs_showSingleBoxPerBundle");
    private static String in_weaponProfPrintout = LanguageBundle.getString("in_Prefs_weaponProfPrintout");
    private static String in_skillFilter = LanguageBundle.getString("in_Prefs_skillFilterLabel");
    private static String in_choose = LanguageBundle.getString("...");
    private static String in_generateTempFileWithPdf = LanguageBundle.getString("in_Prefs_generateTempFileWithPdf");
    private JCheckBox printSpellsWithPC = new JCheckBox();
    private JCheckBox removeTempFiles = new JCheckBox(in_removeTemp);
    private JCheckBox saveOutputSheetWithPC = new JCheckBox();
    private JCheckBox generateTempFileWithPdf = new JCheckBox(in_generateTempFileWithPdf);
    private JCheckBox weaponProfPrintout;
    private JButton outputSheetEqSetButton;
    private JButton outputSheetHTMLDefaultButton;
    private JButton outputSheetPDFDefaultButton;
    private JButton outputSheetSpellsDefaultButton;
    private JTextField outputSheetEqSet;
    private JTextField outputSheetHTMLDefault;
    private JTextField outputSheetPDFDefault;
    private JTextField outputSheetSpellsDefault;
    private JComboBoxEx paperType = new JComboBoxEx();
    private JComboBoxEx skillFilter = new JComboBoxEx();
    private JComboBox exportChoice = new JComboBox<ExportChoices>(ExportChoices.values());
    private JTextField postExportCommandStandard;
    private JTextField postExportCommandPDF;
    private JTextField invalidToHitText;
    private JTextField invalidDmgText;
    private JCheckBox alwaysOverwrite;
    private JCheckBox showSingleBoxPerBundle;
    private String[] paperNames = null;
    private PrefsButtonListener prefsButtonHandler = new PrefsButtonListener();
    private final TextFocusLostListener textFieldListener = new TextFocusLostListener();

    public OutputPanel() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        Border etched = null;
        TitledBorder title1 = BorderFactory.createTitledBorder(etched, in_output);
        title1.setTitleJustification(4);
        this.setBorder(title1);
        this.setLayout(gridbag);
        c.fill = 1;
        c.anchor = 21;
        c.insets = new Insets(2, 2, 2, 2);
        Utility.buildConstraints(c, 0, 0, 1, 1, 0.0, 0.0);
        JLabel label = new JLabel(LanguageBundle.getString("in_Prefs_outputSheetHTMLDefault"));
        gridbag.setConstraints(label, c);
        this.add(label);
        Utility.buildConstraints(c, 1, 0, 1, 1, 1.0, 0.0);
        this.outputSheetHTMLDefault = new JTextField(String.valueOf(SettingsHandler.getSelectedCharacterHTMLOutputSheet(null)));
        this.outputSheetHTMLDefault.addFocusListener(this.textFieldListener);
        gridbag.setConstraints(this.outputSheetHTMLDefault, c);
        this.add(this.outputSheetHTMLDefault);
        Utility.buildConstraints(c, 2, 0, 1, 1, 0.0, 0.0);
        this.outputSheetHTMLDefaultButton = this.createChooseButton();
        gridbag.setConstraints(this.outputSheetHTMLDefaultButton, c);
        this.add(this.outputSheetHTMLDefaultButton);
        this.outputSheetHTMLDefaultButton.addActionListener(this.prefsButtonHandler);
        Utility.buildConstraints(c, 0, 1, 1, 1, 0.0, 0.0);
        label = new JLabel(LanguageBundle.getString("in_Prefs_outputSheetPDFDefault"));
        gridbag.setConstraints(label, c);
        this.add(label);
        Utility.buildConstraints(c, 1, 1, 1, 1, 1.0, 0.0);
        this.outputSheetPDFDefault = new JTextField(String.valueOf(SettingsHandler.getSelectedCharacterPDFOutputSheet(null)));
        this.outputSheetPDFDefault.addFocusListener(this.textFieldListener);
        gridbag.setConstraints(this.outputSheetPDFDefault, c);
        this.add(this.outputSheetPDFDefault);
        Utility.buildConstraints(c, 2, 1, 1, 1, 0.0, 0.0);
        this.outputSheetPDFDefaultButton = this.createChooseButton();
        gridbag.setConstraints(this.outputSheetPDFDefaultButton, c);
        this.add(this.outputSheetPDFDefaultButton);
        this.outputSheetPDFDefaultButton.addActionListener(this.prefsButtonHandler);
        Utility.buildConstraints(c, 0, 2, 1, 1, 0.0, 0.0);
        label = new JLabel(in_outputSheetEqSet);
        gridbag.setConstraints(label, c);
        this.add(label);
        Utility.buildConstraints(c, 1, 2, 1, 1, 0.0, 0.0);
        this.outputSheetEqSet = new JTextField(String.valueOf(SettingsHandler.getSelectedEqSetTemplate()));
        this.outputSheetEqSet.addFocusListener(this.textFieldListener);
        gridbag.setConstraints(this.outputSheetEqSet, c);
        this.add(this.outputSheetEqSet);
        Utility.buildConstraints(c, 2, 2, 1, 1, 0.0, 0.0);
        this.outputSheetEqSetButton = this.createChooseButton();
        gridbag.setConstraints(this.outputSheetEqSetButton, c);
        this.add(this.outputSheetEqSetButton);
        this.outputSheetEqSetButton.addActionListener(this.prefsButtonHandler);
        Utility.buildConstraints(c, 0, 3, 3, 1, 0.0, 0.0);
        this.saveOutputSheetWithPC.setText(in_saveOutputSheetWithPC);
        gridbag.setConstraints(this.saveOutputSheetWithPC, c);
        this.add(this.saveOutputSheetWithPC);
        Utility.buildConstraints(c, 0, 4, 1, 1, 0.0, 0.0);
        label = new JLabel(LanguageBundle.getString("in_Prefs_outputSpellSheetDefault"));
        gridbag.setConstraints(label, c);
        this.add(label);
        Utility.buildConstraints(c, 1, 4, 1, 1, 0.0, 0.0);
        this.outputSheetSpellsDefault = new JTextField(String.valueOf(SettingsHandler.getSelectedSpellSheet()));
        this.outputSheetSpellsDefault.addFocusListener(this.textFieldListener);
        gridbag.setConstraints(this.outputSheetSpellsDefault, c);
        this.add(this.outputSheetSpellsDefault);
        Utility.buildConstraints(c, 2, 4, 1, 1, 0.0, 0.0);
        this.outputSheetSpellsDefaultButton = this.createChooseButton();
        gridbag.setConstraints(this.outputSheetSpellsDefaultButton, c);
        this.add(this.outputSheetSpellsDefaultButton);
        this.outputSheetSpellsDefaultButton.addActionListener(this.prefsButtonHandler);
        Utility.buildConstraints(c, 0, 5, 3, 1, 0.0, 0.0);
        this.printSpellsWithPC.setText(LanguageBundle.getString("in_Prefs_printSpellsWithPC"));
        gridbag.setConstraints(this.printSpellsWithPC, c);
        this.add(this.printSpellsWithPC);
        Utility.buildConstraints(c, 0, 6, 1, 1, 0.0, 0.0);
        label = new JLabel(in_paperType);
        gridbag.setConstraints(label, c);
        this.add(label);
        Utility.buildConstraints(c, 1, 6, 2, 1, 0.0, 0.0);
        int paperCount = Globals.getPaperCount();
        this.paperNames = new String[paperCount];
        for (int i = 0; i < paperCount; ++i) {
            this.paperNames[i] = Globals.getPaperInfo(i, 0);
        }
        this.paperType = new JComboBoxEx(this.paperNames);
        gridbag.setConstraints(this.paperType, c);
        this.add(this.paperType);
        Utility.buildConstraints(c, 0, 7, 3, 1, 0.0, 0.0);
        gridbag.setConstraints(this.removeTempFiles, c);
        this.add(this.removeTempFiles);
        Utility.buildConstraints(c, 0, 8, 3, 1, 0.0, 0.0);
        this.weaponProfPrintout = new JCheckBox(in_weaponProfPrintout, SettingsHandler.getWeaponProfPrintout());
        gridbag.setConstraints(this.weaponProfPrintout, c);
        this.add(this.weaponProfPrintout);
        Utility.buildConstraints(c, 0, 9, 1, 1, 0.0, 0.0);
        label = new JLabel(in_postExportCommandStandard);
        gridbag.setConstraints(label, c);
        this.add(label);
        Utility.buildConstraints(c, 1, 9, 2, 1, 0.0, 0.0);
        this.postExportCommandStandard = new JTextField(String.valueOf(SettingsHandler.getPostExportCommandStandard()));
        gridbag.setConstraints(this.postExportCommandStandard, c);
        this.add(this.postExportCommandStandard);
        Utility.buildConstraints(c, 0, 10, 1, 1, 0.0, 0.0);
        label = new JLabel(in_postExportCommandPDF);
        gridbag.setConstraints(label, c);
        this.add(label);
        Utility.buildConstraints(c, 1, 10, 2, 1, 0.0, 0.0);
        this.postExportCommandPDF = new JTextField(String.valueOf(SettingsHandler.getPostExportCommandPDF()));
        gridbag.setConstraints(this.postExportCommandPDF, c);
        this.add(this.postExportCommandPDF);
        Utility.buildConstraints(c, 0, 11, 1, 1, 0.0, 0.0);
        label = new JLabel(in_skillFilter);
        gridbag.setConstraints(label, c);
        this.add(label);
        Utility.buildConstraints(c, 1, 11, 0, 1, 0.0, 0.0);
        this.skillFilter.setModel(new DefaultComboBoxModel<SkillFilter>(new SkillFilter[]{SkillFilter.Ranks, SkillFilter.NonDefault, SkillFilter.Usable, SkillFilter.All}));
        this.skillFilter.setSelectedItem((Object)SkillFilter.getByValue(PCGenSettings.OPTIONS_CONTEXT.initInt("skillsOutputFilter", SkillFilter.Usable.getValue())));
        gridbag.setConstraints(this.skillFilter, c);
        this.add(this.skillFilter);
        Utility.buildConstraints(c, 0, 12, 1, 1, 0.0, 0.0);
        label = new JLabel(in_invalidToHitText);
        gridbag.setConstraints(label, c);
        this.add(label);
        Utility.buildConstraints(c, 1, 12, 2, 1, 0.0, 0.0);
        this.invalidToHitText = new JTextField(String.valueOf(SettingsHandler.getInvalidToHitText()));
        gridbag.setConstraints(this.invalidToHitText, c);
        this.add(this.invalidToHitText);
        Utility.buildConstraints(c, 0, 13, 1, 1, 0.0, 0.0);
        label = new JLabel(in_invalidDmgText);
        gridbag.setConstraints(label, c);
        this.add(label);
        Utility.buildConstraints(c, 1, 13, 0, 1, 0.0, 0.0);
        this.invalidDmgText = new JTextField(String.valueOf(SettingsHandler.getInvalidDmgText()));
        gridbag.setConstraints(this.invalidDmgText, c);
        this.add(this.invalidDmgText);
        Utility.buildConstraints(c, 0, 14, 3, 1, 0.0, 0.0);
        this.alwaysOverwrite = new JCheckBox(in_alwaysOverwrite, SettingsHandler.getAlwaysOverwrite());
        gridbag.setConstraints(this.alwaysOverwrite, c);
        this.add(this.alwaysOverwrite);
        Utility.buildConstraints(c, 0, 15, 3, 1, 0.0, 0.0);
        this.showSingleBoxPerBundle = new JCheckBox(in_showSingleBoxPerBundle, SettingsHandler.getShowSingleBoxPerBundle());
        gridbag.setConstraints(this.showSingleBoxPerBundle, c);
        this.add(this.showSingleBoxPerBundle);
        Utility.buildConstraints(c, 0, 16, 1, 1, 0.0, 0.0);
        label = new JLabel(LanguageBundle.getString("in_Prefs_exportChoice"));
        gridbag.setConstraints(label, c);
        this.add(label);
        Utility.buildConstraints(c, 1, 16, 0, 1, 0.0, 0.0);
        gridbag.setConstraints(this.exportChoice, c);
        this.add(this.exportChoice);
        Utility.buildConstraints(c, 0, 17, 3, 1, 0.0, 0.0);
        gridbag.setConstraints(this.generateTempFileWithPdf, c);
        this.add(this.generateTempFileWithPdf);
        Utility.buildConstraints(c, 0, 20, 3, 1, 1.0, 1.0);
        c.fill = 1;
        label = new JLabel(" ");
        gridbag.setConstraints(label, c);
        this.add(label);
    }

    private JButton createChooseButton() {
        JButton button = new JButton(in_choose);
        button.setMargin(new Insets(0, 3, 0, 3));
        return button;
    }

    @Override
    public String getTitle() {
        return in_output;
    }

    @Override
    public void setOptionsBasedOnControls() {
        UIPropertyContext context = UIPropertyContext.getInstance();
        Globals.selectPaper((String)this.paperType.getSelectedItem());
        context.setBoolean("cleanupTempFiles", this.removeTempFiles.isSelected());
        if (SettingsHandler.getWeaponProfPrintout() != this.weaponProfPrintout.isSelected()) {
            SettingsHandler.setWeaponProfPrintout(this.weaponProfPrintout.isSelected());
        }
        if (SettingsHandler.getAlwaysOverwrite() || this.alwaysOverwrite.isSelected()) {
            SettingsHandler.setAlwaysOverwrite(this.alwaysOverwrite.isSelected());
        }
        if (SettingsHandler.getShowSingleBoxPerBundle() || this.showSingleBoxPerBundle.isSelected()) {
            SettingsHandler.setShowSingleBoxPerBundle(this.showSingleBoxPerBundle.isSelected());
        }
        context.setProperty("defaultHtmlOutputSheet", this.outputSheetHTMLDefault.getText());
        context.setProperty("defaultPdfOutputSheet", this.outputSheetPDFDefault.getText());
        SettingsHandler.setSelectedEqSetTemplate(this.outputSheetEqSet.getText());
        context.setBoolean("saveOutputSheetWithPC", this.saveOutputSheetWithPC.isSelected());
        SettingsHandler.setSelectedSpellSheet(this.outputSheetSpellsDefault.getText());
        SettingsHandler.setPrintSpellsWithPC(this.printSpellsWithPC.isSelected());
        SettingsHandler.setPostExportCommandStandard(this.postExportCommandStandard.getText());
        SettingsHandler.setPostExportCommandPDF(this.postExportCommandPDF.getText());
        SettingsHandler.setInvalidToHitText(this.invalidToHitText.getText());
        SettingsHandler.setInvalidDmgText(this.invalidDmgText.getText());
        PCGenSettings.OPTIONS_CONTEXT.setInt("skillsOutputFilter", ((SkillFilter)((Object)this.skillFilter.getSelectedItem())).getValue());
        ExportChoices choice = (ExportChoices)((Object)this.exportChoice.getSelectedItem());
        context.setProperty("alwaysOpenExportFile", choice.getValue());
        PCGenSettings.OPTIONS_CONTEXT.setBoolean("generateTempFileWithPdf", this.generateTempFileWithPdf.isSelected());
    }

    @Override
    public void applyOptionValuesToControls() {
        UIPropertyContext context = UIPropertyContext.getInstance();
        this.paperType.setSelectedIndex(Globals.getSelectedPaper());
        this.weaponProfPrintout.setSelected(SettingsHandler.getWeaponProfPrintout());
        this.outputSheetHTMLDefault.setText(context.getProperty("defaultHtmlOutputSheet"));
        this.outputSheetPDFDefault.setText(context.getProperty("defaultPdfOutputSheet"));
        this.saveOutputSheetWithPC.setSelected(context.getBoolean("saveOutputSheetWithPC"));
        this.removeTempFiles.setSelected(context.initBoolean("cleanupTempFiles", true));
        this.printSpellsWithPC.setSelected(SettingsHandler.getPrintSpellsWithPC());
        this.skillFilter.setSelectedItem((Object)SkillFilter.getByValue(PCGenSettings.OPTIONS_CONTEXT.initInt("skillsOutputFilter", SkillFilter.Usable.getValue())));
        String value = context.getProperty("alwaysOpenExportFile");
        this.exportChoice.setSelectedItem((Object)ExportChoices.getChoice(value));
        this.generateTempFileWithPdf.setSelected(PCGenSettings.OPTIONS_CONTEXT.initBoolean("generateTempFileWithPdf", false));
    }

    private static enum ExportChoices {
        ASK{

            public String toString() {
                return LanguageBundle.getString("in_Prefs_ask");
            }
        }
        ,
        ALWAYS_OPEN{

            public String toString() {
                return LanguageBundle.getString("in_Prefs_alwaysOpen");
            }
        }
        ,
        NEVER_OPEN{

            public String toString() {
                return LanguageBundle.getString("in_Prefs_neverOpen");
            }
        };


        public String getValue() {
            switch (this) {
                case ASK: {
                    return "";
                }
                case ALWAYS_OPEN: {
                    return "true";
                }
                case NEVER_OPEN: {
                    return "false";
                }
            }
            throw new InternalError();
        }

        public static ExportChoices getChoice(String value) {
            Boolean choice = BooleanUtils.toBooleanObject(value);
            if (choice == null) {
                return ASK;
            }
            if (choice.booleanValue()) {
                return ALWAYS_OPEN;
            }
            return NEVER_OPEN;
        }
    }

    private final class TextFocusLostListener
    implements FocusListener {
        private String initialValue = null;
        private boolean dialogOpened = false;

        private TextFocusLostListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.dialogOpened = false;
            Object source = e.getSource();
            if (source instanceof JTextField) {
                this.initialValue = ((JTextField)source).getText();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            String fieldValue;
            File fieldFile;
            Object source = e.getSource();
            if (source instanceof JTextField && !(fieldFile = new File(fieldValue = ((JTextField)source).getText())).exists() && !fieldValue.equalsIgnoreCase("null") && fieldValue.trim().length() > 0 && !this.dialogOpened) {
                this.dialogOpened = true;
                ShowMessageDelegate.showMessageDialog("File does not exist; preferences were not set.", "Invalid Path", MessageType.ERROR);
                ((JTextField)source).setText(this.initialValue);
            }
        }
    }

    private final class PrefsButtonListener
    implements ActionListener {
        private PrefsButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JButton source = (JButton)actionEvent.getSource();
            if (source != null) {
                if (source == OutputPanel.this.outputSheetHTMLDefaultButton) {
                    JFileChooser fc = new JFileChooser();
                    fc.setDialogTitle(LanguageBundle.getString("in_Prefs_outputSheetHTMLDefaultTitle"));
                    fc.setCurrentDirectory(new File(SettingsHandler.getHTMLOutputSheetPath()));
                    fc.setSelectedFile(new File(SettingsHandler.getSelectedCharacterHTMLOutputSheet(null)));
                    if (fc.showOpenDialog(OutputPanel.this.getParent()) == 0) {
                        File newTemplate = fc.getSelectedFile();
                        if (newTemplate.isDirectory() || !newTemplate.getName().startsWith("csheet") && !newTemplate.getName().startsWith("psheet")) {
                            ShowMessageDelegate.showMessageDialog(LanguageBundle.getString("in_Prefs_outputSheetDefaultError"), "PCGen", MessageType.ERROR);
                        } else if (newTemplate.getName().startsWith("csheet")) {
                            SettingsHandler.setSelectedCharacterHTMLOutputSheet(newTemplate.getAbsolutePath(), null);
                        } else {
                            SettingsHandler.setSelectedPartyHTMLOutputSheet(newTemplate.getAbsolutePath());
                        }
                    }
                    OutputPanel.this.outputSheetHTMLDefault.setText(String.valueOf(SettingsHandler.getSelectedCharacterHTMLOutputSheet(null)));
                } else if (source == OutputPanel.this.outputSheetPDFDefaultButton) {
                    JFileChooser fc = new JFileChooser();
                    fc.setDialogTitle(LanguageBundle.getString("in_Prefs_outputSheetPDFDefaultTitle"));
                    fc.setCurrentDirectory(new File(SettingsHandler.getPDFOutputSheetPath()));
                    fc.setSelectedFile(new File(SettingsHandler.getSelectedCharacterPDFOutputSheet(null)));
                    if (fc.showOpenDialog(OutputPanel.this.getParent()) == 0) {
                        File newTemplate = fc.getSelectedFile();
                        if (newTemplate.isDirectory() || !newTemplate.getName().startsWith("csheet") && !newTemplate.getName().startsWith("psheet")) {
                            ShowMessageDelegate.showMessageDialog(LanguageBundle.getString("in_Prefs_outputSheetDefaultError"), "PCGen", MessageType.ERROR);
                        } else if (newTemplate.getName().startsWith("csheet")) {
                            SettingsHandler.setSelectedCharacterPDFOutputSheet(newTemplate.getAbsolutePath(), null);
                        } else {
                            SettingsHandler.setSelectedPartyPDFOutputSheet(newTemplate.getAbsolutePath());
                        }
                    }
                    OutputPanel.this.outputSheetPDFDefault.setText(String.valueOf(SettingsHandler.getSelectedCharacterPDFOutputSheet(null)));
                } else if (source == OutputPanel.this.outputSheetEqSetButton) {
                    JFileChooser fc = new JFileChooser();
                    fc.setDialogTitle(LanguageBundle.getString("in_Prefs_templateEqSetTitle"));
                    fc.setCurrentDirectory(new File(ConfigurationSettings.getOutputSheetsDir()));
                    fc.setSelectedFile(new File(SettingsHandler.getSelectedEqSetTemplate()));
                    if (fc.showOpenDialog(OutputPanel.this.getParent()) == 0) {
                        File newTemplate = fc.getSelectedFile();
                        if (newTemplate.isDirectory() || !newTemplate.getName().startsWith("eqsheet")) {
                            ShowMessageDelegate.showMessageDialog(LanguageBundle.getString("in_Prefs_templateEqSetError"), "PCGen", MessageType.ERROR);
                        } else {
                            SettingsHandler.setSelectedEqSetTemplate(newTemplate.getAbsolutePath());
                        }
                    }
                    OutputPanel.this.outputSheetEqSet.setText(String.valueOf(SettingsHandler.getSelectedEqSetTemplate()));
                } else if (source == OutputPanel.this.outputSheetSpellsDefaultButton) {
                    JFileChooser fc = new JFileChooser();
                    fc.setDialogTitle(LanguageBundle.getString("in_Prefs_outputSpellSheetDefault"));
                    fc.setCurrentDirectory(new File(ConfigurationSettings.getOutputSheetsDir()));
                    if (PCGenSettings.getSelectedSpellSheet() != null) {
                        fc.setSelectedFile(new File(PCGenSettings.getSelectedSpellSheet()));
                    }
                    if (fc.showOpenDialog(OutputPanel.this.getParent()) == 0) {
                        File newTemplate = fc.getSelectedFile();
                        if (newTemplate.isDirectory() || !newTemplate.getName().startsWith("csheet")) {
                            ShowMessageDelegate.showMessageDialog(LanguageBundle.getString("in_Prefs_outputSheetDefaultError"), "PCGen", MessageType.ERROR);
                        } else {
                            PCGenSettings.getInstance().setProperty("pcgen.files.selectedSpellOutputSheet", newTemplate.getAbsolutePath());
                        }
                    }
                    OutputPanel.this.outputSheetSpellsDefault.setText(PCGenSettings.getSelectedSpellSheet());
                }
            }
        }
    }
}

