/*
 * Decompiled with CFR 0.152.
 */
package pcgen.facade.util;

import pcgen.facade.util.AbstractListFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.event.ListEvent;
import pcgen.facade.util.event.ListListener;

public class DelegatingListFacade<E>
extends AbstractListFacade<E>
implements ListListener<E> {
    private ListFacade<E> delegate = null;

    public DelegatingListFacade() {
    }

    public DelegatingListFacade(ListFacade<E> delegate) {
        this.setDelegate(delegate);
    }

    @Override
    public E getElementAt(int index) {
        if (this.delegate == null) {
            throw new IllegalStateException();
        }
        return this.delegate.getElementAt(index);
    }

    @Override
    public int getSize() {
        if (this.delegate == null) {
            return 0;
        }
        return this.delegate.getSize();
    }

    public void setDelegate(ListFacade<E> list) {
        if (this.delegate == null && list == null) {
            return;
        }
        ListFacade<E> oldList = this.delegate;
        if (oldList == list) {
            return;
        }
        if (oldList != null) {
            oldList.removeListListener(this);
        }
        this.delegate = list;
        if (list != null) {
            list.addListListener(this);
        }
        this.fireElementsChanged(this);
    }

    @Override
    public void elementAdded(ListEvent<E> e) {
        this.fireElementAdded(this, e.getElement(), e.getIndex());
    }

    @Override
    public void elementRemoved(ListEvent<E> e) {
        this.fireElementRemoved(this, e.getElement(), e.getIndex());
    }

    @Override
    public void elementsChanged(ListEvent<E> e) {
        this.fireElementsChanged(this);
    }

    @Override
    public void elementModified(ListEvent<E> e) {
        this.fireElementModified(this, e.getElement(), e.getIndex());
    }
}

