/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.util.List;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Kit;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.SubClass;
import pcgen.core.analysis.SubClassApplication;
import pcgen.core.kit.BaseKit;
import pcgen.core.prereq.PrereqHandler;
import pcgen.gui2.UIPropertyContext;

public class KitClass
extends BaseKit {
    private CDOMSingleRef<PCClass> pcClass;
    private Formula levelFormula;
    private CDOMReference<SubClass> subClass;
    private transient PCClass theClass = null;
    private String theOrigSubClass = null;
    private transient int theLevel = -1;
    private transient boolean doLevelAbilities = true;

    public String toString() {
        StringBuilder ret = new StringBuilder(100);
        ret.append(this.pcClass.getLSTformat(false));
        if (this.subClass != null) {
            ret.append("(").append(this.subClass.getLSTformat(false)).append(")");
        }
        ret.append(this.levelFormula);
        return ret.toString();
    }

    @Override
    public boolean testApply(Kit aKit, PlayerCharacter aPC, List<String> warnings) {
        this.theLevel = -1;
        this.doLevelAbilities = true;
        this.theClass = this.pcClass.resolvesTo();
        this.theOrigSubClass = aPC.getSubClassName(this.theClass);
        this.applySubClass(aPC);
        if (!PrereqHandler.passesAll(this.theClass.getPrerequisiteList(), aPC, aKit)) {
            PrereqHandler.toHtmlString(this.theClass.getPrerequisiteList());
            warnings.add("CLASS: Not qualified for class \"" + this.theClass.getKeyName() + "\".");
            return false;
        }
        this.doLevelAbilities = aKit.doLevelAbilities();
        this.theLevel = this.levelFormula.resolve(aPC, "").intValue();
        this.addLevel(aPC, this.theLevel, this.theClass, this.doLevelAbilities);
        return true;
    }

    private void applySubClass(PlayerCharacter aPC) {
        if (this.subClass != null) {
            PCClass heldClass = aPC.getClassKeyed(this.theClass.getKeyName());
            if (heldClass == null) {
                aPC.incrementClassLevel(0, this.theClass);
                heldClass = aPC.getClassKeyed(this.theClass.getKeyName());
            }
            SubClassApplication.setSubClassKey(aPC, heldClass, this.getSubClass().getLSTformat(false));
        }
    }

    @Override
    public void apply(PlayerCharacter aPC) {
        this.applySubClass(aPC);
        this.addLevel(aPC, this.theLevel, this.theClass, this.doLevelAbilities);
        if (this.theOrigSubClass != null) {
            SubClassApplication.setSubClassKey(aPC, this.theClass, this.theOrigSubClass);
        }
        this.theClass = null;
    }

    private void addLevel(PlayerCharacter pc, int numLevels, PCClass aClass, boolean doLevelAbilitiesIn) {
        boolean tempShowHP = SettingsHandler.getShowHPDialogAtLevelUp();
        SettingsHandler.setShowHPDialogAtLevelUp(false);
        int tempChoicePref = UIPropertyContext.getSingleChoiceAction();
        UIPropertyContext.setSingleChoiceAction(2);
        boolean tempDoLevelAbilities = pc.doLevelAbilities();
        pc.setDoLevelAbilities(doLevelAbilitiesIn);
        pc.incrementClassLevel(numLevels, aClass, true);
        pc.setDoLevelAbilities(tempDoLevelAbilities);
        UIPropertyContext.setSingleChoiceAction(tempChoicePref);
        SettingsHandler.setShowHPDialogAtLevelUp(tempShowHP);
    }

    @Override
    public String getObjectName() {
        return "Classes";
    }

    public void setPcclass(CDOMSingleRef<PCClass> ref) {
        this.pcClass = ref;
    }

    public CDOMReference<PCClass> getPcclass() {
        return this.pcClass;
    }

    public void setLevel(Formula formula) {
        this.levelFormula = formula;
    }

    public Formula getLevel() {
        return this.levelFormula;
    }

    public void setSubClass(CDOMReference<SubClass> sc) {
        this.subClass = sc;
    }

    public CDOMReference<SubClass> getSubClass() {
        return this.subClass;
    }
}

