/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.enumeration.Gender;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.PlayerCharacter;
import pcgen.core.kit.BaseKit;

public class KitBio
extends BaseKit {
    private String theCharacterName = null;
    private Integer theCharacterAge = null;
    private List<Gender> theGenders = null;
    private transient Gender selectedGender = null;

    public void setCharacterName(String aName) {
        this.theCharacterName = aName;
    }

    public String getCharacterName() {
        return this.theCharacterName;
    }

    public void setCharacterAge(Integer age) {
        this.theCharacterAge = age;
    }

    public Integer getCharacterAge() {
        return this.theCharacterAge;
    }

    @Override
    public void apply(PlayerCharacter aPC) {
        if (this.theCharacterName != null) {
            aPC.setName(this.theCharacterName);
        }
        if (this.theCharacterAge != null) {
            aPC.setAge(this.theCharacterAge);
        }
        if (this.selectedGender != null) {
            aPC.setGender(this.selectedGender);
        }
    }

    @Override
    public String getObjectName() {
        return "Bio Settings";
    }

    @Override
    public boolean testApply(Kit aKit, PlayerCharacter aPC, List<String> warnings) {
        this.selectedGender = null;
        if (this.theGenders != null && !this.theGenders.isEmpty()) {
            if (this.theGenders.size() > 1) {
                List<Object> selList = new ArrayList(1);
                if ((selList = Globals.getChoiceFromList("Choose Gender", this.theGenders, selList, 1, aPC)).size() == 1) {
                    this.selectedGender = (Gender)selList.get(0);
                }
            } else {
                this.selectedGender = this.theGenders.get(0);
            }
        }
        this.apply(aPC);
        return true;
    }

    public String toString() {
        StringBuilder info = new StringBuilder();
        if (this.theCharacterName != null) {
            info.append(" Name: " + this.theCharacterName);
        }
        if (this.theGenders != null) {
            info.append(" Gender: " + StringUtil.join(this.theGenders, (String)", "));
        }
        if (this.theCharacterAge != null) {
            info.append(" Age: " + this.theCharacterAge);
        }
        return info.toString();
    }

    public void addGender(Gender gender) {
        if (this.theGenders == null) {
            this.theGenders = new ArrayList<Gender>();
        }
        if (this.theGenders.contains(gender)) {
            throw new IllegalArgumentException("Cannot add Gender: " + gender + " twice");
        }
        this.theGenders.add(gender);
    }

    public Collection<Gender> getGenders() {
        return this.theGenders;
    }
}

