/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.ConcretePrereqObject;
import pcgen.cdom.base.Loadable;
import pcgen.cdom.helper.OptionBound;
import pcgen.core.Kit;
import pcgen.core.PlayerCharacter;

public abstract class BaseKit
extends ConcretePrereqObject
implements Loadable {
    private URI sourceURI;
    List<OptionBound> bounds;

    public void setOptionBounds(Formula min, Formula max) {
        if (this.bounds == null) {
            this.bounds = new ArrayList<OptionBound>();
        }
        this.bounds.add(new OptionBound(min, max));
    }

    public boolean isOption(PlayerCharacter pc, int val) {
        if (this.bounds != null) {
            for (OptionBound bound : this.bounds) {
                if (!bound.isOption(pc, val)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isOptional() {
        return this.bounds != null;
    }

    public static String eval(PlayerCharacter aPC, String aValue) {
        String ret = aValue;
        int evalInd = aValue.indexOf("EVAL(");
        if (evalInd == -1) {
            return aValue;
        }
        while (evalInd != -1) {
            int endInd;
            String evalStr = aValue.substring(evalInd);
            StringBuilder modString = new StringBuilder();
            modString.append(aValue.substring(0, evalInd));
            int nestingLevel = 1;
            int startInd = 4;
            for (endInd = startInd + 1; endInd < aValue.length() - 1; ++endInd) {
                char c = evalStr.charAt(endInd);
                if (c == '(') {
                    ++nestingLevel;
                    continue;
                }
                if (c == ')' && --nestingLevel == 0) break;
            }
            if (nestingLevel != 0) {
                return aValue;
            }
            evalStr = evalStr.substring(5, endInd);
            int val = aPC.getVariableValue(evalStr, "").intValue();
            String evalVal = "" + val;
            modString.append(evalVal);
            modString.append(aValue.substring(endInd + 5));
            ret = modString.toString();
            evalInd = ret.indexOf("EVAL(");
        }
        return ret;
    }

    public abstract boolean testApply(Kit var1, PlayerCharacter var2, List<String> var3);

    public abstract void apply(PlayerCharacter var1);

    public abstract String getObjectName();

    public Collection<OptionBound> getBounds() {
        return this.bounds == null ? null : Collections.unmodifiableList(this.bounds);
    }

    @Override
    public URI getSourceURI() {
        return this.sourceURI;
    }

    @Override
    public void setSourceURI(URI source) {
        this.sourceURI = source;
    }

    @Override
    public String getDisplayName() {
        return null;
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public String getKeyName() {
        return null;
    }

    @Override
    public String getLSTformat() {
        return null;
    }

    @Override
    public boolean isInternal() {
        return false;
    }

    @Override
    public boolean isType(String type) {
        return false;
    }
}

