/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.analysis;

import pcgen.core.PlayerCharacter;
import pcgen.core.display.CharacterDisplay;
import pcgen.util.Delta;
import pcgen.util.enumeration.AttackType;

public class AttackInfo {
    public static String getAttackInfo(PlayerCharacter pc, AttackType attackType, String modifier) {
        if (modifier.equals("TOTAL")) {
            if (attackType.equals("RANGED")) {
                int total = AttackInfo.getTotalToken(pc, attackType);
                return pc.getAttackString(AttackType.RANGED, total);
            }
            if (attackType.equals("UNARMED")) {
                int total = AttackInfo.getTotalToken(pc, AttackType.MELEE);
                return pc.getAttackString(AttackType.MELEE, total);
            }
            int total = AttackInfo.getTotalToken(pc, attackType);
            return pc.getAttackString(AttackType.MELEE, total);
        }
        return AttackInfo.getSubToken(pc, attackType, modifier);
    }

    public static int getTotalToken(PlayerCharacter pc, AttackType at) {
        int tohitBonus = (int)pc.getTotalBonusTo("TOHIT", "TOHIT") + (int)pc.getTotalBonusTo("TOHIT", "TYPE." + (Object)((Object)at));
        int totalBonus = (int)pc.getTotalBonusTo("COMBAT", "TOHIT") + (int)pc.getTotalBonusTo("COMBAT", "TOHIT." + (Object)((Object)at));
        return tohitBonus + totalBonus;
    }

    public static String getSubToken(PlayerCharacter pc, AttackType attackType, String modifier) {
        if (modifier.equals("BASE")) {
            return Delta.toString(AttackInfo.getBaseToken(pc));
        }
        if (modifier.equals("EPIC")) {
            return Delta.toString(AttackInfo.getEpicToken(pc));
        }
        if (modifier.equals("MISC")) {
            return Delta.toString(AttackInfo.getMiscToken(pc, attackType));
        }
        if (modifier.equals("SIZE")) {
            return Delta.toString(AttackInfo.getSizeToken(pc, attackType));
        }
        if (modifier.equals("STAT")) {
            return Delta.toString(AttackInfo.getStatToken(pc.getDisplay(), attackType));
        }
        if (!modifier.equals("TOTAL")) {
            return pc.getAttackString(attackType);
        }
        return "";
    }

    public static int getBaseToken(PlayerCharacter pc) {
        return pc.baseAttackBonus();
    }

    public static int getEpicToken(PlayerCharacter pc) {
        return (int)pc.getBonusDueToType("COMBAT", "TOHIT", "EPIC");
    }

    public static int getMiscToken(PlayerCharacter pc, AttackType at) {
        int tohitBonus = (int)pc.getTotalBonusTo("TOHIT", "TOHIT") + (int)pc.getTotalBonusTo("TOHIT", "TYPE." + (Object)((Object)at)) - (int)pc.getDisplay().getStatBonusTo("TOHIT", "TYPE." + (Object)((Object)at)) - (int)pc.getSizeAdjustmentBonusTo("TOHIT", "TOHIT");
        int miscBonus = (int)pc.getTotalBonusTo("COMBAT", "TOHIT") + (int)pc.getTotalBonusTo("COMBAT", "TOHIT." + (Object)((Object)at)) - (int)pc.getDisplay().getStatBonusTo("COMBAT", "TOHIT." + (Object)((Object)at)) - (int)pc.getSizeAdjustmentBonusTo("COMBAT", "TOHIT") - (int)pc.getSizeAdjustmentBonusTo("COMBAT", "TOHIT." + (Object)((Object)at)) - (int)pc.getBonusDueToType("COMBAT", "TOHIT", "EPIC");
        return miscBonus + tohitBonus;
    }

    public static int getSizeToken(PlayerCharacter pc, AttackType aType) {
        int tohitBonus = (int)pc.getSizeAdjustmentBonusTo("TOHIT", "TOHIT") + (int)pc.getSizeAdjustmentBonusTo("TOHIT", "TYPE." + (Object)((Object)aType));
        int sizeBonus = (int)pc.getSizeAdjustmentBonusTo("COMBAT", "TOHIT") + (int)pc.getSizeAdjustmentBonusTo("COMBAT", "TOHIT." + (Object)((Object)aType));
        return sizeBonus + tohitBonus;
    }

    public static int getStatToken(CharacterDisplay display, AttackType at) {
        int tohitBonus = (int)display.getStatBonusTo("TOHIT", "TYPE." + (Object)((Object)at));
        int statBonus = (int)display.getStatBonusTo("COMBAT", "TOHIT." + (Object)((Object)at));
        return statBonus + tohitBonus;
    }
}

