/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.reference;

import java.util.Collection;
import java.util.Collections;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.cdom.reference.CDOMSingleRef;

public class CDOMSimpleSingleRef<T>
extends CDOMSingleRef<T> {
    private T referencedObject = null;
    private String choice = null;

    public CDOMSimpleSingleRef(Class<T> objClass, String key) {
        super(objClass, key);
    }

    @Override
    public boolean contains(T item) {
        if (this.referencedObject == null) {
            throw new IllegalStateException("Cannot ask for contains: " + this.getReferenceClass().getName() + " Reference " + this.getName() + " has not been resolved");
        }
        return this.referencedObject.equals(item);
    }

    @Override
    public T resolvesTo() {
        if (this.referencedObject == null) {
            throw new IllegalStateException("Cannot ask for resolution: Reference " + this.getName() + " has not been resolved");
        }
        return this.referencedObject;
    }

    @Override
    public boolean hasBeenResolved() {
        return this.referencedObject != null;
    }

    @Override
    public String getLSTformat(boolean useAny) {
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CDOMSimpleSingleRef) {
            CDOMSimpleSingleRef ref = (CDOMSimpleSingleRef)obj;
            return this.getReferenceClass().equals(ref.getReferenceClass()) && this.getName().equals(ref.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getReferenceClass().hashCode() ^ this.getName().hashCode();
    }

    @Override
    public void addResolution(T item) {
        if (this.referencedObject != null) {
            throw new IllegalStateException("Cannot resolve a Single Reference twice");
        }
        if (!item.getClass().equals(this.getReferenceClass())) {
            throw new IllegalArgumentException("Cannot resolve a " + this.getReferenceClass().getSimpleName() + " Reference to a " + item.getClass().getSimpleName());
        }
        this.referencedObject = item;
    }

    @Override
    public Collection<T> getContainedObjects() {
        if (this.referencedObject == null) {
            throw new IllegalStateException("Cannot ask for contains: " + this.getReferenceClass().getName() + " Reference " + this.getName() + " has not been resolved");
        }
        return Collections.singleton(this.referencedObject);
    }

    @Override
    public GroupingState getGroupingState() {
        return GroupingState.ALLOWS_UNION;
    }

    @Override
    public void setChoice(String c) {
        this.choice = c;
    }

    @Override
    public String getChoice() {
        return this.choice;
    }
}

