/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pcgen.base.util.ListSet;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.facet.base.AbstractDataFacet;

public abstract class AbstractSingleSourceListFacet<T, ST>
extends AbstractDataFacet<CharID, T> {
    public void add(CharID id, T obj, ST source) {
        if (obj == null) {
            throw new IllegalArgumentException("Object to add may not be null");
        }
        if (source == null) {
            throw new IllegalArgumentException("Source may not be null");
        }
        Map<T, ST> map = this.getConstructingCachedMap(id);
        ST oldsource = map.get(obj);
        boolean fireNew = oldsource == null;
        map.put(obj, source);
        if (fireNew) {
            this.fireDataFacetChangeEvent(id, obj, 0);
        }
    }

    public void addAll(CharID id, Collection<? extends T> c, ST source) {
        for (T obj : c) {
            this.add(id, obj, source);
        }
    }

    public void remove(CharID id, T obj, ST source) {
        Map<T, ST> componentMap = this.getCachedMap(id);
        if (componentMap != null) {
            this.processRemoval(id, componentMap, obj, source);
        }
    }

    public void removeAll(CharID id, Collection<T> c, ST source) {
        Map<T, ST> componentMap = this.getCachedMap(id);
        if (componentMap != null) {
            for (T obj : c) {
                this.processRemoval(id, componentMap, obj, source);
            }
        }
    }

    public Map<T, ST> removeAll(CharID id) {
        Map<T, ST> componentMap = this.getCachedMap(id);
        if (componentMap == null) {
            return Collections.emptyMap();
        }
        this.removeCache(id);
        for (T obj : componentMap.keySet()) {
            this.fireDataFacetChangeEvent(id, obj, 1);
        }
        return componentMap;
    }

    public Set<T> getSet(CharID id) {
        Map<T, ST> componentMap = this.getCachedMap(id);
        if (componentMap == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new ListSet(componentMap.keySet()));
    }

    public int getCount(CharID id) {
        Map<T, ST> componentMap = this.getCachedMap(id);
        if (componentMap == null) {
            return 0;
        }
        return componentMap.size();
    }

    public boolean isEmpty(CharID id) {
        Map<T, ST> componentMap = this.getCachedMap(id);
        return componentMap == null || componentMap.isEmpty();
    }

    public boolean contains(CharID id, T obj) {
        Map<T, ST> componentMap = this.getCachedMap(id);
        return componentMap != null && componentMap.containsKey(obj);
    }

    protected Map<T, ST> getCachedMap(CharID id) {
        return (Map)this.getCache(id);
    }

    private Map<T, ST> getConstructingCachedMap(CharID id) {
        Map<T, ST> componentMap = this.getCachedMap(id);
        if (componentMap == null) {
            componentMap = this.getComponentMap();
            this.setCache(id, componentMap);
        }
        return componentMap;
    }

    protected Map<T, ST> getComponentMap() {
        return new IdentityHashMap();
    }

    @Override
    public void copyContents(CharID source, CharID destination) {
        Map<T, ST> sourceMap = this.getCachedMap(source);
        if (sourceMap != null) {
            this.getConstructingCachedMap(destination).putAll(sourceMap);
        }
    }

    private void processRemoval(CharID id, Map<T, ST> componentMap, T obj, ST source) {
        ST oldSource = componentMap.get(obj);
        if (oldSource != null && oldSource.equals(source)) {
            componentMap.remove(obj);
            this.fireDataFacetChangeEvent(id, obj, 1);
        }
    }

    public void removeAll(CharID id, ST source) {
        Map<T, ST> componentMap = this.getCachedMap(id);
        if (componentMap != null) {
            ArrayList<T> removedKeys = new ArrayList<T>();
            Iterator<Map.Entry<T, ST>> it = componentMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<T, ST> me = it.next();
                ST currentsource = me.getValue();
                if (!currentsource.equals(source)) continue;
                T obj = me.getKey();
                it.remove();
                removedKeys.add(obj);
            }
            if (componentMap.isEmpty()) {
                this.removeCache(id);
            }
            for (Object obj : removedKeys) {
                this.fireDataFacetChangeEvent(id, obj, 1);
            }
        }
    }

    public List<? extends T> getSet(CharID id, ST owner) {
        ArrayList<T> list = new ArrayList<T>();
        Map<T, ST> componentMap = this.getCachedMap(id);
        if (componentMap != null) {
            for (Map.Entry<T, ST> me : componentMap.entrySet()) {
                ST source = me.getValue();
                if (!source.equals(owner)) continue;
                list.add(me.getKey());
            }
        }
        return Collections.unmodifiableList(list);
    }

    public ST getSource(CharID id, T obj) {
        Map<T, ST> map = this.getCachedMap(id);
        if (map == null) {
            return null;
        }
        return map.get(obj);
    }

    public void remove(CharID id, T obj) {
        Map<T, ST> map = this.getCachedMap(id);
        if (map != null && map.remove(obj) != null) {
            this.fireDataFacetChangeEvent(id, obj, 1);
        }
    }
}

