/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.choiceset;

import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import pcgen.cdom.base.PrimitiveChoiceSet;
import pcgen.cdom.choiceset.ChoiceSetUtilities;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.core.PlayerCharacter;
import pcgen.util.Logging;

public class CompoundAndChoiceSet<T>
implements PrimitiveChoiceSet<T> {
    private final Set<PrimitiveChoiceSet<T>> pcsSet = new TreeSet(ChoiceSetUtilities.WRITEABLE_SORTER);

    public CompoundAndChoiceSet(Collection<PrimitiveChoiceSet<T>> pcsCollection) {
        if (pcsCollection == null) {
            throw new IllegalArgumentException();
        }
        this.pcsSet.addAll(pcsCollection);
        if (this.pcsSet.size() != pcsCollection.size()) {
            if (Logging.isLoggable(Level.WARNING)) {
                Logging.log(Level.WARNING, "Found duplicate item in " + pcsCollection);
            }
            this.pcsSet.add(PrimitiveChoiceSet.INVALID);
        }
    }

    @Override
    public Collection<? extends T> getSet(PlayerCharacter pc) {
        Collection<T> returnSet = null;
        for (PrimitiveChoiceSet<T> cs : this.pcsSet) {
            if (returnSet == null) {
                returnSet = cs.getSet(pc);
                continue;
            }
            returnSet.retainAll(cs.getSet(pc));
        }
        return returnSet;
    }

    @Override
    public String getLSTformat(boolean useAny) {
        return ChoiceSetUtilities.joinLstFormat(this.pcsSet, ",", useAny);
    }

    @Override
    public Class<? super T> getChoiceClass() {
        return this.pcsSet == null ? null : this.pcsSet.iterator().next().getChoiceClass();
    }

    public int hashCode() {
        return this.pcsSet.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof CompoundAndChoiceSet && ((CompoundAndChoiceSet)obj).pcsSet.equals(this.pcsSet);
    }

    @Override
    public GroupingState getGroupingState() {
        GroupingState state = GroupingState.EMPTY;
        for (PrimitiveChoiceSet<T> pcs : this.pcsSet) {
            state = pcs.getGroupingState().add(state);
        }
        return state.compound(GroupingState.ALLOWS_INTERSECTION);
    }
}

