## What is Dagger?

Dagger is a tool that lets you replace your software project's artisanal scripts with a modern API and cross-language scripting engine.

1. Encapsulate all your project's tasks and workflows into simple functions, written in your programming language of choice
2. Dagger packages your functions into a custom GraphQL API
3. Run your functions from the CLI, your language interpreter, or a custom HTTP client
4. Package your functions into a module, to reuse in your next project or share with the community
5. Search the Daggerverse for existing modules, and import them into yours. All Dagger modules can reuse each other's functions - across language.

## Benefits to app teams

* Reduce complexity: even complex builds can be expressed as a few simple functions
* No more "push and pray": everything CI can do, your dev environment can do too
* Use the same language to develop your app and its scripts
* Easy onboarding of new developers: if you can build, test and deploy - they can too.
* Everything is cached by default: expect 2x to 10x speedups
* Parity between dev and CI environments
* Cross-team collaboration: reuse another team's workflows without learning their stack

## Benefits to platform teams

* Reduce CI lock-in. Dagger functions run on all major CI platforms - no proprietary DSL needed.
* Don't be a bottleneck. Let app teams write their own functions. Enable standardization by providing them a library of reusable components.
* Faster CI runs. CI pipelines that are "Daggerized" typically run 2x to 10x faster, thanks to caching and concurrency. This means developers waste less time waiting for CI, and you spend less money on CI compute.
* A viable platform strategy. App teams need flexibility, and you need control. Dagger gives you a way to reconcile the two, in an incremental way that leverages the stack you already have.

## Learn more

* [How does it work?](https://docs.dagger.io/#how-does-it-work)
* [Getting started](https://docs.dagger.io/#getting-started)
* [Examples](https://github.com/dagger/dagger/tree/main/examples)

## Join the community

* Join the [Dagger community server](https://discord.gg/ufnyBtc8uY)
* Follow us on [Twitter](https://twitter.com/dagger_io)
* Come to a [Dagger community call](https://dagger.io/events).

## Contributing

Interested in contributing or building dagger from scratch? See
[CONTRIBUTING.md](https://github.com/dagger/dagger/tree/main/CONTRIBUTING.md).
