/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.syncStorage;

import java.sql.SQLException;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.asamk.signal.manager.syncStorage.StorageRecordProcessor;
import org.asamk.signal.manager.syncStorage.StorageRecordUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.storage.SignalRecord;
import org.whispersystems.signalservice.api.storage.StorageId;

abstract class DefaultStorageRecordProcessor<E extends SignalRecord>
implements StorageRecordProcessor<E>,
Comparator<E> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultStorageRecordProcessor.class);
    private final Set<E> matchedRecords = new TreeSet(this);

    DefaultStorageRecordProcessor() {
    }

    @Override
    public void process(E remote) throws SQLException {
        if (this.isInvalid(remote)) {
            this.debug(remote.getId(), remote, "Found invalid key! Ignoring it.");
            return;
        }
        Optional<E> local = this.getMatching(remote);
        if (local.isEmpty()) {
            this.debug(remote.getId(), remote, "No matching local record. Inserting.");
            this.insertLocal(remote);
            return;
        }
        if (this.matchedRecords.contains(local.get())) {
            this.debug(remote.getId(), remote, "Multiple remote records map to the same local record " + String.valueOf(local.get()) + "! Ignoring this one.");
            return;
        }
        this.matchedRecords.add((SignalRecord)local.get());
        SignalRecord merged = this.merge(remote, (SignalRecord)local.get());
        if (!merged.equals(remote)) {
            this.debug(remote.getId(), remote, "[Remote Update] " + merged.describeDiff(remote));
        }
        if (!merged.equals(local.get())) {
            StorageRecordUpdate<SignalRecord> update = new StorageRecordUpdate<SignalRecord>((SignalRecord)local.get(), merged);
            this.debug(remote.getId(), remote, "[Local Update] " + String.valueOf(update));
            this.updateLocal(update);
        }
    }

    private void debug(StorageId i, E record, String message) {
        logger.debug("[" + String.valueOf(i) + "][" + record.getClass().getSimpleName() + "] " + message);
    }

    protected abstract boolean isInvalid(E var1) throws SQLException;

    protected abstract Optional<E> getMatching(E var1) throws SQLException;

    protected abstract E merge(E var1, E var2);

    protected abstract void insertLocal(E var1) throws SQLException;

    protected abstract void updateLocal(StorageRecordUpdate<E> var1) throws SQLException;
}

