/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import okio.ByteString;
import org.asamk.signal.manager.api.AttachmentInvalidException;
import org.asamk.signal.manager.api.GroupId;
import org.asamk.signal.manager.api.GroupIdV1;
import org.asamk.signal.manager.api.GroupIdV2;
import org.asamk.signal.manager.api.GroupInviteLinkUrl;
import org.asamk.signal.manager.api.GroupLinkState;
import org.asamk.signal.manager.api.GroupNotFoundException;
import org.asamk.signal.manager.api.GroupPermission;
import org.asamk.signal.manager.api.GroupSendingNotAllowedException;
import org.asamk.signal.manager.api.InactiveGroupLinkException;
import org.asamk.signal.manager.api.LastGroupAdminException;
import org.asamk.signal.manager.api.NotAGroupMemberException;
import org.asamk.signal.manager.api.Pair;
import org.asamk.signal.manager.api.PendingAdminApprovalException;
import org.asamk.signal.manager.api.SendGroupMessageResults;
import org.asamk.signal.manager.api.SendMessageResult;
import org.asamk.signal.manager.groups.GroupUtils;
import org.asamk.signal.manager.helper.Context;
import org.asamk.signal.manager.helper.GroupV2Helper;
import org.asamk.signal.manager.internal.SignalDependencies;
import org.asamk.signal.manager.jobs.SyncStorageJob;
import org.asamk.signal.manager.storage.SignalAccount;
import org.asamk.signal.manager.storage.groups.GroupInfo;
import org.asamk.signal.manager.storage.groups.GroupInfoV1;
import org.asamk.signal.manager.storage.groups.GroupInfoV2;
import org.asamk.signal.manager.storage.profiles.ProfileStore;
import org.asamk.signal.manager.storage.recipients.RecipientId;
import org.asamk.signal.manager.util.AttachmentUtils;
import org.asamk.signal.manager.util.IOUtils;
import org.asamk.signal.manager.util.Utils;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.groups.GroupMasterKey;
import org.signal.libsignal.zkgroup.groups.GroupSecretParams;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.signal.storageservice.protos.groups.GroupChange;
import org.signal.storageservice.protos.groups.GroupChangeResponse;
import org.signal.storageservice.protos.groups.local.DecryptedGroup;
import org.signal.storageservice.protos.groups.local.DecryptedGroupChange;
import org.signal.storageservice.protos.groups.local.DecryptedGroupJoinInfo;
import org.signal.storageservice.protos.groups.local.DecryptedMember;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.groupsv2.DecryptedGroupChangeLog;
import org.whispersystems.signalservice.api.groupsv2.DecryptedGroupResponse;
import org.whispersystems.signalservice.api.groupsv2.GroupHistoryPage;
import org.whispersystems.signalservice.api.groupsv2.GroupLinkNotActiveException;
import org.whispersystems.signalservice.api.groupsv2.GroupsV2Operations;
import org.whispersystems.signalservice.api.groupsv2.ReceivedGroupSendEndorsements;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachment;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachmentStream;
import org.whispersystems.signalservice.api.messages.SignalServiceDataMessage;
import org.whispersystems.signalservice.api.messages.SignalServiceGroup;
import org.whispersystems.signalservice.api.messages.SignalServiceGroupV2;
import org.whispersystems.signalservice.api.push.DistributionId;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.push.exceptions.ConflictException;
import org.whispersystems.signalservice.api.util.StreamDetails;
import org.whispersystems.signalservice.internal.push.http.ResumableUploadSpec;

public class GroupHelper {
    private static final Logger logger = LoggerFactory.getLogger(GroupHelper.class);
    private final SignalAccount account;
    private final SignalDependencies dependencies;
    private final Context context;

    public GroupHelper(Context context) {
        this.account = context.getAccount();
        this.dependencies = context.getDependencies();
        this.context = context;
    }

    public GroupInfo getGroup(GroupId groupId) {
        return this.getGroup(groupId, false);
    }

    public void updateGroupSendEndorsements(GroupId groupId) {
        this.getGroup(groupId, true);
    }

    public List<GroupInfo> getGroups() {
        List<GroupInfo> groups = this.account.getGroupStore().getGroups();
        groups.forEach(group -> this.fillOrUpdateGroup((GroupInfo)group, false));
        return groups;
    }

    public boolean isGroupBlocked(GroupId groupId) {
        GroupInfo group = this.getGroup(groupId);
        return group != null && group.isBlocked();
    }

    public void downloadGroupAvatar(GroupIdV1 groupId, SignalServiceAttachment avatar) {
        try {
            this.context.getAvatarStore().storeGroupAvatar(groupId, outputStream -> this.context.getAttachmentHelper().retrieveAttachment(avatar, outputStream));
        }
        catch (IOException e) {
            logger.warn("Failed to download avatar for group {}, ignoring: {}", (Object)groupId.toBase64(), (Object)e.getMessage());
        }
    }

    public Optional<SignalServiceAttachmentStream> createGroupAvatarAttachment(GroupIdV1 groupId) throws IOException {
        StreamDetails streamDetails = this.context.getAvatarStore().retrieveGroupAvatar(groupId);
        if (streamDetails == null) {
            return Optional.empty();
        }
        ResumableUploadSpec uploadSpec = this.dependencies.getMessageSender().getResumableUploadSpec();
        return Optional.of(AttachmentUtils.createAttachmentStream(streamDetails, Optional.empty(), uploadSpec));
    }

    public GroupInfoV2 getOrMigrateGroup(GroupMasterKey groupMasterKey, int revision, byte[] signedGroupChange) {
        GroupSecretParams groupSecretParams = GroupSecretParams.deriveFromMasterKey((GroupMasterKey)groupMasterKey);
        GroupIdV2 groupId = GroupUtils.getGroupIdV2(groupSecretParams);
        GroupInfoV2 groupInfoV2 = this.account.getGroupStore().getGroupOrPartialMigrate(groupMasterKey, groupId);
        if (groupInfoV2.getGroup() == null || groupInfoV2.getGroup().revision < revision) {
            DecryptedGroupChange decryptedGroupChange;
            DecryptedGroup group = null;
            if (signedGroupChange != null && groupInfoV2.getGroup() != null && groupInfoV2.getGroup().revision + 1 == revision && (decryptedGroupChange = this.context.getGroupV2Helper().getDecryptedGroupChange(signedGroupChange, groupMasterKey)) != null) {
                this.storeProfileKeyFromChange(decryptedGroupChange);
                group = this.context.getGroupV2Helper().getUpdatedDecryptedGroup(groupInfoV2.getGroup(), decryptedGroupChange);
            }
            if (group == null) {
                try {
                    DecryptedGroupResponse response = this.context.getGroupV2Helper().getDecryptedGroup(groupSecretParams);
                    if (response != null) {
                        group = this.handleDecryptedGroupResponse(groupInfoV2, response);
                        this.storeProfileKeysFromHistory(groupSecretParams, groupInfoV2, group);
                    }
                }
                catch (NotAGroupMemberException response) {
                    // empty catch block
                }
            }
            if (group != null) {
                this.storeProfileKeysFromMembers(group);
                String avatar = group.avatar;
                if (!avatar.isEmpty()) {
                    this.downloadGroupAvatar(groupId, groupSecretParams, avatar);
                }
            }
            groupInfoV2.setGroup(group);
            this.account.getGroupStore().updateGroup(groupInfoV2);
            this.context.getJobExecutor().enqueueJob(new SyncStorageJob());
        }
        return groupInfoV2;
    }

    private DecryptedGroup handleDecryptedGroupResponse(GroupInfoV2 groupInfoV2, DecryptedGroupResponse decryptedGroupResponse) {
        GroupSecretParams groupSecretParams = GroupSecretParams.deriveFromMasterKey((GroupMasterKey)groupInfoV2.getMasterKey());
        ReceivedGroupSendEndorsements groupSendEndorsements = this.dependencies.getGroupsV2Operations().forGroup(groupSecretParams).receiveGroupSendEndorsements(this.account.getAci(), decryptedGroupResponse.getGroup(), decryptedGroupResponse.getGroupSendEndorsementsResponse());
        return decryptedGroupResponse.getGroup();
    }

    private GroupChange handleGroupChangeResponse(GroupInfoV2 groupInfoV2, GroupChangeResponse groupChangeResponse) {
        ReceivedGroupSendEndorsements groupSendEndorsements = this.dependencies.getGroupsV2Operations().forGroup(GroupSecretParams.deriveFromMasterKey((GroupMasterKey)groupInfoV2.getMasterKey())).receiveGroupSendEndorsements(this.account.getAci(), groupInfoV2.getGroup(), groupChangeResponse.groupSendEndorsementsResponse);
        return groupChangeResponse.groupChange;
    }

    public Pair<GroupId, SendGroupMessageResults> createGroup(String name, Set<RecipientId> members, String avatarFile) throws IOException, AttachmentInvalidException {
        RecipientId selfRecipientId = this.account.getSelfRecipientId();
        if (members != null && members.contains(selfRecipientId)) {
            members = new HashSet<RecipientId>(members);
            members.remove(selfRecipientId);
        }
        byte[] avatarBytes = this.readAvatarBytes(avatarFile);
        Pair<GroupInfoV2, DecryptedGroupResponse> gv2Pair = this.context.getGroupV2Helper().createGroup(name == null ? "" : name, members == null ? Set.of() : members, avatarBytes);
        if (gv2Pair == null) {
            GroupInfoV1 gv1 = new GroupInfoV1(GroupIdV1.createRandom());
            gv1.setProfileSharingEnabled(true);
            gv1.addMembers(List.of(selfRecipientId));
            SendGroupMessageResults result = this.updateGroupV1(gv1, name, members, avatarBytes);
            return new Pair<GroupId, SendGroupMessageResults>(gv1.getGroupId(), result);
        }
        GroupInfoV2 gv2 = gv2Pair.first();
        DecryptedGroupResponse decryptedGroup = gv2Pair.second();
        gv2.setGroup(this.handleDecryptedGroupResponse(gv2, decryptedGroup));
        gv2.setProfileSharingEnabled(true);
        if (avatarBytes != null) {
            this.context.getAvatarStore().storeGroupAvatar(gv2.getGroupId(), outputStream -> outputStream.write(avatarBytes));
        }
        this.account.getGroupStore().updateGroup(gv2);
        SignalServiceDataMessage.Builder messageBuilder = this.getGroupUpdateMessageBuilder(gv2, null);
        SendGroupMessageResults result = this.sendGroupMessage(messageBuilder, gv2.getMembersIncludingPendingWithout(selfRecipientId), gv2.getDistributionId());
        this.context.getJobExecutor().enqueueJob(new SyncStorageJob());
        return new Pair<GroupId, SendGroupMessageResults>(gv2.getGroupId(), result);
    }

    public SendGroupMessageResults updateGroup(GroupId groupId, String name, String description, Set<RecipientId> members, Set<RecipientId> removeMembers, Set<RecipientId> admins, Set<RecipientId> removeAdmins, Set<RecipientId> banMembers, Set<RecipientId> unbanMembers, boolean resetGroupLink, GroupLinkState groupLinkState, GroupPermission addMemberPermission, GroupPermission editDetailsPermission, String avatarFile, Integer expirationTimer, Boolean isAnnouncementGroup) throws IOException, GroupNotFoundException, AttachmentInvalidException, NotAGroupMemberException, GroupSendingNotAllowedException {
        SendGroupMessageResults results;
        GroupInfo group = this.getGroupForUpdating(groupId);
        byte[] avatarBytes = this.readAvatarBytes(avatarFile);
        GroupInfo groupInfo = group;
        Objects.requireNonNull(groupInfo);
        GroupInfo groupInfo2 = groupInfo;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GroupInfoV2.class, GroupInfoV1.class}, (Object)groupInfo2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                GroupInfoV2 gv2 = (GroupInfoV2)groupInfo2;
                try {
                    results = this.updateGroupV2(gv2, name, description, members, removeMembers, admins, removeAdmins, banMembers, unbanMembers, resetGroupLink, groupLinkState, addMemberPermission, editDetailsPermission, avatarBytes, expirationTimer, isAnnouncementGroup);
                }
                catch (ConflictException e) {
                    group = this.getGroup(groupId, true);
                    results = this.updateGroupV2((GroupInfoV2)group, name, description, members, removeMembers, admins, removeAdmins, banMembers, unbanMembers, resetGroupLink, groupLinkState, addMemberPermission, editDetailsPermission, avatarBytes, expirationTimer, isAnnouncementGroup);
                }
                break;
            }
            case 1: {
                GroupInfoV1 gv1 = (GroupInfoV1)groupInfo2;
                results = this.updateGroupV1(gv1, name, members, avatarBytes);
                if (expirationTimer == null) break;
                this.setExpirationTimer(gv1, expirationTimer);
            }
        }
        this.context.getJobExecutor().enqueueJob(new SyncStorageJob());
        return results;
    }

    public void updateGroupProfileKey(GroupIdV2 groupId) throws GroupNotFoundException, NotAGroupMemberException, IOException {
        GroupInfo group = this.getGroupForUpdating(groupId);
        if (group instanceof GroupInfoV2) {
            Pair<DecryptedGroup, GroupChangeResponse> groupChangePair;
            GroupInfoV2 groupInfoV2 = (GroupInfoV2)group;
            try {
                groupChangePair = this.context.getGroupV2Helper().updateSelfProfileKey(groupInfoV2);
            }
            catch (ConflictException e) {
                groupInfoV2 = (GroupInfoV2)this.getGroup(groupId, true);
                groupChangePair = this.context.getGroupV2Helper().updateSelfProfileKey(groupInfoV2);
            }
            if (groupChangePair != null) {
                this.sendUpdateGroupV2Message(groupInfoV2, groupChangePair.first(), this.handleGroupChangeResponse(groupInfoV2, groupChangePair.second()));
            }
        }
    }

    public Pair<GroupId, SendGroupMessageResults> joinGroup(GroupInviteLinkUrl inviteLinkUrl) throws IOException, InactiveGroupLinkException, PendingAdminApprovalException {
        DecryptedGroupJoinInfo groupJoinInfo;
        try {
            groupJoinInfo = this.context.getGroupV2Helper().getDecryptedGroupJoinInfo(inviteLinkUrl.getGroupMasterKey(), inviteLinkUrl.getPassword());
        }
        catch (GroupLinkNotActiveException e) {
            throw new InactiveGroupLinkException("Group link inactive (reason: " + String.valueOf(e.getReason()) + ")", e);
        }
        if (groupJoinInfo.pendingAdminApproval) {
            throw new PendingAdminApprovalException("You have already requested to join the group.");
        }
        GroupChangeResponse changeResponse = this.context.getGroupV2Helper().joinGroup(inviteLinkUrl.getGroupMasterKey(), inviteLinkUrl.getPassword(), groupJoinInfo);
        GroupInfoV2 group = this.getOrMigrateGroup(inviteLinkUrl.getGroupMasterKey(), groupJoinInfo.revision + 1, changeResponse.groupChange == null ? null : changeResponse.groupChange.encode());
        GroupChange groupChange = this.handleGroupChangeResponse(group, changeResponse);
        if (group.getGroup() == null) {
            return new Pair<GroupId, SendGroupMessageResults>(group.getGroupId(), new SendGroupMessageResults(0L, List.of()));
        }
        SendGroupMessageResults result = this.sendUpdateGroupV2Message(group, group.getGroup(), groupChange);
        this.context.getJobExecutor().enqueueJob(new SyncStorageJob());
        return new Pair<GroupId, SendGroupMessageResults>(group.getGroupId(), result);
    }

    public SendGroupMessageResults quitGroup(GroupId groupId, Set<RecipientId> newAdmins) throws IOException, LastGroupAdminException, NotAGroupMemberException, GroupNotFoundException {
        GroupInfo group = this.getGroupForUpdating(groupId);
        if (group instanceof GroupInfoV1) {
            return this.quitGroupV1((GroupInfoV1)group);
        }
        try {
            return this.quitGroupV2((GroupInfoV2)group, newAdmins);
        }
        catch (ConflictException e) {
            group = this.getGroup(groupId, true);
            return this.quitGroupV2((GroupInfoV2)group, newAdmins);
        }
    }

    public void deleteGroup(GroupId groupId) throws IOException {
        this.account.getGroupStore().deleteGroup(groupId);
        this.context.getAvatarStore().deleteGroupAvatar(groupId);
        this.context.getJobExecutor().enqueueJob(new SyncStorageJob());
    }

    public void setGroupBlocked(GroupId groupId, boolean blocked) throws GroupNotFoundException {
        GroupInfo group = this.getGroup(groupId);
        if (group == null) {
            throw new GroupNotFoundException(groupId);
        }
        group.setBlocked(blocked);
        this.account.getGroupStore().updateGroup(group);
        this.context.getJobExecutor().enqueueJob(new SyncStorageJob());
    }

    public SendGroupMessageResults sendGroupInfoRequest(GroupIdV1 groupId, RecipientId recipientId) throws IOException {
        SignalServiceGroup.Builder group = SignalServiceGroup.newBuilder((SignalServiceGroup.Type)SignalServiceGroup.Type.REQUEST_INFO).withId(groupId.serialize());
        SignalServiceDataMessage.Builder messageBuilder = SignalServiceDataMessage.newBuilder().asGroupMessage(group.build());
        return this.sendGroupMessage(messageBuilder, Set.of(recipientId), null);
    }

    public SendGroupMessageResults sendGroupInfoMessage(GroupIdV1 groupId, RecipientId recipientId) throws IOException, NotAGroupMemberException, GroupNotFoundException, AttachmentInvalidException {
        GroupInfo group = this.getGroupForUpdating(groupId);
        if (!(group instanceof GroupInfoV1)) {
            throw new IOException("Received an invalid group request for a v2 group!");
        }
        GroupInfoV1 g = (GroupInfoV1)group;
        if (!g.isMember(recipientId)) {
            throw new NotAGroupMemberException(groupId, g.name);
        }
        SignalServiceDataMessage.Builder messageBuilder = this.getGroupUpdateMessageBuilder(g);
        return this.sendGroupMessage(messageBuilder, Set.of(recipientId), null);
    }

    private GroupInfo getGroup(GroupId groupId, boolean forceUpdate) {
        GroupInfo group = this.account.getGroupStore().getGroup(groupId);
        this.fillOrUpdateGroup(group, forceUpdate);
        return group;
    }

    private void fillOrUpdateGroup(GroupInfo group, boolean forceUpdate) {
        DecryptedGroup decryptedGroup;
        if (!(group instanceof GroupInfoV2)) {
            return;
        }
        GroupInfoV2 groupInfoV2 = (GroupInfoV2)group;
        if (!forceUpdate && (groupInfoV2.isPermissionDenied() || groupInfoV2.getGroup() != null)) {
            return;
        }
        GroupSecretParams groupSecretParams = GroupSecretParams.deriveFromMasterKey((GroupMasterKey)groupInfoV2.getMasterKey());
        try {
            DecryptedGroupResponse response = this.context.getGroupV2Helper().getDecryptedGroup(groupSecretParams);
            if (response == null) {
                return;
            }
            decryptedGroup = this.handleDecryptedGroupResponse(groupInfoV2, response);
        }
        catch (NotAGroupMemberException e) {
            groupInfoV2.setPermissionDenied(true);
            this.account.getGroupStore().updateGroup(group);
            return;
        }
        try {
            this.storeProfileKeysFromHistory(groupSecretParams, groupInfoV2, decryptedGroup);
        }
        catch (NotAGroupMemberException e) {
            // empty catch block
        }
        this.storeProfileKeysFromMembers(decryptedGroup);
        String avatar = decryptedGroup.avatar;
        if (!avatar.isEmpty()) {
            this.downloadGroupAvatar(groupInfoV2.getGroupId(), groupSecretParams, avatar);
        }
        groupInfoV2.setGroup(decryptedGroup);
        this.account.getGroupStore().updateGroup(group);
    }

    private void downloadGroupAvatar(GroupIdV2 groupId, GroupSecretParams groupSecretParams, String cdnKey) {
        try {
            this.context.getAvatarStore().storeGroupAvatar(groupId, outputStream -> this.retrieveGroupV2Avatar(groupSecretParams, cdnKey, outputStream));
        }
        catch (IOException e) {
            logger.warn("Failed to download avatar for group {}, ignoring: {}", (Object)groupId.toBase64(), (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveGroupV2Avatar(GroupSecretParams groupSecretParams, String cdnKey, OutputStream outputStream) throws IOException {
        GroupsV2Operations.GroupOperations groupOperations = this.dependencies.getGroupsV2Operations().forGroup(groupSecretParams);
        File tmpFile = IOUtils.createTempFile();
        try (FileInputStream input = this.dependencies.getMessageReceiver().retrieveGroupsV2ProfileAvatar(cdnKey, tmpFile, 0xA00000L);){
            byte[] encryptedData = IOUtils.readFully(input);
            byte[] decryptedData = groupOperations.decryptAvatar(encryptedData);
            outputStream.write(decryptedData);
        }
        finally {
            try {
                Files.delete(tmpFile.toPath());
            }
            catch (IOException e) {
                logger.warn("Failed to delete received group avatar temp file \u201c{}\u201d, ignoring: {}", (Object)tmpFile, (Object)e.getMessage());
            }
        }
    }

    private void storeProfileKeysFromMembers(DecryptedGroup group) {
        for (DecryptedMember member : group.members) {
            ServiceId serviceId = ServiceId.parseOrThrow((ByteString)member.aciBytes);
            RecipientId recipientId = this.account.getRecipientResolver().resolveRecipient(serviceId);
            ProfileStore profileStore = this.account.getProfileStore();
            if (profileStore.getProfileKey(recipientId) != null) continue;
            try {
                profileStore.storeProfileKey(recipientId, new ProfileKey(member.profileKey.toByteArray()));
            }
            catch (InvalidInputException invalidInputException) {}
        }
    }

    private void storeProfileKeyFromChange(DecryptedGroupChange decryptedGroupChange) {
        Pair<ServiceId, ProfileKey> profileKeyFromChange = this.context.getGroupV2Helper().getAuthoritativeProfileKeyFromChange(decryptedGroupChange);
        if (profileKeyFromChange != null) {
            ServiceId serviceId = profileKeyFromChange.first();
            ProfileKey profileKey = profileKeyFromChange.second();
            RecipientId recipientId = this.account.getRecipientResolver().resolveRecipient(serviceId);
            this.account.getProfileStore().storeProfileKey(recipientId, profileKey);
        }
    }

    private void storeProfileKeysFromHistory(GroupSecretParams groupSecretParams, GroupInfoV2 localGroup, DecryptedGroup newDecryptedGroup) throws NotAGroupMemberException {
        int revisionWeWereAdded = this.context.getGroupV2Helper().findRevisionWeWereAdded(newDecryptedGroup);
        int localRevision = localGroup.getGroup() == null ? 0 : localGroup.getGroup().revision;
        long sendEndorsementsExpirationMs = 0L;
        int fromRevision = Math.max(revisionWeWereAdded, localRevision);
        HashMap newProfileKeys = new HashMap();
        while (true) {
            GroupHistoryPage page = this.context.getGroupV2Helper().getDecryptedGroupHistoryPage(groupSecretParams, fromRevision, 0L);
            page.getChangeLogs().stream().map(DecryptedGroupChangeLog::getChange).filter(Objects::nonNull).map(this.context.getGroupV2Helper()::getAuthoritativeProfileKeyFromChange).filter(Objects::nonNull).forEach(p -> {
                ServiceId serviceId = (ServiceId)p.first();
                ProfileKey profileKey = (ProfileKey)p.second();
                RecipientId recipientId = this.account.getRecipientResolver().resolveRecipient(serviceId);
                newProfileKeys.put(recipientId, profileKey);
            });
            if (!page.getPagingData().getHasMorePages()) break;
            fromRevision = page.getPagingData().getNextPageRevision();
        }
        newProfileKeys.entrySet().stream().filter(entry -> this.account.getProfileStore().getProfileKey((RecipientId)entry.getKey()) == null).forEach(entry -> this.account.getProfileStore().storeProfileKey((RecipientId)entry.getKey(), (ProfileKey)entry.getValue()));
    }

    private GroupInfo getGroupForUpdating(GroupId groupId) throws GroupNotFoundException, NotAGroupMemberException {
        GroupInfo g = this.getGroup(groupId);
        if (g == null) {
            throw new GroupNotFoundException(groupId);
        }
        if (!g.isMember(this.account.getSelfRecipientId()) && !g.isPendingMember(this.account.getSelfRecipientId())) {
            throw new NotAGroupMemberException(groupId, g.getTitle());
        }
        if (groupId instanceof GroupIdV2) {
            return this.getGroup(groupId, true);
        }
        return g;
    }

    private SendGroupMessageResults updateGroupV1(GroupInfoV1 gv1, String name, Set<RecipientId> members, byte[] avatarFile) throws IOException, AttachmentInvalidException {
        this.updateGroupV1Details(gv1, name, members, avatarFile);
        this.account.getGroupStore().updateGroup(gv1);
        SignalServiceDataMessage.Builder messageBuilder = this.getGroupUpdateMessageBuilder(gv1);
        return this.sendGroupMessage(messageBuilder, gv1.getMembersIncludingPendingWithout(this.account.getSelfRecipientId()), gv1.getDistributionId());
    }

    private void updateGroupV1Details(GroupInfoV1 g, String name, Collection<RecipientId> members, byte[] avatarFile) throws IOException {
        if (name != null) {
            g.name = name;
        }
        if (members != null) {
            g.addMembers(members);
        }
        if (avatarFile != null) {
            this.context.getAvatarStore().storeGroupAvatar(g.getGroupId(), outputStream -> outputStream.write(avatarFile));
        }
    }

    private void setExpirationTimer(GroupInfoV1 groupInfoV1, int messageExpirationTimer) throws NotAGroupMemberException, GroupNotFoundException, IOException, GroupSendingNotAllowedException {
        groupInfoV1.messageExpirationTime = messageExpirationTimer;
        this.account.getGroupStore().updateGroup(groupInfoV1);
        this.sendExpirationTimerUpdate(groupInfoV1.getGroupId());
    }

    private void sendExpirationTimerUpdate(GroupIdV1 groupId) throws IOException, NotAGroupMemberException, GroupNotFoundException, GroupSendingNotAllowedException {
        SignalServiceDataMessage.Builder messageBuilder = SignalServiceDataMessage.newBuilder().asExpirationUpdate();
        this.context.getSendHelper().sendAsGroupMessage(messageBuilder, groupId, false, Optional.empty());
    }

    private SendGroupMessageResults updateGroupV2(GroupInfoV2 group, String name, String description, Set<RecipientId> members, Set<RecipientId> removeMembers, Set<RecipientId> admins, Set<RecipientId> removeAdmins, Set<RecipientId> banMembers, Set<RecipientId> unbanMembers, boolean resetGroupLink, GroupLinkState groupLinkState, GroupPermission addMemberPermission, GroupPermission editDetailsPermission, byte[] avatarFile, Integer expirationTimer, Boolean isAnnouncementGroup) throws IOException {
        Pair<DecryptedGroup, GroupChangeResponse> groupGroupChangePair;
        Pair<DecryptedGroup, GroupChangeResponse> groupGroupChangePair2;
        Pair<DecryptedGroup, GroupChangeResponse> groupGroupChangePair3;
        Pair<DecryptedGroup, GroupChangeResponse> groupGroupChangePair4;
        SendGroupMessageResults result = null;
        GroupV2Helper groupV2Helper = this.context.getGroupV2Helper();
        if (group.isPendingMember(this.account.getSelfRecipientId())) {
            groupGroupChangePair4 = groupV2Helper.acceptInvite(group);
            result = this.sendUpdateGroupV2Message(group, groupGroupChangePair4.first(), this.handleGroupChangeResponse(group, groupGroupChangePair4.second()));
        }
        if (members != null) {
            HashSet<RecipientId> requestingMembers = new HashSet<RecipientId>(members);
            requestingMembers.retainAll(group.getRequestingMembers());
            if (!requestingMembers.isEmpty()) {
                groupGroupChangePair3 = groupV2Helper.approveJoinRequestMembers(group, requestingMembers);
                result = this.sendUpdateGroupV2Message(group, groupGroupChangePair3.first(), this.handleGroupChangeResponse(group, groupGroupChangePair3.second()));
            }
            HashSet<RecipientId> newMembers = new HashSet<RecipientId>(members);
            newMembers.removeAll(group.getMembers());
            newMembers.removeAll(group.getRequestingMembers());
            if (!newMembers.isEmpty()) {
                groupGroupChangePair2 = groupV2Helper.addMembers(group, newMembers);
                result = this.sendUpdateGroupV2Message(group, groupGroupChangePair2.first(), this.handleGroupChangeResponse(group, groupGroupChangePair2.second()));
            }
        }
        if (removeMembers != null) {
            HashSet<RecipientId> existingRemoveMembers = new HashSet<RecipientId>(removeMembers);
            if (banMembers != null) {
                existingRemoveMembers.addAll(banMembers);
            }
            existingRemoveMembers.retainAll(group.getMembers());
            if (members != null) {
                existingRemoveMembers.removeAll(members);
            }
            existingRemoveMembers.remove(this.account.getSelfRecipientId());
            if (!existingRemoveMembers.isEmpty()) {
                groupGroupChangePair3 = groupV2Helper.removeMembers(group, existingRemoveMembers);
                result = this.sendUpdateGroupV2Message(group, groupGroupChangePair3.first(), this.handleGroupChangeResponse(group, groupGroupChangePair3.second()));
            }
            HashSet<RecipientId> pendingRemoveMembers = new HashSet<RecipientId>(removeMembers);
            pendingRemoveMembers.retainAll(group.getPendingMembers());
            if (!pendingRemoveMembers.isEmpty()) {
                groupGroupChangePair2 = groupV2Helper.revokeInvitedMembers(group, (Set<RecipientId>)pendingRemoveMembers);
                result = this.sendUpdateGroupV2Message(group, groupGroupChangePair2.first(), this.handleGroupChangeResponse(group, groupGroupChangePair2.second()));
            }
            HashSet<RecipientId> requestingRemoveMembers = new HashSet<RecipientId>(removeMembers);
            requestingRemoveMembers.retainAll(group.getRequestingMembers());
            if (!requestingRemoveMembers.isEmpty()) {
                groupGroupChangePair = groupV2Helper.refuseJoinRequestMembers(group, requestingRemoveMembers);
                result = this.sendUpdateGroupV2Message(group, groupGroupChangePair.first(), this.handleGroupChangeResponse(group, groupGroupChangePair.second()));
            }
        }
        if (admins != null) {
            HashSet<RecipientId> newAdmins = new HashSet<RecipientId>(admins);
            newAdmins.retainAll(group.getMembers());
            newAdmins.removeAll(group.getAdminMembers());
            if (!newAdmins.isEmpty()) {
                for (RecipientId admin : newAdmins) {
                    groupGroupChangePair = groupV2Helper.setMemberAdmin(group, admin, true);
                    result = this.sendUpdateGroupV2Message(group, groupGroupChangePair.first(), this.handleGroupChangeResponse(group, groupGroupChangePair.second()));
                }
            }
        }
        if (removeAdmins != null) {
            HashSet<RecipientId> existingRemoveAdmins = new HashSet<RecipientId>(removeAdmins);
            existingRemoveAdmins.retainAll(group.getAdminMembers());
            if (!existingRemoveAdmins.isEmpty()) {
                for (RecipientId admin : existingRemoveAdmins) {
                    groupGroupChangePair = groupV2Helper.setMemberAdmin(group, admin, false);
                    result = this.sendUpdateGroupV2Message(group, groupGroupChangePair.first(), this.handleGroupChangeResponse(group, groupGroupChangePair.second()));
                }
            }
        }
        if (banMembers != null) {
            HashSet<RecipientId> newlyBannedMembers = new HashSet<RecipientId>(banMembers);
            newlyBannedMembers.removeAll(group.getBannedMembers());
            if (!newlyBannedMembers.isEmpty()) {
                groupGroupChangePair3 = groupV2Helper.banMembers(group, newlyBannedMembers);
                result = this.sendUpdateGroupV2Message(group, groupGroupChangePair3.first(), this.handleGroupChangeResponse(group, groupGroupChangePair3.second()));
            }
        }
        if (unbanMembers != null) {
            HashSet<RecipientId> existingUnbanMembers = new HashSet<RecipientId>(unbanMembers);
            existingUnbanMembers.retainAll(group.getBannedMembers());
            if (!existingUnbanMembers.isEmpty()) {
                groupGroupChangePair3 = groupV2Helper.unbanMembers(group, existingUnbanMembers);
                result = this.sendUpdateGroupV2Message(group, groupGroupChangePair3.first(), this.handleGroupChangeResponse(group, groupGroupChangePair3.second()));
            }
        }
        if (resetGroupLink) {
            groupGroupChangePair4 = groupV2Helper.resetGroupLinkPassword(group);
            result = this.sendUpdateGroupV2Message(group, groupGroupChangePair4.first(), this.handleGroupChangeResponse(group, groupGroupChangePair4.second()));
        }
        if (groupLinkState != null) {
            groupGroupChangePair4 = groupV2Helper.setGroupLinkState(group, groupLinkState);
            result = this.sendUpdateGroupV2Message(group, groupGroupChangePair4.first(), this.handleGroupChangeResponse(group, groupGroupChangePair4.second()));
        }
        if (addMemberPermission != null) {
            groupGroupChangePair4 = groupV2Helper.setAddMemberPermission(group, addMemberPermission);
            result = this.sendUpdateGroupV2Message(group, groupGroupChangePair4.first(), this.handleGroupChangeResponse(group, groupGroupChangePair4.second()));
        }
        if (editDetailsPermission != null) {
            groupGroupChangePair4 = groupV2Helper.setEditDetailsPermission(group, editDetailsPermission);
            result = this.sendUpdateGroupV2Message(group, groupGroupChangePair4.first(), this.handleGroupChangeResponse(group, groupGroupChangePair4.second()));
        }
        if (expirationTimer != null) {
            groupGroupChangePair4 = groupV2Helper.setMessageExpirationTimer(group, expirationTimer);
            result = this.sendUpdateGroupV2Message(group, groupGroupChangePair4.first(), this.handleGroupChangeResponse(group, groupGroupChangePair4.second()));
        }
        if (isAnnouncementGroup != null) {
            groupGroupChangePair4 = groupV2Helper.setIsAnnouncementGroup(group, isAnnouncementGroup);
            result = this.sendUpdateGroupV2Message(group, groupGroupChangePair4.first(), this.handleGroupChangeResponse(group, groupGroupChangePair4.second()));
        }
        if (name != null || description != null || avatarFile != null) {
            groupGroupChangePair4 = groupV2Helper.updateGroup(group, name, description, avatarFile);
            if (avatarFile != null) {
                this.context.getAvatarStore().storeGroupAvatar(group.getGroupId(), outputStream -> outputStream.write(avatarFile));
            }
            result = this.sendUpdateGroupV2Message(group, groupGroupChangePair4.first(), this.handleGroupChangeResponse(group, groupGroupChangePair4.second()));
        }
        return result;
    }

    private SendGroupMessageResults quitGroupV1(GroupInfoV1 groupInfoV1) throws IOException {
        SignalServiceGroup group = SignalServiceGroup.newBuilder((SignalServiceGroup.Type)SignalServiceGroup.Type.QUIT).withId(groupInfoV1.getGroupId().serialize()).build();
        SignalServiceDataMessage.Builder messageBuilder = SignalServiceDataMessage.newBuilder().asGroupMessage(group);
        groupInfoV1.removeMember(this.account.getSelfRecipientId());
        this.account.getGroupStore().updateGroup(groupInfoV1);
        return this.sendGroupMessage(messageBuilder, groupInfoV1.getMembersIncludingPendingWithout(this.account.getSelfRecipientId()), groupInfoV1.getDistributionId());
    }

    private SendGroupMessageResults quitGroupV2(GroupInfoV2 groupInfoV2, Set<RecipientId> newAdmins) throws LastGroupAdminException, IOException {
        Set<RecipientId> currentAdmins = groupInfoV2.getAdminMembers();
        newAdmins.removeAll(currentAdmins);
        newAdmins.retainAll(groupInfoV2.getMembers());
        if (currentAdmins.contains(this.account.getSelfRecipientId()) && currentAdmins.size() == 1 && groupInfoV2.getMembers().size() > 1 && newAdmins.isEmpty()) {
            throw new LastGroupAdminException(groupInfoV2.getGroupId(), groupInfoV2.getTitle());
        }
        Pair<DecryptedGroup, GroupChangeResponse> groupGroupChangePair = this.context.getGroupV2Helper().leaveGroup(groupInfoV2, newAdmins);
        groupInfoV2.setGroup(groupGroupChangePair.first());
        this.account.getGroupStore().updateGroup(groupInfoV2);
        SignalServiceDataMessage.Builder messageBuilder = this.getGroupUpdateMessageBuilder(groupInfoV2, this.handleGroupChangeResponse(groupInfoV2, groupGroupChangePair.second()).encode());
        return this.sendGroupMessage(messageBuilder, groupInfoV2.getMembersIncludingPendingWithout(this.account.getSelfRecipientId()), groupInfoV2.getDistributionId());
    }

    private SignalServiceDataMessage.Builder getGroupUpdateMessageBuilder(GroupInfoV1 g) throws AttachmentInvalidException {
        SignalServiceGroup.Builder group = SignalServiceGroup.newBuilder((SignalServiceGroup.Type)SignalServiceGroup.Type.UPDATE).withId(g.getGroupId().serialize()).withName(g.name).withMembers(g.getMembers().stream().map(this.context.getRecipientHelper()::resolveSignalServiceAddress).toList());
        try {
            Optional<SignalServiceAttachmentStream> attachment = this.createGroupAvatarAttachment(g.getGroupId());
            attachment.ifPresent(arg_0 -> ((SignalServiceGroup.Builder)group).withAvatar(arg_0));
        }
        catch (IOException e) {
            throw new AttachmentInvalidException(g.getGroupId().toBase64(), e);
        }
        return SignalServiceDataMessage.newBuilder().asGroupMessage(group.build()).withExpiration(g.getMessageExpirationTimer());
    }

    private SignalServiceDataMessage.Builder getGroupUpdateMessageBuilder(GroupInfoV2 g, byte[] signedGroupChange) {
        SignalServiceGroupV2.Builder group = SignalServiceGroupV2.newBuilder((GroupMasterKey)g.getMasterKey()).withRevision(g.getGroup().revision).withSignedGroupChange(signedGroupChange);
        return SignalServiceDataMessage.newBuilder().asGroupMessage(group.build()).withExpiration(g.getMessageExpirationTimer());
    }

    private SendGroupMessageResults sendUpdateGroupV2Message(GroupInfoV2 group, DecryptedGroup newDecryptedGroup, GroupChange groupChange) throws IOException {
        RecipientId selfRecipientId = this.account.getSelfRecipientId();
        Set<RecipientId> members = group.getMembersIncludingPendingWithout(selfRecipientId);
        group.setGroup(newDecryptedGroup);
        members.addAll(group.getMembersIncludingPendingWithout(selfRecipientId));
        this.account.getGroupStore().updateGroup(group);
        SignalServiceDataMessage.Builder messageBuilder = this.getGroupUpdateMessageBuilder(group, groupChange.encode());
        return this.sendGroupMessage(messageBuilder, members, group.getDistributionId());
    }

    private SendGroupMessageResults sendGroupMessage(SignalServiceDataMessage.Builder messageBuilder, Set<RecipientId> members, DistributionId distributionId) throws IOException {
        long timestamp = System.currentTimeMillis();
        messageBuilder.withTimestamp(timestamp);
        List<org.whispersystems.signalservice.api.messages.SendMessageResult> results = this.context.getSendHelper().sendGroupMessage(messageBuilder.build(), members, distributionId);
        return new SendGroupMessageResults(timestamp, results.stream().map(sendMessageResult -> SendMessageResult.from(sendMessageResult, this.account.getRecipientResolver(), this.account.getRecipientAddressResolver())).toList());
    }

    private byte[] readAvatarBytes(String avatarFile) throws IOException {
        if (avatarFile == null) {
            return null;
        }
        try (StreamDetails avatar = Utils.createStreamDetails(avatarFile).first();){
            byte[] byArray = IOUtils.readFully(avatar.getStream());
            return byArray;
        }
    }
}

