/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.internal.websocket;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.schedulers.Schedulers;
import io.reactivex.rxjava3.subjects.BehaviorSubject;
import io.reactivex.rxjava3.subjects.SingleSubject;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KFunction;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.core.util.logging.Log;
import org.signal.libsignal.internal.CompletableFuture;
import org.signal.libsignal.net.ChatService;
import org.whispersystems.signalservice.api.websocket.HealthMonitor;
import org.whispersystems.signalservice.api.websocket.WebSocketConnectionState;
import org.whispersystems.signalservice.internal.util.CompletableFutureExtensionsKt;
import org.whispersystems.signalservice.internal.websocket.WebSocketConnection;
import org.whispersystems.signalservice.internal.websocket.WebSocketRequestMessage;
import org.whispersystems.signalservice.internal.websocket.WebSocketResponseMessage;
import org.whispersystems.signalservice.internal.websocket.WebsocketResponse;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 '2\u00020\u0001:\u0001'B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\tH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0017H\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020\u001aH\u0016J\u0012\u0010$\u001a\u00020\u00172\b\u0010%\u001a\u0004\u0018\u00010&H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\r\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\b\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006("}, d2={"Lorg/whispersystems/signalservice/internal/websocket/LibSignalChatConnection;", "Lorg/whispersystems/signalservice/internal/websocket/WebSocketConnection;", "name", "", "chatService", "Lorg/signal/libsignal/net/ChatService;", "healthMonitor", "Lorg/whispersystems/signalservice/api/websocket/HealthMonitor;", "isAuthenticated", "", "(Ljava/lang/String;Lorg/signal/libsignal/net/ChatService;Lorg/whispersystems/signalservice/api/websocket/HealthMonitor;Z)V", "()Z", "getName", "()Ljava/lang/String;", "state", "Lio/reactivex/rxjava3/subjects/BehaviorSubject;", "Lorg/whispersystems/signalservice/api/websocket/WebSocketConnectionState;", "Lio/reactivex/rxjava3/annotations/NonNull;", "getState", "()Lio/reactivex/rxjava3/subjects/BehaviorSubject;", "connect", "Lio/reactivex/rxjava3/core/Observable;", "disconnect", "", "isDead", "readRequest", "Lorg/whispersystems/signalservice/internal/websocket/WebSocketRequestMessage;", "timeoutMillis", "", "readRequestIfAvailable", "Ljava/util/Optional;", "sendKeepAlive", "sendRequest", "Lio/reactivex/rxjava3/core/Single;", "Lorg/whispersystems/signalservice/internal/websocket/WebsocketResponse;", "request", "sendResponse", "response", "Lorg/whispersystems/signalservice/internal/websocket/WebSocketResponseMessage;", "Companion", "signal-service-java"})
public final class LibSignalChatConnection
implements WebSocketConnection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChatService chatService;
    @NotNull
    private final HealthMonitor healthMonitor;
    private final boolean isAuthenticated;
    @NotNull
    private final String name;
    @NotNull
    private final BehaviorSubject<WebSocketConnectionState> state;
    @NotNull
    private static final String TAG = Log.tag(LibSignalChatConnection.class);
    private static final long SEND_TIMEOUT = Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS));
    @NotNull
    private static final ChatService.Request KEEP_ALIVE_REQUEST = new ChatService.Request("GET", "/v1/keepalive", MapsKt.emptyMap(), new byte[0], (int)SEND_TIMEOUT);

    public LibSignalChatConnection(@NotNull String name, @NotNull ChatService chatService, @NotNull HealthMonitor healthMonitor, boolean isAuthenticated) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)chatService, (String)"chatService");
        Intrinsics.checkNotNullParameter((Object)healthMonitor, (String)"healthMonitor");
        this.chatService = chatService;
        this.healthMonitor = healthMonitor;
        this.isAuthenticated = isAuthenticated;
        this.name = "[" + name + ":" + System.identityHashCode(this) + "]";
        BehaviorSubject behaviorSubject = BehaviorSubject.createDefault((Object)((Object)WebSocketConnectionState.DISCONNECTED));
        Intrinsics.checkNotNullExpressionValue((Object)behaviorSubject, (String)"createDefault(...)");
        this.state = behaviorSubject;
    }

    public final boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final BehaviorSubject<WebSocketConnectionState> getState() {
        return this.state;
    }

    @Override
    @NotNull
    public Observable<WebSocketConnectionState> connect() {
        Log.i((String)TAG, (String)(this.getName() + " Connecting..."));
        this.state.onNext((Object)WebSocketConnectionState.CONNECTING);
        KFunction connect2 = this.isAuthenticated ? (KFunction)new Function0<CompletableFuture<ChatService.DebugInfo>>((Object)this.chatService){

            public final CompletableFuture<ChatService.DebugInfo> invoke() {
                return ((ChatService)this.receiver).connectAuthenticated();
            }
        } : (KFunction)new Function0<CompletableFuture<ChatService.DebugInfo>>((Object)this.chatService){

            public final CompletableFuture<ChatService.DebugInfo> invoke() {
                return ((ChatService)this.receiver).connectUnauthenticated();
            }
        };
        Object object = ((Function0)connect2).invoke();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invoke(...)");
        CompletableFutureExtensionsKt.whenComplete((CompletableFuture)object, (Function1)new Function1<ChatService.DebugInfo, Unit>(this){
            final /* synthetic */ LibSignalChatConnection this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@Nullable ChatService.DebugInfo debugInfo) {
                Log.i((String)LibSignalChatConnection.access$getTAG$cp(), (String)(this.this$0.getName() + " Connected"));
                Log.d((String)LibSignalChatConnection.access$getTAG$cp(), (String)(this.this$0.getName() + " " + debugInfo));
                this.this$0.getState().onNext((Object)((Object)WebSocketConnectionState.CONNECTED));
            }
        }, (Function1<? super Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(this){
            final /* synthetic */ LibSignalChatConnection this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                Log.d((String)LibSignalChatConnection.access$getTAG$cp(), (String)(this.this$0.getName() + " Connect failed"), (Throwable)throwable);
                this.this$0.getState().onNext((Object)((Object)WebSocketConnectionState.FAILED));
            }
        }));
        return (Observable)this.state;
    }

    @Override
    public boolean isDead() {
        return false;
    }

    @Override
    public void disconnect() {
        Log.i((String)TAG, (String)(this.getName() + " Disconnecting..."));
        this.state.onNext((Object)WebSocketConnectionState.DISCONNECTING);
        CompletableFuture completableFuture = this.chatService.disconnect();
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"disconnect(...)");
        CompletableFutureExtensionsKt.whenComplete(completableFuture, (Function1)new Function1<Void, Unit>(this){
            final /* synthetic */ LibSignalChatConnection this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@Nullable Void it) {
                Log.i((String)LibSignalChatConnection.access$getTAG$cp(), (String)(this.this$0.getName() + " Disconnected"));
                this.this$0.getState().onNext((Object)((Object)WebSocketConnectionState.DISCONNECTED));
            }
        }, (Function1<? super Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(this){
            final /* synthetic */ LibSignalChatConnection this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                Log.d((String)LibSignalChatConnection.access$getTAG$cp(), (String)(this.this$0.getName() + " Disconnect failed"), (Throwable)throwable);
                this.this$0.getState().onNext((Object)((Object)WebSocketConnectionState.DISCONNECTED));
            }
        }));
    }

    @Override
    @NotNull
    public Single<WebsocketResponse> sendRequest(@NotNull WebSocketRequestMessage request) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        SingleSubject singleSubject = SingleSubject.create();
        Intrinsics.checkNotNullExpressionValue((Object)singleSubject, (String)"create(...)");
        SingleSubject single = singleSubject;
        ChatService.Request internalRequest = org.whispersystems.signalservice.internal.websocket.LibSignalChatConnection$Companion.toLibSignalRequest$default(Companion, request, 0L, 1, null);
        if (this.isAuthenticated) {
            throw new NotImplementedError("Authenticated socket is not yet supported");
        }
        KFunction send2 = (KFunction)new Function1<ChatService.Request, CompletableFuture<ChatService.Response>>((Object)this.chatService){

            public final CompletableFuture<ChatService.Response> invoke(ChatService.Request p0) {
                return ((ChatService)this.receiver).unauthenticatedSend(p0);
            }
        };
        Object object = ((Function1)send2).invoke((Object)internalRequest);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invoke(...)");
        CompletableFutureExtensionsKt.whenComplete((CompletableFuture)object, (Function1)new Function1<ChatService.Response, Unit>(this, (SingleSubject<WebsocketResponse>)single){
            final /* synthetic */ LibSignalChatConnection this$0;
            final /* synthetic */ SingleSubject<WebsocketResponse> $single;
            {
                this.this$0 = $receiver;
                this.$single = $single;
                super(1);
            }

            public final void invoke(@Nullable ChatService.Response response) {
                ChatService.Response response2 = response;
                Intrinsics.checkNotNull((Object)response2);
                int n = response2.status();
                boolean bl = 400 <= n ? n < 600 : false;
                if (bl) {
                    LibSignalChatConnection.access$getHealthMonitor$p(this.this$0).onMessageError(response.status(), false);
                }
                this.$single.onSuccess((Object)org.whispersystems.signalservice.internal.websocket.LibSignalChatConnection$Companion.access$toWebsocketResponse(LibSignalChatConnection.Companion, response, !this.this$0.isAuthenticated()));
            }
        }, (Function1<? super Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(this, (SingleSubject<WebsocketResponse>)single){
            final /* synthetic */ LibSignalChatConnection this$0;
            final /* synthetic */ SingleSubject<WebsocketResponse> $single;
            {
                this.this$0 = $receiver;
                this.$single = $single;
                super(1);
            }

            public final void invoke(@NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                Log.i((String)LibSignalChatConnection.access$getTAG$cp(), (String)(this.this$0.getName() + " sendRequest failed"), (Throwable)throwable);
                this.$single.onError(throwable);
            }
        }));
        Single single2 = single.subscribeOn(Schedulers.io()).observeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)single2, (String)"observeOn(...)");
        return single2;
    }

    @Override
    public void sendKeepAlive() {
        Log.i((String)TAG, (String)(this.getName() + " Sending keep alive..."));
        if (this.isAuthenticated) {
            throw new NotImplementedError("Authenticated socket is not yet supported");
        }
        KFunction send2 = (KFunction)new Function1<ChatService.Request, CompletableFuture<ChatService.ResponseAndDebugInfo>>((Object)this.chatService){

            public final CompletableFuture<ChatService.ResponseAndDebugInfo> invoke(ChatService.Request p0) {
                return ((ChatService)this.receiver).unauthenticatedSendAndDebug(p0);
            }
        };
        Object object = ((Function1)send2).invoke((Object)KEEP_ALIVE_REQUEST);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invoke(...)");
        CompletableFutureExtensionsKt.whenComplete((CompletableFuture)object, (Function1)new Function1<ChatService.ResponseAndDebugInfo, Unit>(this){
            final /* synthetic */ LibSignalChatConnection this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@Nullable ChatService.ResponseAndDebugInfo debugResponse) {
                Log.i((String)LibSignalChatConnection.access$getTAG$cp(), (String)(this.this$0.getName() + " Keep alive - success"));
                Log.d((String)LibSignalChatConnection.access$getTAG$cp(), (String)(this.this$0.getName() + " " + debugResponse));
                ChatService.ResponseAndDebugInfo responseAndDebugInfo = debugResponse;
                Intrinsics.checkNotNull((Object)responseAndDebugInfo);
                int n = responseAndDebugInfo.response().status();
                boolean bl = 200 <= n ? n < 300 : false;
                if (bl) {
                    LibSignalChatConnection.access$getHealthMonitor$p(this.this$0).onKeepAliveResponse(Instant.now().toEpochMilli(), false);
                } else {
                    boolean bl2 = 400 <= n ? n < 600 : false;
                    if (bl2) {
                        LibSignalChatConnection.access$getHealthMonitor$p(this.this$0).onMessageError(debugResponse.response().status(), this.this$0.isAuthenticated());
                    } else {
                        Log.w((String)LibSignalChatConnection.access$getTAG$cp(), (String)(this.this$0.getName() + " Unsupported keep alive response status: " + debugResponse.response().status()));
                    }
                }
            }
        }, (Function1<? super Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(this){
            final /* synthetic */ LibSignalChatConnection this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                Log.i((String)LibSignalChatConnection.access$getTAG$cp(), (String)(this.this$0.getName() + " Keep alive - failed"));
                Log.d((String)LibSignalChatConnection.access$getTAG$cp(), (String)(this.this$0.getName() + " " + throwable));
                this.this$0.getState().onNext((Object)((Object)WebSocketConnectionState.DISCONNECTED));
            }
        }));
    }

    @Override
    @NotNull
    public Optional<WebSocketRequestMessage> readRequestIfAvailable() {
        throw new NotImplementedError(null, 1, null);
    }

    @Override
    @NotNull
    public WebSocketRequestMessage readRequest(long timeoutMillis) {
        throw new NotImplementedError(null, 1, null);
    }

    @Override
    public void sendResponse(@Nullable WebSocketResponseMessage response) {
        throw new NotImplementedError(null, 1, null);
    }

    public static final /* synthetic */ String access$getTAG$cp() {
        return TAG;
    }

    public static final /* synthetic */ HealthMonitor access$getHealthMonitor$p(LibSignalChatConnection $this) {
        return $this.healthMonitor;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\u0004*\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u0006H\u0002J\u0014\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/whispersystems/signalservice/internal/websocket/LibSignalChatConnection$Companion;", "", "()V", "KEEP_ALIVE_REQUEST", "Lorg/signal/libsignal/net/ChatService$Request;", "SEND_TIMEOUT", "", "TAG", "", "toLibSignalRequest", "Lorg/whispersystems/signalservice/internal/websocket/WebSocketRequestMessage;", "timeout", "toWebsocketResponse", "Lorg/whispersystems/signalservice/internal/websocket/WebsocketResponse;", "Lorg/signal/libsignal/net/ChatService$Response;", "isUnidentified", "", "signal-service-java"})
    @SourceDebugExtension(value={"SMAP\nLibSignalChatConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibSignalChatConnection.kt\norg/whispersystems/signalservice/internal/websocket/LibSignalChatConnection$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,205:1\n1179#2,2:206\n1253#2,4:208\n*S KotlinDebug\n*F\n+ 1 LibSignalChatConnection.kt\norg/whispersystems/signalservice/internal/websocket/LibSignalChatConnection$Companion\n*L\n60#1:206,2\n60#1:208,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final ChatService.Request toLibSignalRequest(WebSocketRequestMessage $this$toLibSignalRequest, long timeout) {
            Object object;
            Map map;
            String string;
            String string2;
            block12: {
                block11: {
                    void $this$associateTo$iv$iv;
                    void $this$associate$iv;
                    String string3;
                    String string4;
                    block10: {
                        block9: {
                            string4 = $this$toLibSignalRequest.verb;
                            if (string4 == null) break block9;
                            String string5 = string4.toUpperCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(...)");
                            string4 = string5;
                            if (string5 != null) break block10;
                        }
                        string4 = "GET";
                    }
                    if ((string3 = $this$toLibSignalRequest.path) == null) {
                        string3 = "";
                    }
                    Iterable iterable = $this$toLibSignalRequest.headers;
                    string2 = string3;
                    string = string4;
                    boolean $i$f$associate = false;
                    int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                    void var7_8 = $this$associate$iv;
                    Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                    boolean $i$f$associateTo = false;
                    for (Object element$iv$iv : $this$associateTo$iv$iv) {
                        Map map2 = destination$iv$iv;
                        String it = (String)element$iv$iv;
                        boolean bl = false;
                        char[] cArray = new char[]{':'};
                        List parts = StringsKt.split$default((CharSequence)it, (char[])cArray, (boolean)false, (int)2, (int)2, null);
                        if (parts.size() != 2) {
                            throw new IllegalArgumentException("Headers must contain at least one colon");
                        }
                        Pair pair = TuplesKt.to(parts.get(0), parts.get(1));
                        map2.put(pair.getFirst(), pair.getSecond());
                    }
                    map = destination$iv$iv;
                    object = $this$toLibSignalRequest.body;
                    if (object == null) break block11;
                    byte[] byArray = object.toByteArray();
                    object = byArray;
                    if (byArray != null) break block12;
                }
                object = new byte[0];
            }
            int n = (int)timeout;
            Object object2 = object;
            Map map3 = map;
            String string6 = string2;
            String string7 = string;
            return new ChatService.Request(string7, string6, map3, (byte[])object2, n);
        }

        static /* synthetic */ ChatService.Request toLibSignalRequest$default(Companion companion, WebSocketRequestMessage webSocketRequestMessage, long l, int n, Object object) {
            if ((n & 1) != 0) {
                l = SEND_TIMEOUT;
            }
            return companion.toLibSignalRequest(webSocketRequestMessage, l);
        }

        private final WebsocketResponse toWebsocketResponse(ChatService.Response $this$toWebsocketResponse, boolean isUnidentified) {
            int n = $this$toWebsocketResponse.status();
            byte[] byArray = $this$toWebsocketResponse.body();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"body(...)");
            return new WebsocketResponse(n, StringsKt.decodeToString((byte[])byArray), $this$toWebsocketResponse.headers(), isUnidentified);
        }

        public static final /* synthetic */ WebsocketResponse access$toWebsocketResponse(Companion $this, ChatService.Response $receiver, boolean isUnidentified) {
            return $this.toWebsocketResponse($receiver, isUnidentified);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

