/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.storage;

import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.whispersystems.signalservice.api.storage.SignalAccountRecord;
import org.whispersystems.signalservice.api.storage.SignalCallLinkRecord;
import org.whispersystems.signalservice.api.storage.SignalContactRecord;
import org.whispersystems.signalservice.api.storage.SignalGroupV1Record;
import org.whispersystems.signalservice.api.storage.SignalGroupV2Record;
import org.whispersystems.signalservice.api.storage.SignalRecord;
import org.whispersystems.signalservice.api.storage.SignalStoryDistributionListRecord;
import org.whispersystems.signalservice.api.storage.StorageId;

public class SignalStorageRecord
implements SignalRecord {
    private final StorageId id;
    private final Optional<SignalStoryDistributionListRecord> storyDistributionList;
    private final Optional<SignalContactRecord> contact;
    private final Optional<SignalGroupV1Record> groupV1;
    private final Optional<SignalGroupV2Record> groupV2;
    private final Optional<SignalAccountRecord> account;
    private final Optional<SignalCallLinkRecord> callLink;

    public static SignalStorageRecord forStoryDistributionList(SignalStoryDistributionListRecord storyDistributionList) {
        return SignalStorageRecord.forStoryDistributionList(storyDistributionList.getId(), storyDistributionList);
    }

    public static SignalStorageRecord forStoryDistributionList(StorageId key, SignalStoryDistributionListRecord storyDistributionList) {
        return new SignalStorageRecord(key, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(storyDistributionList), Optional.empty());
    }

    public static SignalStorageRecord forContact(SignalContactRecord contact) {
        return SignalStorageRecord.forContact(contact.getId(), contact);
    }

    public static SignalStorageRecord forContact(StorageId key, SignalContactRecord contact) {
        return new SignalStorageRecord(key, Optional.of(contact), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static SignalStorageRecord forGroupV1(SignalGroupV1Record groupV1) {
        return SignalStorageRecord.forGroupV1(groupV1.getId(), groupV1);
    }

    public static SignalStorageRecord forGroupV1(StorageId key, SignalGroupV1Record groupV1) {
        return new SignalStorageRecord(key, Optional.empty(), Optional.of(groupV1), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static SignalStorageRecord forGroupV2(SignalGroupV2Record groupV2) {
        return SignalStorageRecord.forGroupV2(groupV2.getId(), groupV2);
    }

    public static SignalStorageRecord forGroupV2(StorageId key, SignalGroupV2Record groupV2) {
        return new SignalStorageRecord(key, Optional.empty(), Optional.empty(), Optional.of(groupV2), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static SignalStorageRecord forAccount(SignalAccountRecord account) {
        return SignalStorageRecord.forAccount(account.getId(), account);
    }

    public static SignalStorageRecord forAccount(StorageId key, SignalAccountRecord account) {
        return new SignalStorageRecord(key, Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(account), Optional.empty(), Optional.empty());
    }

    @NotNull
    public static SignalStorageRecord forCallLink(@NotNull SignalCallLinkRecord callLink) {
        return SignalStorageRecord.forCallLink(callLink.getId(), callLink);
    }

    @NotNull
    public static SignalStorageRecord forCallLink(StorageId key, @NotNull SignalCallLinkRecord callLink) {
        return new SignalStorageRecord(key, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(callLink));
    }

    public static SignalStorageRecord forUnknown(StorageId key) {
        return new SignalStorageRecord(key, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    private SignalStorageRecord(StorageId id, Optional<SignalContactRecord> contact, Optional<SignalGroupV1Record> groupV1, Optional<SignalGroupV2Record> groupV2, Optional<SignalAccountRecord> account, Optional<SignalStoryDistributionListRecord> storyDistributionList, Optional<SignalCallLinkRecord> callLink) {
        this.id = id;
        this.contact = contact;
        this.groupV1 = groupV1;
        this.groupV2 = groupV2;
        this.account = account;
        this.storyDistributionList = storyDistributionList;
        this.callLink = callLink;
    }

    @Override
    public StorageId getId() {
        return this.id;
    }

    @Override
    public SignalStorageRecord asStorageRecord() {
        return this;
    }

    @Override
    public String describeDiff(SignalRecord other) {
        return "Diffs not supported.";
    }

    public int getType() {
        return this.id.getType();
    }

    public Optional<SignalContactRecord> getContact() {
        return this.contact;
    }

    public Optional<SignalGroupV1Record> getGroupV1() {
        return this.groupV1;
    }

    public Optional<SignalGroupV2Record> getGroupV2() {
        return this.groupV2;
    }

    public Optional<SignalAccountRecord> getAccount() {
        return this.account;
    }

    public Optional<SignalStoryDistributionListRecord> getStoryDistributionList() {
        return this.storyDistributionList;
    }

    public Optional<SignalCallLinkRecord> getCallLink() {
        return this.callLink;
    }

    public boolean isUnknown() {
        return !this.contact.isPresent() && !this.groupV1.isPresent() && !this.groupV2.isPresent() && !this.account.isPresent() && !this.storyDistributionList.isPresent() && !this.callLink.isPresent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignalStorageRecord that = (SignalStorageRecord)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.contact, that.contact) && Objects.equals(this.groupV1, that.groupV1) && Objects.equals(this.groupV2, that.groupV2) && Objects.equals(this.storyDistributionList, that.storyDistributionList) && Objects.equals(this.callLink, that.callLink);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.contact, this.groupV1, this.groupV2, this.storyDistributionList, this.callLink);
    }
}

