/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.messages.multidevice;

import java.io.IOException;
import java.io.OutputStream;
import okio.ByteString;
import org.whispersystems.signalservice.api.messages.multidevice.ChunkedOutputStream;
import org.whispersystems.signalservice.api.messages.multidevice.DeviceContact;
import org.whispersystems.signalservice.api.messages.multidevice.VerifiedMessage;
import org.whispersystems.signalservice.internal.push.ContactDetails;
import org.whispersystems.signalservice.internal.push.Verified;

public class DeviceContactsOutputStream
extends ChunkedOutputStream {
    public DeviceContactsOutputStream(OutputStream out) {
        super(out);
    }

    public void write(DeviceContact contact) throws IOException {
        this.writeContactDetails(contact);
        this.writeAvatarImage(contact);
    }

    public void close() throws IOException {
        this.out.close();
    }

    private void writeAvatarImage(DeviceContact contact) throws IOException {
        if (contact.getAvatar().isPresent()) {
            this.writeStream(contact.getAvatar().get().getInputStream());
        }
    }

    private void writeContactDetails(DeviceContact contact) throws IOException {
        ContactDetails.Builder contactDetails = new ContactDetails.Builder();
        if (contact.getAci().isPresent()) {
            contactDetails.aci(contact.getAci().get().toString());
        }
        if (contact.getE164().isPresent()) {
            contactDetails.number(contact.getE164().get());
        }
        if (contact.getName().isPresent()) {
            contactDetails.name(contact.getName().get());
        }
        if (contact.getAvatar().isPresent()) {
            ContactDetails.Avatar.Builder avatarBuilder = new ContactDetails.Avatar.Builder();
            avatarBuilder.contentType(contact.getAvatar().get().getContentType());
            avatarBuilder.length((int)contact.getAvatar().get().getLength());
            contactDetails.avatar(avatarBuilder.build());
        }
        if (contact.getColor().isPresent()) {
            contactDetails.color(contact.getColor().get());
        }
        if (contact.getVerified().isPresent()) {
            Verified.Builder verifiedBuilder = new Verified.Builder().identityKey(ByteString.of((byte[])contact.getVerified().get().getIdentityKey().serialize())).destinationAci(contact.getVerified().get().getDestination().getServiceId().toString()).state(switch (contact.getVerified().get().getVerified()) {
                case VerifiedMessage.VerifiedState.VERIFIED -> Verified.State.VERIFIED;
                case VerifiedMessage.VerifiedState.UNVERIFIED -> Verified.State.UNVERIFIED;
                default -> Verified.State.DEFAULT;
            });
            contactDetails.verified(verifiedBuilder.build());
        }
        if (contact.getProfileKey().isPresent()) {
            contactDetails.profileKey(ByteString.of((byte[])contact.getProfileKey().get().serialize()));
        }
        if (contact.getExpirationTimer().isPresent()) {
            contactDetails.expireTimer(contact.getExpirationTimer().get());
        }
        if (contact.getInboxPosition().isPresent()) {
            contactDetails.inboxPosition(contact.getInboxPosition().get());
        }
        contactDetails.archived(contact.isArchived());
        byte[] serializedContactDetails = contactDetails.build().encode();
        this.writeVarint32(serializedContactDetails.length);
        this.out.write(serializedContactDetails);
    }
}

