/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.keys;

import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.signal.core.util.LongExtensionsKt;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.signal.libsignal.protocol.kem.KEMPublicKey;
import org.whispersystems.signalservice.api.NetworkResult;
import org.whispersystems.signalservice.api.push.ServiceIdType;
import org.whispersystems.signalservice.internal.push.PushServiceSocket;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J<\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/whispersystems/signalservice/api/keys/KeysApi;", "", "pushServiceSocket", "Lorg/whispersystems/signalservice/internal/push/PushServiceSocket;", "(Lorg/whispersystems/signalservice/internal/push/PushServiceSocket;)V", "checkRepeatedUseKeys", "Lorg/whispersystems/signalservice/api/NetworkResult;", "", "serviceIdType", "Lorg/whispersystems/signalservice/api/push/ServiceIdType;", "identityKey", "Lorg/signal/libsignal/protocol/IdentityKey;", "signedPreKeyId", "", "signedPreKey", "Lorg/signal/libsignal/protocol/ecc/ECPublicKey;", "lastResortKyberKeyId", "lastResortKyberKey", "Lorg/signal/libsignal/protocol/kem/KEMPublicKey;", "Companion", "signal-service-java"})
public final class KeysApi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PushServiceSocket pushServiceSocket;

    public KeysApi(@NotNull PushServiceSocket pushServiceSocket) {
        Intrinsics.checkNotNullParameter((Object)pushServiceSocket, (String)"pushServiceSocket");
        this.pushServiceSocket = pushServiceSocket;
    }

    @NotNull
    public final NetworkResult<Unit> checkRepeatedUseKeys(@NotNull ServiceIdType serviceIdType, @NotNull IdentityKey identityKey, int signedPreKeyId, @NotNull ECPublicKey signedPreKey, int lastResortKyberKeyId, @NotNull KEMPublicKey lastResortKyberKey) {
        MessageDigest messageDigest;
        Intrinsics.checkNotNullParameter((Object)((Object)serviceIdType), (String)"serviceIdType");
        Intrinsics.checkNotNullParameter((Object)identityKey, (String)"identityKey");
        Intrinsics.checkNotNullParameter((Object)signedPreKey, (String)"signedPreKey");
        Intrinsics.checkNotNullParameter((Object)lastResortKyberKey, (String)"lastResortKyberKey");
        MessageDigest $this$checkRepeatedUseKeys_u24lambda_u240 = messageDigest = MessageDigest.getInstance("SHA-256");
        boolean bl = false;
        $this$checkRepeatedUseKeys_u24lambda_u240.update(identityKey.serialize());
        $this$checkRepeatedUseKeys_u24lambda_u240.update(LongExtensionsKt.toByteArray((long)signedPreKeyId));
        $this$checkRepeatedUseKeys_u24lambda_u240.update(signedPreKey.serialize());
        $this$checkRepeatedUseKeys_u24lambda_u240.update(LongExtensionsKt.toByteArray((long)lastResortKyberKeyId));
        $this$checkRepeatedUseKeys_u24lambda_u240.update(lastResortKyberKey.serialize());
        MessageDigest messageDigest2 = messageDigest;
        Intrinsics.checkNotNullExpressionValue((Object)messageDigest2, (String)"apply(...)");
        MessageDigest digest = messageDigest2;
        return NetworkResult.Companion.fromFetch(() -> KeysApi.checkRepeatedUseKeys$lambda$1(this, serviceIdType, digest));
    }

    private static final Unit checkRepeatedUseKeys$lambda$1(KeysApi this$0, ServiceIdType $serviceIdType, MessageDigest $digest) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$serviceIdType), (String)"$serviceIdType");
        Intrinsics.checkNotNullParameter((Object)$digest, (String)"$digest");
        this$0.pushServiceSocket.checkRepeatedUsePreKeys($serviceIdType, $digest.digest());
        return Unit.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final KeysApi create(@NotNull PushServiceSocket pushServiceSocket) {
        return Companion.create(pushServiceSocket);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/whispersystems/signalservice/api/keys/KeysApi$Companion;", "", "()V", "create", "Lorg/whispersystems/signalservice/api/keys/KeysApi;", "pushServiceSocket", "Lorg/whispersystems/signalservice/internal/push/PushServiceSocket;", "signal-service-java"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final KeysApi create(@NotNull PushServiceSocket pushServiceSocket) {
            Intrinsics.checkNotNullParameter((Object)pushServiceSocket, (String)"pushServiceSocket");
            return new KeysApi(pushServiceSocket);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

