/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.crypto;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.signal.core.util.stream.LimitedInputStream;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.incrementalmac.ChunkSizeChoice;
import org.signal.libsignal.protocol.incrementalmac.IncrementalMacInputStream;
import org.signal.libsignal.protocol.kdf.HKDF;
import org.whispersystems.signalservice.api.backup.BackupKey;
import org.whispersystems.signalservice.api.crypto.IncrementalMacAdditionalValidationsInputStream;
import org.whispersystems.signalservice.internal.util.Util;

public class AttachmentCipherInputStream
extends FilterInputStream {
    private static final int BLOCK_SIZE = 16;
    private static final int CIPHER_KEY_SIZE = 32;
    private static final int MAC_KEY_SIZE = 32;
    private final Cipher cipher;
    private final long totalDataSize;
    private boolean done;
    private long totalRead;
    private byte[] overflowBuffer;

    public static LimitedInputStream createForAttachment(File file, long plaintextLength, byte[] combinedKeyMaterial, byte[] digest, byte[] incrementalDigest, int incrementalMacChunkSize) throws InvalidMessageException, IOException {
        return AttachmentCipherInputStream.createForAttachment(file, plaintextLength, combinedKeyMaterial, digest, incrementalDigest, incrementalMacChunkSize, false);
    }

    public static LimitedInputStream createForAttachment(File file, long plaintextLength, byte[] combinedKeyMaterial, byte[] digest, byte[] incrementalDigest, int incrementalMacChunkSize, boolean ignoreDigest) throws InvalidMessageException, IOException {
        return AttachmentCipherInputStream.createForAttachment(() -> new FileInputStream(file), file.length(), plaintextLength, combinedKeyMaterial, digest, incrementalDigest, incrementalMacChunkSize, ignoreDigest);
    }

    public static LimitedInputStream createForAttachment(StreamSupplier streamSupplier, long streamLength, long plaintextLength, byte[] combinedKeyMaterial, byte[] digest, byte[] incrementalDigest, int incrementalMacChunkSize, boolean ignoreDigest) throws InvalidMessageException, IOException {
        InputStream wrappedStream;
        boolean hasIncrementalMac;
        byte[][] parts = Util.split(combinedKeyMaterial, 32, 32);
        Mac mac = AttachmentCipherInputStream.initMac(parts[1]);
        if (streamLength <= (long)(16 + mac.getMacLength())) {
            throw new InvalidMessageException("Message shorter than crypto overhead! length: " + streamLength);
        }
        if (!ignoreDigest && digest == null) {
            throw new InvalidMessageException("Missing digest!");
        }
        boolean bl = hasIncrementalMac = incrementalDigest != null && incrementalDigest.length > 0 && incrementalMacChunkSize > 0;
        if (!hasIncrementalMac) {
            try (InputStream macVerificationStream = streamSupplier.openStream();){
                AttachmentCipherInputStream.verifyMac(macVerificationStream, streamLength, mac, digest);
            }
            wrappedStream = streamSupplier.openStream();
        } else {
            wrappedStream = new IncrementalMacInputStream((InputStream)new IncrementalMacAdditionalValidationsInputStream(streamSupplier.openStream(), streamLength, mac, digest), parts[1], ChunkSizeChoice.everyNthByte((int)incrementalMacChunkSize), incrementalDigest);
        }
        AttachmentCipherInputStream inputStream = new AttachmentCipherInputStream(wrappedStream, parts[0], streamLength - 16L - (long)mac.getMacLength());
        if (plaintextLength != 0L) {
            return new LimitedInputStream((InputStream)inputStream, plaintextLength);
        }
        return LimitedInputStream.withoutLimits((InputStream)inputStream);
    }

    public static LimitedInputStream createForArchivedMedia(BackupKey.MediaKeyMaterial archivedMediaKeyMaterial, File file, long originalCipherTextLength) throws InvalidMessageException, IOException {
        Mac mac = AttachmentCipherInputStream.initMac(archivedMediaKeyMaterial.getMacKey());
        if (file.length() <= (long)(16 + mac.getMacLength())) {
            throw new InvalidMessageException("Message shorter than crypto overhead!");
        }
        try (FileInputStream macVerificationStream = new FileInputStream(file);){
            AttachmentCipherInputStream.verifyMac(macVerificationStream, file.length(), mac, null);
        }
        AttachmentCipherInputStream inputStream = new AttachmentCipherInputStream(new FileInputStream(file), archivedMediaKeyMaterial.getCipherKey(), file.length() - 16L - (long)mac.getMacLength());
        if (originalCipherTextLength != 0L) {
            return new LimitedInputStream((InputStream)inputStream, originalCipherTextLength);
        }
        return LimitedInputStream.withoutLimits((InputStream)inputStream);
    }

    public static LimitedInputStream createStreamingForArchivedAttachment(BackupKey.MediaKeyMaterial archivedMediaKeyMaterial, File file, long originalCipherTextLength, long plaintextLength, byte[] combinedKeyMaterial, byte[] digest, byte[] incrementalDigest, int incrementalMacChunkSize) throws InvalidMessageException, IOException {
        LimitedInputStream archiveStream = AttachmentCipherInputStream.createForArchivedMedia(archivedMediaKeyMaterial, file, originalCipherTextLength);
        byte[][] parts = Util.split(combinedKeyMaterial, 32, 32);
        Mac mac = AttachmentCipherInputStream.initMac(parts[1]);
        if (originalCipherTextLength <= (long)(16 + mac.getMacLength())) {
            throw new InvalidMessageException("Message shorter than crypto overhead!");
        }
        if (digest == null) {
            throw new InvalidMessageException("Missing digest!");
        }
        IncrementalMacInputStream wrappedStream = new IncrementalMacInputStream((InputStream)new IncrementalMacAdditionalValidationsInputStream((InputStream)archiveStream, file.length(), mac, digest), parts[1], ChunkSizeChoice.everyNthByte((int)incrementalMacChunkSize), incrementalDigest);
        AttachmentCipherInputStream inputStream = new AttachmentCipherInputStream((InputStream)wrappedStream, parts[0], file.length() - 16L - (long)mac.getMacLength());
        if (plaintextLength != 0L) {
            return new LimitedInputStream((InputStream)inputStream, plaintextLength);
        }
        return LimitedInputStream.withoutLimits((InputStream)inputStream);
    }

    public static InputStream createForStickerData(byte[] data, byte[] packKey) throws InvalidMessageException, IOException {
        byte[] combinedKeyMaterial = HKDF.deriveSecrets((byte[])packKey, (byte[])"Sticker Pack".getBytes(), (int)64);
        byte[][] parts = Util.split(combinedKeyMaterial, 32, 32);
        Mac mac = AttachmentCipherInputStream.initMac(parts[1]);
        if (data.length <= 16 + mac.getMacLength()) {
            throw new InvalidMessageException("Message shorter than crypto overhead!");
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(data);){
            AttachmentCipherInputStream.verifyMac(inputStream, data.length, mac, null);
        }
        return new AttachmentCipherInputStream(new ByteArrayInputStream(data), parts[0], data.length - 16 - mac.getMacLength());
    }

    private AttachmentCipherInputStream(InputStream inputStream, byte[] cipherKey, long totalDataSize) throws IOException {
        super(inputStream);
        try {
            byte[] iv = new byte[16];
            this.readFully(iv);
            this.cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            this.cipher.init(2, (Key)new SecretKeySpec(cipherKey, "AES"), new IvParameterSpec(iv));
            this.done = false;
            this.totalRead = 0L;
            this.totalDataSize = totalDataSize;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public int read() throws IOException {
        int read;
        byte[] buffer = new byte[1];
        while ((read = this.read(buffer)) == 0) {
        }
        return read == -1 ? -1 : buffer[0] & 0xFF;
    }

    @Override
    public int read(@Nonnull byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(@Nonnull byte[] buffer, int offset, int length) throws IOException {
        int readLength = 0;
        if (null != this.overflowBuffer) {
            if (this.overflowBuffer.length > length) {
                System.arraycopy(this.overflowBuffer, 0, buffer, offset, length);
                this.overflowBuffer = Arrays.copyOfRange(this.overflowBuffer, length, this.overflowBuffer.length);
                return length;
            }
            if (this.overflowBuffer.length == length) {
                System.arraycopy(this.overflowBuffer, 0, buffer, offset, length);
                this.overflowBuffer = null;
                return length;
            }
            System.arraycopy(this.overflowBuffer, 0, buffer, offset, this.overflowBuffer.length);
            offset += (readLength += this.overflowBuffer.length);
            length -= readLength;
            this.overflowBuffer = null;
        }
        if (this.totalRead != this.totalDataSize) {
            return readLength + this.readIncremental(buffer, offset, length);
        }
        if (!this.done) {
            return readLength + this.readFinal(buffer, offset, length);
        }
        if (readLength > 0) {
            return readLength;
        }
        return -1;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public long skip(long byteCount) throws IOException {
        long skipped;
        int read;
        for (skipped = 0L; skipped < byteCount; skipped += (long)read) {
            byte[] buf = new byte[Math.min(4096, (int)(byteCount - skipped))];
            read = this.read(buf);
        }
        return skipped;
    }

    private int readFinal(byte[] buffer, int offset, int length) throws IOException {
        try {
            int outputLen = this.cipher.getOutputSize(0);
            if (outputLen <= length) {
                this.done = true;
                return this.cipher.doFinal(buffer, offset);
            }
            byte[] transientBuffer = new byte[outputLen];
            outputLen = this.cipher.doFinal(transientBuffer, 0);
            this.done = true;
            if (outputLen <= length) {
                System.arraycopy(transientBuffer, 0, buffer, offset, outputLen);
                return outputLen;
            }
            System.arraycopy(transientBuffer, 0, buffer, offset, length);
            this.overflowBuffer = Arrays.copyOfRange(transientBuffer, length, outputLen);
            return length;
        }
        catch (BadPaddingException | IllegalBlockSizeException | ShortBufferException e) {
            throw new IOException(e);
        }
    }

    private int readIncremental(byte[] buffer, int offset, int length) throws IOException {
        byte[] internalBuffer;
        if ((long)length + this.totalRead > this.totalDataSize) {
            length = (int)(this.totalDataSize - this.totalRead);
        }
        int read = super.read(internalBuffer, 0, (internalBuffer = new byte[length]).length <= this.cipher.getBlockSize() ? internalBuffer.length : internalBuffer.length - this.cipher.getBlockSize());
        this.totalRead += (long)read;
        try {
            int outputLen = this.cipher.getOutputSize(read);
            if (outputLen <= length) {
                return this.cipher.update(internalBuffer, 0, read, buffer, offset);
            }
            byte[] transientBuffer = new byte[outputLen];
            if ((outputLen = this.cipher.update(internalBuffer, 0, read, transientBuffer, 0)) <= length) {
                System.arraycopy(transientBuffer, 0, buffer, offset, outputLen);
                return outputLen;
            }
            System.arraycopy(transientBuffer, 0, buffer, offset, length);
            this.overflowBuffer = Arrays.copyOfRange(transientBuffer, length, outputLen);
            return length;
        }
        catch (ShortBufferException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static Mac initMac(byte[] key) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(key, "HmacSHA256"));
            return mac;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static void verifyMac(@Nonnull InputStream inputStream, long length, @Nonnull Mac mac, @Nullable byte[] theirDigest) throws InvalidMessageException {
        try {
            int read;
            MessageDigest digest = MessageDigest.getInstance("SHA256");
            byte[] buffer = new byte[4096];
            for (int remainingData = Util.toIntExact(length) - mac.getMacLength(); remainingData > 0; remainingData -= read) {
                read = inputStream.read(buffer, 0, Math.min(buffer.length, remainingData));
                mac.update(buffer, 0, read);
                digest.update(buffer, 0, read);
            }
            byte[] ourMac = mac.doFinal();
            byte[] theirMac = new byte[mac.getMacLength()];
            Util.readFully(inputStream, theirMac);
            if (!MessageDigest.isEqual(ourMac, theirMac)) {
                throw new InvalidMessageException("MAC doesn't match!");
            }
            byte[] ourDigest = digest.digest(theirMac);
            if (theirDigest != null && !MessageDigest.isEqual(ourDigest, theirDigest)) {
                throw new InvalidMessageException("Digest doesn't match!");
            }
        }
        catch (IOException | ArithmeticException e1) {
            throw new InvalidMessageException((Throwable)e1);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void readFully(byte[] buffer) throws IOException {
        int read;
        int offset = 0;
        while ((read = super.read(buffer, offset, buffer.length - offset)) + offset < buffer.length) {
            offset += read;
        }
    }

    public static interface StreamSupplier {
        @Nonnull
        public InputStream openStream() throws IOException;
    }
}

