/*
 * Decompiled with CFR 0.152.
 */
package org.signal.core.util.stream;

import java.io.FilterInputStream;
import java.io.InputStream;
import javax.crypto.Mac;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lorg/signal/core/util/stream/MacInputStream;", "Ljava/io/FilterInputStream;", "wrapped", "Ljava/io/InputStream;", "mac", "Ljavax/crypto/Mac;", "(Ljava/io/InputStream;Ljavax/crypto/Mac;)V", "getMac", "()Ljavax/crypto/Mac;", "getWrapped", "()Ljava/io/InputStream;", "read", "", "destination", "", "offset", "length", "core-util-jvm"})
public final class MacInputStream
extends FilterInputStream {
    @NotNull
    private final InputStream wrapped;
    @NotNull
    private final Mac mac;

    public MacInputStream(@NotNull InputStream wrapped, @NotNull Mac mac) {
        Intrinsics.checkNotNullParameter((Object)wrapped, (String)"wrapped");
        Intrinsics.checkNotNullParameter((Object)mac, (String)"mac");
        super(wrapped);
        this.wrapped = wrapped;
        this.mac = mac;
    }

    @NotNull
    public final InputStream getWrapped() {
        return this.wrapped;
    }

    @NotNull
    public final Mac getMac() {
        return this.mac;
    }

    @Override
    public int read() {
        int n;
        int n2 = n = this.wrapped.read();
        boolean bl = false;
        if (n2 >= 0) {
            this.mac.update((byte)n2);
        }
        return n;
    }

    @Override
    public int read(@NotNull byte[] destination) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        return this.read(destination, 0, destination.length);
    }

    @Override
    public int read(@NotNull byte[] destination, int offset, int length) {
        int n;
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        int bytesRead = n = this.wrapped.read(destination, offset, length);
        boolean bl = false;
        if (bytesRead > 0) {
            this.mac.update(destination, offset, bytesRead);
        }
        return n;
    }
}

