/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.text.serializer.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.kyori.text.BlockNbtComponent;
import net.kyori.text.Component;
import net.kyori.text.event.ClickEvent;
import net.kyori.text.event.HoverEvent;
import net.kyori.text.format.Style;
import net.kyori.text.format.TextColor;
import net.kyori.text.format.TextDecoration;
import net.kyori.text.serializer.ComponentSerializer;
import net.kyori.text.serializer.gson.BlockNbtComponentPosSerializer;
import net.kyori.text.serializer.gson.ComponentSerializerImpl;
import net.kyori.text.serializer.gson.NameMapSerializer;
import net.kyori.text.serializer.gson.StyleSerializer;
import net.kyori.text.serializer.gson.TextColorWrapper;
import org.checkerframework.checker.nullness.qual.NonNull;

public class GsonComponentSerializer
implements ComponentSerializer<Component, Component, String>,
JsonDeserializer<Component>,
JsonSerializer<Component> {
    public static final GsonComponentSerializer INSTANCE = new GsonComponentSerializer();
    static final Gson GSON = GsonComponentSerializer.populate(new GsonBuilder()).create();

    public static @NonNull GsonBuilder populate(@NonNull GsonBuilder builder) {
        builder.registerTypeHierarchyAdapter(Component.class, ComponentSerializerImpl.INSTANCE).registerTypeAdapter((Type)((Object)Style.class), StyleSerializer.INSTANCE).registerTypeAdapter((Type)((Object)ClickEvent.Action.class), new NameMapSerializer<ClickEvent.Action>("click action", ClickEvent.Action.NAMES)).registerTypeAdapter((Type)((Object)HoverEvent.Action.class), new NameMapSerializer<HoverEvent.Action>("hover action", HoverEvent.Action.NAMES)).registerTypeAdapter((Type)((Object)TextColorWrapper.class), new TextColorWrapper.Serializer()).registerTypeAdapter((Type)((Object)TextColor.class), new NameMapSerializer<TextColor>("text color", TextColor.NAMES)).registerTypeAdapter((Type)((Object)TextDecoration.class), new NameMapSerializer<TextDecoration>("text decoration", TextDecoration.NAMES)).registerTypeHierarchyAdapter(BlockNbtComponent.Pos.class, BlockNbtComponentPosSerializer.INSTANCE);
        return builder;
    }

    @Override
    public @NonNull Component deserialize(@NonNull String string) {
        return GSON.fromJson(string, Component.class);
    }

    @Override
    public @NonNull String serialize(@NonNull Component component) {
        return GSON.toJson(component);
    }

    @Override
    @Deprecated
    public Component deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return ComponentSerializerImpl.INSTANCE.deserialize(json, typeOfT, context);
    }

    @Override
    @Deprecated
    public JsonElement serialize(Component src, Type typeOfSrc, JsonSerializationContext context) {
        return ComponentSerializerImpl.INSTANCE.serialize(src, typeOfSrc, context);
    }
}

