/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.velocitypowered.api.event.connection.ConnectionHandshakeEvent;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.InboundConnection;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.config.PlayerInfoForwarding;
import com.velocitypowered.proxy.connection.ConnectionType;
import com.velocitypowered.proxy.connection.ConnectionTypes;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.client.InitialInboundConnection;
import com.velocitypowered.proxy.connection.client.LoginSessionHandler;
import com.velocitypowered.proxy.connection.client.StatusSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.StateRegistry;
import com.velocitypowered.proxy.protocol.packet.Handshake;
import com.velocitypowered.proxy.protocol.packet.LegacyDisconnect;
import com.velocitypowered.proxy.protocol.packet.LegacyHandshake;
import com.velocitypowered.proxy.protocol.packet.LegacyPing;
import io.netty.buffer.ByteBuf;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;

public class HandshakeSessionHandler
implements MinecraftSessionHandler {
    private static final Logger LOGGER = LogManager.getLogger(HandshakeSessionHandler.class);
    private final MinecraftConnection connection;
    private final VelocityServer server;

    public HandshakeSessionHandler(MinecraftConnection connection, VelocityServer server) {
        this.connection = Preconditions.checkNotNull(connection, "connection");
        this.server = Preconditions.checkNotNull(server, "server");
    }

    @Override
    public boolean handle(LegacyPing packet) {
        this.connection.setProtocolVersion(ProtocolVersion.LEGACY);
        StatusSessionHandler handler = new StatusSessionHandler(this.server, this.connection, new LegacyInboundConnection(this.connection, packet));
        this.connection.setSessionHandler(handler);
        handler.handle(packet);
        return true;
    }

    @Override
    public boolean handle(LegacyHandshake packet) {
        this.connection.closeWith(LegacyDisconnect.from(Component.text("Your client is old, please upgrade!", (TextColor)NamedTextColor.RED)));
        return true;
    }

    @Override
    public boolean handle(Handshake handshake) {
        InitialInboundConnection ic = new InitialInboundConnection(this.connection, HandshakeSessionHandler.cleanVhost(handshake.getServerAddress()), handshake);
        StateRegistry nextState = HandshakeSessionHandler.getStateForProtocol(handshake.getNextStatus());
        if (nextState == null) {
            LOGGER.error("{} provided invalid protocol {}", (Object)ic, (Object)handshake.getNextStatus());
            this.connection.close(true);
        } else {
            this.connection.setState(nextState);
            this.connection.setProtocolVersion(handshake.getProtocolVersion());
            this.connection.setAssociation(ic);
            switch (nextState) {
                case STATUS: {
                    this.connection.setSessionHandler(new StatusSessionHandler(this.server, this.connection, ic));
                    break;
                }
                case LOGIN: {
                    this.handleLogin(handshake, ic);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"getStateForProtocol provided invalid state!");
                }
            }
        }
        return true;
    }

    private static @Nullable StateRegistry getStateForProtocol(int status) {
        switch (status) {
            case 1: {
                return StateRegistry.STATUS;
            }
            case 2: {
                return StateRegistry.LOGIN;
            }
        }
        return null;
    }

    private void handleLogin(Handshake handshake, InitialInboundConnection ic) {
        if (!ProtocolVersion.isSupported(handshake.getProtocolVersion())) {
            ic.disconnectQuietly(Component.translatable("multiplayer.disconnect.outdated_client"));
            return;
        }
        InetAddress address = ((InetSocketAddress)this.connection.getRemoteAddress()).getAddress();
        if (!this.server.getIpAttemptLimiter().attempt(address)) {
            ic.disconnectQuietly(Component.text("You are logging in too fast, try again later."));
            return;
        }
        this.connection.setType(this.getHandshakeConnectionType(handshake));
        if (this.server.getConfiguration().getPlayerInfoForwardingMode() == PlayerInfoForwarding.MODERN && handshake.getProtocolVersion().compareTo(ProtocolVersion.MINECRAFT_1_13) < 0) {
            ic.disconnectQuietly(Component.text("This server is only compatible with 1.13 and above."));
            return;
        }
        this.server.getEventManager().fireAndForget(new ConnectionHandshakeEvent(ic));
        this.connection.setSessionHandler(new LoginSessionHandler(this.server, this.connection, ic));
    }

    private ConnectionType getHandshakeConnectionType(Handshake handshake) {
        if (handshake.getServerAddress().endsWith("\u0000FML\u0000") && handshake.getProtocolVersion().compareTo(ProtocolVersion.MINECRAFT_1_13) < 0) {
            return ConnectionTypes.LEGACY_FORGE;
        }
        if (handshake.getProtocolVersion().compareTo(ProtocolVersion.MINECRAFT_1_7_6) <= 0) {
            return ConnectionTypes.UNDETERMINED_17;
        }
        return ConnectionTypes.VANILLA;
    }

    @VisibleForTesting
    static String cleanVhost(String hostname) {
        String cleaned = hostname;
        int zeroIdx = cleaned.indexOf(0);
        if (zeroIdx > -1) {
            cleaned = hostname.substring(0, zeroIdx);
        }
        if (!cleaned.isEmpty() && cleaned.charAt(cleaned.length() - 1) == '.') {
            cleaned = cleaned.substring(0, cleaned.length() - 1);
        }
        return cleaned;
    }

    @Override
    public void handleGeneric(MinecraftPacket packet) {
        this.connection.close(true);
    }

    @Override
    public void handleUnknown(ByteBuf buf) {
        this.connection.close(true);
    }

    private static class LegacyInboundConnection
    implements InboundConnection {
        private final MinecraftConnection connection;
        private final LegacyPing ping;

        private LegacyInboundConnection(MinecraftConnection connection, LegacyPing ping) {
            this.connection = connection;
            this.ping = ping;
        }

        @Override
        public InetSocketAddress getRemoteAddress() {
            return (InetSocketAddress)this.connection.getRemoteAddress();
        }

        @Override
        public Optional<InetSocketAddress> getVirtualHost() {
            return Optional.ofNullable(this.ping.getVhost());
        }

        @Override
        public boolean isActive() {
            return !this.connection.isClosed();
        }

        @Override
        public ProtocolVersion getProtocolVersion() {
            return ProtocolVersion.LEGACY;
        }
    }
}

