/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.client;

import com.velocitypowered.api.proxy.player.PlayerSettings;
import com.velocitypowered.api.proxy.player.SkinParts;
import com.velocitypowered.proxy.protocol.packet.ClientSettings;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ClientSettingsWrapper
implements PlayerSettings {
    static final PlayerSettings DEFAULT = new ClientSettingsWrapper(new ClientSettings("en_US", 10, 0, true, 127, 1, true));
    private final ClientSettings settings;
    private final SkinParts parts;
    private @Nullable Locale locale;

    ClientSettingsWrapper(ClientSettings settings) {
        this.settings = settings;
        this.parts = new SkinParts((byte)settings.getSkinParts());
    }

    @Override
    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.forLanguageTag(this.settings.getLocale().replaceAll("_", "-"));
        }
        return this.locale;
    }

    @Override
    public byte getViewDistance() {
        return this.settings.getViewDistance();
    }

    @Override
    public PlayerSettings.ChatMode getChatMode() {
        int chat = this.settings.getChatVisibility();
        if (chat < 0 || chat > 2) {
            return PlayerSettings.ChatMode.SHOWN;
        }
        return PlayerSettings.ChatMode.values()[chat];
    }

    @Override
    public boolean hasChatColors() {
        return this.settings.isChatColors();
    }

    @Override
    public SkinParts getSkinParts() {
        return this.parts;
    }

    @Override
    public PlayerSettings.MainHand getMainHand() {
        return this.settings.getMainHand() == 1 ? PlayerSettings.MainHand.RIGHT : PlayerSettings.MainHand.LEFT;
    }
}

