/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept '__mark_inode_dirty' function
 *
 * Notes:
 *  - Enforce Exploit Detection CFI
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - Created: 20.XI.2018
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#include "../../../../../p_lkrg_main.h"


char p_pcfi_mark_inode_dirty_kretprobe_state = 0;

static struct kretprobe p_pcfi_mark_inode_dirty_kretprobe = {
    .kp.symbol_name = "__mark_inode_dirty",
    .handler = p_pcfi_mark_inode_dirty_ret,
    .entry_handler = p_pcfi_mark_inode_dirty_entry,
    .data_size = sizeof(struct p_pcfi_mark_inode_dirty_data),
};

/*
 * x86-64 syscall ABI:
 *  *rax - syscall_number
 *    rdi - 1st argument
 *    rsi - 2nd argument
 *    rdx - 3rd argument
 *    rcx - 4th argument
 *
 *    r8  - 5th one
 *    r9  - 6th one
 */

int p_pcfi_mark_inode_dirty_entry(struct kretprobe_instance *p_ri, struct pt_regs *p_regs) {

   struct p_ed_process *p_tmp;
   unsigned long p_flags;

   p_ed_pcfi_cpu(1);

//   p_ed_enforce_validation();

   if (p_is_ed_task(current)) {
      p_tasks_read_lock(&p_flags);

      if ( (p_tmp = p_find_ed_by_pid(task_pid_nr(current))) != NULL) {
         if (p_ed_enforce_pcfi(current, p_tmp, p_regs)) {
            struct inode *p_inode = (struct inode *)p_regs_get_arg1(p_regs);
            p_print_log(P_LOG_ALERT, "BLOCK: Task: Changing inode %lu's mode from 0%o to 0 and uid/gid to 65534",
               p_inode->i_ino, p_inode->i_mode);

            p_set_uid(&p_inode->i_uid, 65534);
            p_set_gid(&p_inode->i_gid, 65534);
//            p_inode->i_mode = 0;
            p_inode->i_mode = 0x0 | S_IFREG;
         }
      }
      p_tasks_read_unlock(&p_flags);
   }

   return 0;
}

int p_pcfi_mark_inode_dirty_ret(struct kretprobe_instance *p_ri, struct pt_regs *p_regs) {

//   p_ed_enforce_validation();

   return 0;
}


GENERATE_INSTALL_FUNC(pcfi_mark_inode_dirty)
