/*
 * Decompiled with CFR 0.152.
 */
package driftwood.moldb2.selection;

import driftwood.moldb2.AtomState;
import driftwood.moldb2.Selection;
import driftwood.moldb2.selection.AndTerm;
import driftwood.moldb2.selection.AtomTerm;
import driftwood.moldb2.selection.ChainTerm;
import driftwood.moldb2.selection.FromResTerm;
import driftwood.moldb2.selection.KeywordTerm;
import driftwood.moldb2.selection.NotTerm;
import driftwood.moldb2.selection.OrTerm;
import driftwood.moldb2.selection.ResNameTerm;
import driftwood.moldb2.selection.WithinPointTerm;
import driftwood.moldb2.selection.WithinSelectionTerm;
import driftwood.parser.CharWindow;
import driftwood.parser.RegexTokenMatcher;
import driftwood.parser.TokenWindow;
import java.io.IOException;
import java.io.PrintStream;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SelectionParser {
    final Matcher LOOSE_OR = Pattern.compile("\\||or").matcher("");
    final Matcher LOOSE_AND = Pattern.compile("&|and").matcher("");
    final Matcher TIGHT_OR = Pattern.compile(",").matcher("");
    final Matcher NOT_SYMBOL = Pattern.compile("!|not").matcher("");
    final Matcher START_SUBSEL = Pattern.compile("\\(").matcher("");
    final Matcher END_SUBSEL = Pattern.compile("\\)").matcher("");
    final Matcher KEYWORD = Pattern.compile("\\*|all|none|protein|mc|sc|base|alpha|beta|nitrogen|carbon|oxygen|sulfur|phosphorus|hydrogen|metal|polar|nonpolar|charged|donor|acceptor|aromatic|methyl|het|water|dna|rna").matcher("");
    final Matcher CHAIN = Pattern.compile("chain([A-Za-z0-9_])").matcher("");
    final Matcher RESNAME = Pattern.compile("res([A-Za-z0-9_]{3})").matcher("");
    final Matcher ATOM = Pattern.compile("atom([A-Za-z0-9_]{4})").matcher("");
    final Matcher RESNUM = Pattern.compile("(" + RegexTokenMatcher.SIGNED_INT + ")([A-Z])?").matcher("");
    final Matcher RESRANGE = Pattern.compile(this.RESNUM.pattern() + "-" + this.RESNUM.pattern()).matcher("");
    final Matcher RANGE_OP = Pattern.compile("-|to").matcher("");
    final Matcher WITHIN = Pattern.compile("within").matcher("");
    final Matcher OF = Pattern.compile("of").matcher("");
    final Matcher COMMA = Pattern.compile(",").matcher("");
    final Matcher REAL = RegexTokenMatcher.SIGNED_REAL.matcher("");
    final Matcher FROMRES = Pattern.compile("fromres").matcher("");
    final Pattern[] toIgnore = new Pattern[]{RegexTokenMatcher.HASH_COMMENT, RegexTokenMatcher.WHITESPACE};
    final Matcher WORD = Pattern.compile("[A-Za-z_]+").matcher("");
    final Matcher OPERATOR = Pattern.compile("[!&*()|,-]").matcher("");
    final Matcher REAL_NOT_INT;
    final Pattern[] toAccept;
    TokenWindow t;

    public SelectionParser() {
        String string = "(?:[+-]?)";
        String string2 = "(?:[0-9]+)";
        String string3 = "(?:[1-9][0-9]*)";
        String string4 = "(?:0|" + string3 + ")";
        String string5 = "(?:" + string + string4 + ")";
        String string6 = "(?:" + string4 + "(?:\\.(?:" + string2 + ")?)?)";
        String string7 = "(?:" + string4 + "\\.(?:" + string2 + ")?)";
        String string8 = "(?:" + string6 + "[eE]" + string5 + ")";
        String string9 = "(?:" + string + "(?:" + string7 + "|" + string8 + "))";
        this.REAL_NOT_INT = Pattern.compile(string9).matcher("");
        this.toAccept = new Pattern[]{this.WORD.pattern(), this.RESRANGE.pattern(), this.REAL_NOT_INT.pattern(), this.RESNUM.pattern(), this.REAL.pattern(), this.OPERATOR.pattern()};
    }

    public Selection parse(String string) throws ParseException, IOException {
        return this.parse(new CharWindow(string));
    }

    public Selection parse(CharWindow charWindow) throws ParseException, IOException {
        RegexTokenMatcher regexTokenMatcher = new RegexTokenMatcher(RegexTokenMatcher.joinPatterns(this.toAccept), RegexTokenMatcher.joinPatterns(this.toIgnore));
        this.t = new TokenWindow(charWindow, regexTokenMatcher);
        Selection selection = this.loose_or();
        if (selection == null) {
            throw this.t.syntaxError("Empty expression!");
        }
        if (this.t.token() != null) {
            throw this.t.syntaxError("Unexpected token at end of expression [" + this.t.token() + "]");
        }
        return selection;
    }

    Selection loose_or() throws ParseException, IOException {
        Selection selection = this.loose_and();
        if (selection == null) {
            return null;
        }
        if (this.t.accept(this.LOOSE_OR)) {
            OrTerm orTerm = new OrTerm(selection);
            do {
                if ((selection = this.loose_and()) == null) {
                    throw this.t.syntaxError("Incomplete OR expression");
                }
                orTerm.add(selection);
            } while (this.t.accept(this.LOOSE_OR));
            return orTerm;
        }
        return selection;
    }

    Selection loose_and() throws ParseException, IOException {
        Selection selection = this.tight_and();
        if (selection == null) {
            return null;
        }
        if (this.t.accept(this.LOOSE_AND)) {
            AndTerm andTerm = new AndTerm(selection);
            do {
                if ((selection = this.tight_and()) == null) {
                    throw this.t.syntaxError("Incomplete AND expression");
                }
                andTerm.add(selection);
            } while (this.t.accept(this.LOOSE_AND));
            return andTerm;
        }
        return selection;
    }

    Selection tight_and() throws ParseException, IOException {
        Selection selection = this.tight_or();
        if (selection == null) {
            return null;
        }
        Selection selection2 = this.tight_or();
        if (selection2 == null) {
            return selection;
        }
        AndTerm andTerm = new AndTerm(selection);
        while (selection2 != null) {
            andTerm.add(selection2);
            selection2 = this.tight_or();
        }
        return andTerm;
    }

    Selection tight_or() throws ParseException, IOException {
        Selection selection = this.not_expr();
        if (selection == null) {
            return null;
        }
        if (this.t.accept(this.TIGHT_OR)) {
            OrTerm orTerm = new OrTerm(selection);
            do {
                if ((selection = this.not_expr()) == null) {
                    throw this.t.syntaxError("Incomplete OR expression");
                }
                orTerm.add(selection);
            } while (this.t.accept(this.TIGHT_OR));
            return orTerm;
        }
        return selection;
    }

    Selection not_expr() throws ParseException, IOException {
        boolean bl = this.t.accept(this.NOT_SYMBOL);
        Selection selection = this.subexpr();
        if (selection == null) {
            selection = this.simple_expr();
        }
        if (selection == null && bl) {
            throw this.t.syntaxError("Incomplete NOT expression");
        }
        if (selection == null) {
            return null;
        }
        if (bl) {
            return new NotTerm(selection);
        }
        return selection;
    }

    Selection subexpr() throws ParseException, IOException {
        if (this.t.accept(this.START_SUBSEL)) {
            Selection selection = this.loose_or();
            if (selection == null) {
                throw this.t.syntaxError("Empty subexpression!");
            }
            this.t.require(this.END_SUBSEL);
            return selection;
        }
        return null;
    }

    Selection simple_expr() throws ParseException, IOException {
        if (this.t.accept(this.KEYWORD)) {
            return KeywordTerm.get(this.KEYWORD.group());
        }
        if (this.t.accept(this.CHAIN)) {
            return new ChainTerm(this.CHAIN.group(1));
        }
        if (this.t.accept(this.RESNAME)) {
            return new ResNameTerm(this.RESNAME.group(1));
        }
        if (this.t.accept(this.ATOM)) {
            return new AtomTerm(this.ATOM.group(1));
        }
        if (this.t.accept(this.RESRANGE)) {
            return this.res_range();
        }
        if (this.t.accept(this.RESNUM)) {
            return this.res_num();
        }
        if (this.t.accept(this.WITHIN)) {
            return this.within();
        }
        if (this.t.accept(this.FROMRES)) {
            return this.from_res();
        }
        return null;
    }

    Selection res_range() throws ParseException, IOException {
        try {
            int n = Integer.parseInt(this.RESRANGE.group(1));
            int n2 = Integer.parseInt(this.RESRANGE.group(3));
            String string = this.RESRANGE.group(2);
            String string2 = this.RESRANGE.group(4);
            if (string == null) {
                string = " ";
            }
            if (string2 == null) {
                string2 = " ";
            }
            return new DummySelection("range " + n + string + " to " + n2 + string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Unexpected difficulty parsing integer [" + this.t.token() + "]", 0);
        }
    }

    Selection res_num() throws ParseException, IOException {
        try {
            int n = Integer.parseInt(this.RESNUM.group(1));
            String string = this.RESNUM.group(2);
            if (string == null) {
                string = " ";
            }
            if (this.t.accept(this.RANGE_OP)) {
                this.t.require(this.RESNUM);
                int n2 = Integer.parseInt(this.RESNUM.group(1));
                String string2 = this.RESNUM.group(2);
                if (string2 == null) {
                    string2 = " ";
                }
                return new DummySelection("range " + n + string + " to " + n2 + string2);
            }
            return new DummySelection("single res " + n + string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Unexpected difficulty parsing integer [" + this.t.token() + "]", 0);
        }
    }

    Selection within() throws ParseException, IOException {
        double d = this.real();
        this.t.require(this.OF);
        Selection selection = this.subexpr();
        if (selection != null) {
            return new WithinSelectionTerm(d, selection);
        }
        double d2 = this.real();
        this.t.accept(this.COMMA);
        double d3 = this.real();
        this.t.accept(this.COMMA);
        double d4 = this.real();
        return new WithinPointTerm(d, d2, d3, d4);
    }

    Selection from_res() throws ParseException, IOException {
        Selection selection = this.subexpr();
        if (selection == null) {
            throw this.t.syntaxError("fromres must be followed by (SELECTION)");
        }
        return new FromResTerm(selection);
    }

    double real() throws ParseException, IOException {
        this.t.require(this.REAL);
        try {
            return Double.parseDouble(this.REAL.group());
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Unexpected difficulty parsing real number [" + this.t.token() + "]", 0);
        }
    }

    public static void main(String[] stringArray) {
        SelectionParser selectionParser = new SelectionParser();
        PrintStream printStream = System.out;
        try {
            SelectionParser.test_fail("");
            SelectionParser.test_fail("()");
            SelectionParser.test_fail("(");
            SelectionParser.test_fail("(&)");
            SelectionParser.test_fail("!&");
            SelectionParser.test_fail("within 42 of (!)");
            SelectionParser.test_fail("all or ");
            SelectionParser.test_fail("1 - - 2");
            SelectionParser.test_ok("all");
            SelectionParser.test_ok("all none");
            SelectionParser.test_ok(" all  none ");
            SelectionParser.test_ok("all & none & het");
            SelectionParser.test_ok("all,none");
            SelectionParser.test_ok("all or none and not het");
            SelectionParser.test_ok("all,none !het");
            SelectionParser.test_ok("(all,none) within 8 of 1, 2.3, 4.5 not within 10 of (het | none)");
            SelectionParser.test_ok("atom_CA_ chainB,het");
            SelectionParser.test_ok("resGLY,resPRO atom_N__,atom_CA_,atom_C__,atom_O__");
            SelectionParser.test_ok("1-2 -1 -2 -1--2 -1-2 -11A--12B -5 6");
            SelectionParser.test_ok("1 - 2 -1 - -2 3 --4C 5 to 6 7D to 8E");
            printStream.println();
            printStream.println("=== All tests passed! ===");
            printStream.println();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void test_ok(String string) throws IOException, ParseException {
        SelectionParser selectionParser = new SelectionParser();
        PrintStream printStream = System.out;
        printStream.println("'" + string + "' = " + selectionParser.parse(string));
    }

    private static void test_fail(String string) throws IOException {
        try {
            SelectionParser.test_ok(string);
            throw new RuntimeException("Bad expression parsed OK: '" + string + "'");
        }
        catch (ParseException parseException) {
            PrintStream printStream = System.out;
            printStream.println("unparsable (as expected): '" + string + "'");
            printStream.println(parseException.getMessage());
            return;
        }
    }

    static class DummySelection
    extends Selection {
        String name;

        public DummySelection(String string) {
            this.name = string;
        }

        protected boolean selectImpl(AtomState atomState) {
            System.err.println("*** Warning: using dummy object [" + this.name + "] in selection attempt!");
            return false;
        }

        public String toString() {
            return "[" + this.name + "]";
        }
    }
}

