/*
 * Decompiled with CFR 0.152.
 */
package driftwood.moldb2;

import driftwood.data.CheapSet;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbSecondaryStructure;
import driftwood.moldb2.Residue;
import driftwood.moldb2.ResidueException;
import driftwood.util.SoftLog;
import driftwood.util.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PdbReader {
    CoordinateFile coordFile;
    Model model;
    Map states;
    Map residues;
    int autoSerial;
    int countTER;
    CheapSet stringCache = new CheapSet();
    boolean trimSegID = false;
    boolean useSegID = false;
    HashMap v2tov3Map = null;
    static final String[] allElementNames = new String[]{"H", "HE", "LI", "BE", "B", "C", "N", "O", "F", "NE", "NA", "MG", "AL", "SI", "P", "S", "CL", "AR", "K", "CA", "SC", "TI", "V", "CR", "MN", "FE", "CO", "NI", "CU", "ZN", "GA", "GE", "AS", "SE", "BR", "KR", "RB", "SR", "Y", "ZR", "NB", "MO", "TC", "RU", "RH", "PD", "AG", "CD", "IN", "SN", "CB", "TE", "I", "XE", "CS", "BA", "LA", "CE", "PR", "ND", "PM", "SM", "EU", "GD", "TB", "DY", "HO", "ER", "TM", "YB", "LU", "HF", "TA", "W", "RE", "OS", "IR", "PT", "AU", "HG", "TL", "PB", "BI", "PO", "AT", "RN", "FR", "RA", "AC", "TH", "PA", "U", "NP", "PU", "AM", "CM", "BK", "CF", "ES", "FM", "MD", "NO", "LR", "RF", "DB", "SG", "BH", "HS", "MT", "DS"};
    static final String[] ambiguous_resnames = new String[]{"PHF", "HF3", "HF5", " HG", "HG2", "HGB", "HGC", "HGI", "MAC", "MBO", "MMC", "PHG", "PMB", "AAS", "AMS", "BE7", "CMH", "EMC", "EMT", " HO", "HO3"};
    static Map elementNames = null;
    static ArrayList ambigAtomResidues = null;

    public PdbReader() {
        this.clearData();
    }

    void initData() throws IOException {
        this.coordFile = new CoordinateFile();
        this.model = null;
        this.states = new HashMap();
        this.residues = new HashMap();
        this.autoSerial = -9999;
        this.countTER = 0;
        this.v2tov3Map = new HashMap();
        InputStream inputStream = this.getClass().getResourceAsStream("PDBv2toPDBv3.hashmap.txt");
        if (inputStream == null) {
            throw new IOException("File not found in JAR: singleres.pdb");
        }
        this.readV2toV3map(inputStream);
    }

    private void readV2toV3map(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            if (string.startsWith("#")) continue;
            String[] stringArray = Strings.explode(string, ':', false, false);
            this.v2tov3Map.put(stringArray[1], stringArray[0]);
        }
        bufferedReader.close();
    }

    void clearData() {
        this.coordFile = null;
        this.model = null;
        this.states = null;
        this.residues = null;
        this.autoSerial = -9999;
        this.countTER = 0;
        this.stringCache.clear();
        this.v2tov3Map = null;
    }

    String intern(String string) {
        String string2 = (String)this.stringCache.get(string);
        if (string2 == null) {
            this.stringCache.add(string);
            return string;
        }
        return string2;
    }

    public CoordinateFile read(File file) throws IOException {
        FileReader fileReader = new FileReader(file);
        CoordinateFile coordinateFile = this.read(fileReader);
        coordinateFile.setFile(file);
        ((Reader)fileReader).close();
        return coordinateFile;
    }

    public CoordinateFile read(InputStream inputStream) throws IOException {
        return this.read(new InputStreamReader(inputStream));
    }

    public CoordinateFile read(Reader reader) throws IOException {
        return this.read(new LineNumberReader(reader));
    }

    public CoordinateFile read(LineNumberReader lineNumberReader) throws IOException {
        Object object;
        String string;
        this.initData();
        int n = 0;
        while ((string = lineNumberReader.readLine()) != null) {
            try {
                if (string.startsWith("ATOM  ") || string.startsWith("HETATM")) {
                    if (this.isVersion23(string)) {
                        ++n;
                    }
                    this.readAtom(string);
                    continue;
                }
                if (string.startsWith("MODEL ") && string.length() >= 14) {
                    if (this.model != null) {
                        this.model.setStates(this.states);
                    }
                    this.model = new Model(string.substring(10, 14).trim());
                    this.coordFile.add(this.model);
                    this.states.clear();
                    this.residues.clear();
                    continue;
                }
                if (string.startsWith("ENDMDL")) {
                    if (this.model != null) {
                        this.model.setStates(this.states);
                    }
                    this.model = null;
                    continue;
                }
                if (string.startsWith("TER")) {
                    this.residues.clear();
                    ++this.countTER;
                    continue;
                }
                if (string.startsWith("MASTER") || string.startsWith("END")) continue;
                if (string.startsWith("HEADER") && string.length() >= 66) {
                    this.coordFile.setIdCode(string.substring(62, 66));
                }
                object = string.length() >= 6 ? string.substring(0, 6) : string;
                this.coordFile.addHeader(this.intern((String)object), string);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                SoftLog.err.println("Error reading from PDB file, line " + lineNumberReader.getLineNumber() + ": " + indexOutOfBoundsException.getMessage());
            }
            catch (NumberFormatException numberFormatException) {
                SoftLog.err.println("Error reading from PDB file, line " + lineNumberReader.getLineNumber() + ": " + numberFormatException.getMessage());
            }
        }
        if (this.model != null) {
            this.model.setStates(this.states);
        }
        object = this.coordFile;
        this.clearData();
        Iterator iterator = ((CoordinateFile)object).getModels().iterator();
        while (iterator.hasNext()) {
            Model model = (Model)iterator.next();
            try {
                model.fillInStates(false);
            }
            catch (AtomException atomException) {
                SoftLog.err.println("Unable to find states for all atoms in model!");
                atomException.printStackTrace(SoftLog.err);
            }
        }
        ((CoordinateFile)object).setSecondaryStructure(new PdbSecondaryStructure(((CoordinateFile)object).getHeaders()));
        ((CoordinateFile)object).setPdbv2Count(n);
        return object;
    }

    public boolean isVersion23(String string) {
        String string2 = string.substring(12, 16) + " " + string.substring(17, 20);
        return this.v2tov3Map.containsKey(string2);
    }

    void readAtom(String string) throws NumberFormatException {
        String string2;
        this.checkModel();
        Residue residue = this.makeResidue(string);
        Atom atom = this.makeAtom(residue, string);
        String string3 = string.substring(6, 11);
        AtomState atomState = new AtomState(atom, string3);
        String string4 = this.intern(string.substring(16, 17));
        atomState.setAltConf(string4);
        ModelState modelState = this.makeState(string4);
        try {
            modelState.add(atomState);
        }
        catch (AtomException atomException) {
            SoftLog.err.println(atomException.getMessage());
            atom = this.makeUniqueAtom(residue, string);
            atomState = new AtomState(atom, string3);
            atomState.setAltConf(string4);
            try {
                modelState.add(atomState);
            }
            catch (AtomException atomException2) {
                atomException2.printStackTrace();
                System.err.println("Logical error in PDB construction!");
            }
        }
        double d = Double.parseDouble(string.substring(30, 38).trim());
        double d2 = Double.parseDouble(string.substring(38, 46).trim());
        double d3 = Double.parseDouble(string.substring(46, 54).trim());
        atomState.setXYZ(d, d2, d3);
        if (string.length() >= 60 && (string2 = string.substring(54, 60).trim()).length() > 0) {
            atomState.setOccupancy(Double.parseDouble(string2));
        }
        if (string.length() >= 66 && (string2 = string.substring(60, 66).trim()).length() > 0) {
            atomState.setTempFactor(Double.parseDouble(string2));
        }
        if (string.length() >= 80 && string.charAt(78) != ' ') {
            if (string.charAt(79) == '-') {
                atomState.setCharge(48 - string.charAt(78));
            } else if (string.charAt(79) == '+') {
                atomState.setCharge(string.charAt(78) - 48);
            }
        }
        if (string.length() > 80) {
            atomState.setPast80(this.intern(string.substring(80)));
        }
    }

    void checkModel() {
        if (this.model == null) {
            this.model = new Model("1");
            this.coordFile.add(this.model);
            this.states.clear();
            this.residues.clear();
        }
    }

    Residue makeResidue(String string) throws NumberFormatException {
        Residue residue;
        this.checkModel();
        String string2 = "    ";
        if (string.length() > 72) {
            string2 = string.length() >= 76 ? string.substring(72, 76) : Strings.justifyLeft(string.substring(72), 4);
        }
        String string3 = string.substring(17, 27);
        if (this.useSegID) {
            string3 = string3 + string2;
        }
        if ((residue = (Residue)this.residues.get(string3)) == null) {
            if (this.trimSegID) {
                string2 = string2.trim();
            }
            string2 = this.intern(string2);
            String string4 = this.intern(string.substring(21, 22));
            String string5 = this.intern(string.substring(22, 26));
            String string6 = this.intern(string.substring(26, 27));
            String string7 = this.intern(string.substring(17, 20));
            residue = new Residue(string4, string2, string5, string6, string7);
            residue.sectionID = this.countTER;
            this.residues.put(string3, residue);
            try {
                this.model.add(residue);
            }
            catch (ResidueException residueException) {
                SoftLog.err.println("Logical error: residue " + residue + " already exists in model.");
                residueException.printStackTrace(SoftLog.err);
            }
        }
        return residue;
    }

    ModelState makeState(String string) {
        ModelState modelState = (ModelState)this.states.get(string);
        if (modelState == null) {
            modelState = new ModelState();
            this.states.put(string, modelState);
            if (!" ".equals(string)) {
                modelState.setParent(this.makeState(" "));
            }
        }
        return modelState;
    }

    Atom makeAtom(Residue residue, String string) {
        return this.makeAtomImpl(residue, string, string.substring(12, 16));
    }

    Atom makeUniqueAtom(Residue residue, String string) {
        String string2 = string.substring(12, 16);
        int n = 1;
        String string3;
        Atom atom;
        while ((atom = residue.getAtom(string3 = string2 + n)) != null) {
            ++n;
        }
        return this.makeAtomImpl(residue, string, string3);
    }

    Atom makeAtomImpl(Residue residue, String string, String string2) {
        Atom atom = residue.getAtom(string2);
        if (atom == null) {
            String string3 = null;
            String string4 = residue.getName();
            if (string.length() >= 78) {
                string3 = PdbReader.getElement(string.substring(76, 78).trim(), string4);
            }
            if (string3 == null) {
                string3 = PdbReader.getElement(string2.substring(0, 2), string4);
            }
            if (string3 == null) {
                string3 = PdbReader.getElement(string2.substring(1, 2), string4);
            }
            if (string3 == null) {
                string3 = PdbReader.getElement(string2.substring(2, 3), string4);
            }
            if (string3 == null) {
                string3 = "XX";
            }
            atom = new Atom(this.intern(string2), string3, string.startsWith("HETATM"));
            try {
                residue.add(atom);
            }
            catch (AtomException atomException) {
                System.err.println("Logical error!");
                atomException.printStackTrace();
            }
        }
        return atom;
    }

    static String getElement(String string, String string2) {
        int n;
        if (elementNames == null) {
            elementNames = new HashMap();
            for (n = 0; n < allElementNames.length; ++n) {
                elementNames.put(allElementNames[n], allElementNames[n]);
            }
            elementNames.put("D", "H");
            elementNames.put("T", "H");
            elementNames.put("Q", "Q");
        }
        if (string.equals("HE") || string.equals("HF") || string.equals("HG") || string.equals("HO") || string.equals("HS")) {
            if (ambigAtomResidues == null) {
                ambigAtomResidues = new ArrayList();
                for (n = 0; n < ambiguous_resnames.length; ++n) {
                    ambigAtomResidues.add(ambiguous_resnames[n]);
                }
            }
            if (ambigAtomResidues.contains(string2)) {
                return (String)elementNames.get(string);
            }
            return "H";
        }
        return (String)elementNames.get(string);
    }

    public void setUseSegID(boolean bl) {
        this.useSegID = bl;
    }
}

