package aursources

type templateData struct {
	Name         string
	Desc         string
	Homepage     string
	Version      string
	License      string
	Sources      sources
	Maintainers  []string
	Contributors []string
	Provides     []string
	Conflicts    []string
	Backup       []string
	Depends      []string
	OptDepends   []string
	MakeDepends  []string
	Arches       []string
	Rel          string
	Prepare      string
	Build        string
	Package      string
	Install      string
}

type sources struct {
	DownloadURL string
	SHA256      string
	Format      string
}

const aurTemplateData = `# This file was generated by GoReleaser. DO NOT EDIT.

{{- range .Maintainers }}
# Maintainer: {{ . }}
{{- end }}
{{- range .Contributors }}
# Contributor: {{ . }}
{{- end }}

pkgname='{{ .Name }}'
pkgver={{ .Version }}
pkgrel={{ .Rel }}
pkgdesc={{ quoteField .Desc }}
url='{{ .Homepage }}'
arch=({{ pkgArray .Arches }})
license=('{{ .License }}')
{{- with .Provides }}
provides=({{ pkgArray . }})
{{- end }}
{{- with .Conflicts }}
conflicts=({{ pkgArray . }})
{{- end }}
{{- with .Depends }}
depends=({{ pkgArray . }})
{{- end }}
{{- with .MakeDepends }}
makedepends=({{ pkgArray . }})
{{- end }}
{{- with .OptDepends }}
optdepends=({{ pkgArray . }})
{{- end }}
{{- with .Backup }}
backup=({{ pkgArray . }})
{{- end }}
{{- if .Install }}
install={{ .Name }}.install
{{- end }}

{{- with .Sources }}
source=("${pkgname}_${pkgver}.{{ .Format }}::{{ .DownloadURL }}")
sha256sums=('{{ .SHA256 }}')
{{ end }}

{{-  with .Prepare -}}
prepare() {
{{ fixLines . }}
}
{{ end }}

{{-  with .Build -}}
build() {
{{ fixLines . }}
}
{{ end }}

{{-  with .Package -}}
package() {
{{ fixLines . }}
}
{{ end }}`

const srcInfoTemplate = `pkgbase = {{ .Name }}
	pkgdesc = {{ .Desc }}
	pkgver = {{ .Version }}
	pkgrel = {{ .Rel }}
	{{ with .Homepage -}}
	url = {{ . }}
	{{ end -}}
	{{ range .Arches -}}
	arch = {{ . }}
	{{ end -}}
	{{ with .License -}}
	license = {{ . }}
	{{ end -}}
	{{ range .OptDepends -}}
	optdepends = {{ . }}
	{{ end -}}
	{{ range .Depends -}}
	depends = {{ . }}
	{{ end -}}
	{{ range .MakeDepends -}}
	makedepends = {{ . }}
	{{ end -}}
	{{ range .Conflicts -}}
	conflicts = {{ . }}
	{{ end -}}
	{{ range .Provides -}}
	provides = {{ . }}
	{{ end -}}
	{{- with .Sources }}
	source = {{ .DownloadURL }}
	sha256sums = {{ .SHA256 }}
	{{ end -}}
{{ printf "\n" -}}
pkgname = {{ .Name }}
`
