// Code generated by cmd/lexgen (see Makefile's lexgen); DO NOT EDIT.

package bsky

// schema: app.bsky.richtext.facet

import (
	"bytes"
	"encoding/json"
	"fmt"
	"io"

	"github.com/bluesky-social/indigo/lex/util"
	cbg "github.com/whyrusleeping/cbor-gen"
)

// RichtextFacet is a "main" in the app.bsky.richtext.facet schema.
//
// Annotation of a sub-string within rich text.
type RichtextFacet struct {
	Features []*RichtextFacet_Features_Elem `json:"features" cborgen:"features"`
	Index    *RichtextFacet_ByteSlice       `json:"index" cborgen:"index"`
}

// RichtextFacet_ByteSlice is a "byteSlice" in the app.bsky.richtext.facet schema.
//
// Specifies the sub-string range a facet feature applies to. Start index is inclusive, end index is exclusive. Indices are zero-indexed, counting bytes of the UTF-8 encoded text. NOTE: some languages, like Javascript, use UTF-16 or Unicode codepoints for string slice indexing; in these languages, convert to byte arrays before working with facets.
type RichtextFacet_ByteSlice struct {
	ByteEnd   int64 `json:"byteEnd" cborgen:"byteEnd"`
	ByteStart int64 `json:"byteStart" cborgen:"byteStart"`
}

type RichtextFacet_Features_Elem struct {
	RichtextFacet_Mention *RichtextFacet_Mention
	RichtextFacet_Link    *RichtextFacet_Link
	RichtextFacet_Tag     *RichtextFacet_Tag
}

func (t *RichtextFacet_Features_Elem) MarshalJSON() ([]byte, error) {
	if t.RichtextFacet_Mention != nil {
		t.RichtextFacet_Mention.LexiconTypeID = "app.bsky.richtext.facet#mention"
		return json.Marshal(t.RichtextFacet_Mention)
	}
	if t.RichtextFacet_Link != nil {
		t.RichtextFacet_Link.LexiconTypeID = "app.bsky.richtext.facet#link"
		return json.Marshal(t.RichtextFacet_Link)
	}
	if t.RichtextFacet_Tag != nil {
		t.RichtextFacet_Tag.LexiconTypeID = "app.bsky.richtext.facet#tag"
		return json.Marshal(t.RichtextFacet_Tag)
	}
	return nil, fmt.Errorf("cannot marshal empty enum")
}
func (t *RichtextFacet_Features_Elem) UnmarshalJSON(b []byte) error {
	typ, err := util.TypeExtract(b)
	if err != nil {
		return err
	}

	switch typ {
	case "app.bsky.richtext.facet#mention":
		t.RichtextFacet_Mention = new(RichtextFacet_Mention)
		return json.Unmarshal(b, t.RichtextFacet_Mention)
	case "app.bsky.richtext.facet#link":
		t.RichtextFacet_Link = new(RichtextFacet_Link)
		return json.Unmarshal(b, t.RichtextFacet_Link)
	case "app.bsky.richtext.facet#tag":
		t.RichtextFacet_Tag = new(RichtextFacet_Tag)
		return json.Unmarshal(b, t.RichtextFacet_Tag)

	default:
		return nil
	}
}

func (t *RichtextFacet_Features_Elem) MarshalCBOR(w io.Writer) error {

	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}
	if t.RichtextFacet_Mention != nil {
		return t.RichtextFacet_Mention.MarshalCBOR(w)
	}
	if t.RichtextFacet_Link != nil {
		return t.RichtextFacet_Link.MarshalCBOR(w)
	}
	if t.RichtextFacet_Tag != nil {
		return t.RichtextFacet_Tag.MarshalCBOR(w)
	}
	return fmt.Errorf("cannot cbor marshal empty enum")
}
func (t *RichtextFacet_Features_Elem) UnmarshalCBOR(r io.Reader) error {
	typ, b, err := util.CborTypeExtractReader(r)
	if err != nil {
		return err
	}

	switch typ {
	case "app.bsky.richtext.facet#mention":
		t.RichtextFacet_Mention = new(RichtextFacet_Mention)
		return t.RichtextFacet_Mention.UnmarshalCBOR(bytes.NewReader(b))
	case "app.bsky.richtext.facet#link":
		t.RichtextFacet_Link = new(RichtextFacet_Link)
		return t.RichtextFacet_Link.UnmarshalCBOR(bytes.NewReader(b))
	case "app.bsky.richtext.facet#tag":
		t.RichtextFacet_Tag = new(RichtextFacet_Tag)
		return t.RichtextFacet_Tag.UnmarshalCBOR(bytes.NewReader(b))

	default:
		return nil
	}
}

// RichtextFacet_Link is a "link" in the app.bsky.richtext.facet schema.
//
// Facet feature for a URL. The text URL may have been simplified or truncated, but the facet reference should be a complete URL.
//
// RECORDTYPE: RichtextFacet_Link
type RichtextFacet_Link struct {
	LexiconTypeID string `json:"$type,const=app.bsky.richtext.facet#link" cborgen:"$type,const=app.bsky.richtext.facet#link"`
	Uri           string `json:"uri" cborgen:"uri"`
}

// RichtextFacet_Mention is a "mention" in the app.bsky.richtext.facet schema.
//
// Facet feature for mention of another account. The text is usually a handle, including a '@' prefix, but the facet reference is a DID.
//
// RECORDTYPE: RichtextFacet_Mention
type RichtextFacet_Mention struct {
	LexiconTypeID string `json:"$type,const=app.bsky.richtext.facet#mention" cborgen:"$type,const=app.bsky.richtext.facet#mention"`
	Did           string `json:"did" cborgen:"did"`
}

// RichtextFacet_Tag is a "tag" in the app.bsky.richtext.facet schema.
//
// Facet feature for a hashtag. The text usually includes a '#' prefix, but the facet reference should not (except in the case of 'double hash tags').
//
// RECORDTYPE: RichtextFacet_Tag
type RichtextFacet_Tag struct {
	LexiconTypeID string `json:"$type,const=app.bsky.richtext.facet#tag" cborgen:"$type,const=app.bsky.richtext.facet#tag"`
	Tag           string `json:"tag" cborgen:"tag"`
}
