// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53recoverycontrolconfig

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
)

// WaitUntilClusterCreated uses the AWS Route53 Recovery Control Config API operation
// DescribeCluster to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Route53RecoveryControlConfig) WaitUntilClusterCreated(input *DescribeClusterInput) error {
	return c.WaitUntilClusterCreatedWithContext(aws.BackgroundContext(), input)
}

// WaitUntilClusterCreatedWithContext is an extended version of WaitUntilClusterCreated.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryControlConfig) WaitUntilClusterCreatedWithContext(ctx aws.Context, input *DescribeClusterInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilClusterCreated",
		MaxAttempts: 26,
		Delay:       request.ConstantWaiterDelay(5 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "Cluster.Status",
				Expected: "DEPLOYED",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "Cluster.Status",
				Expected: "PENDING",
			},
			{
				State:    request.RetryWaiterState,
				Matcher:  request.StatusWaiterMatch,
				Expected: 500,
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *DescribeClusterInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeClusterRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilClusterDeleted uses the AWS Route53 Recovery Control Config API operation
// DescribeCluster to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Route53RecoveryControlConfig) WaitUntilClusterDeleted(input *DescribeClusterInput) error {
	return c.WaitUntilClusterDeletedWithContext(aws.BackgroundContext(), input)
}

// WaitUntilClusterDeletedWithContext is an extended version of WaitUntilClusterDeleted.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryControlConfig) WaitUntilClusterDeletedWithContext(ctx aws.Context, input *DescribeClusterInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilClusterDeleted",
		MaxAttempts: 26,
		Delay:       request.ConstantWaiterDelay(5 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:    request.SuccessWaiterState,
				Matcher:  request.StatusWaiterMatch,
				Expected: 404,
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "Cluster.Status",
				Expected: "PENDING_DELETION",
			},
			{
				State:    request.RetryWaiterState,
				Matcher:  request.StatusWaiterMatch,
				Expected: 500,
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *DescribeClusterInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeClusterRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilControlPanelCreated uses the AWS Route53 Recovery Control Config API operation
// DescribeControlPanel to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Route53RecoveryControlConfig) WaitUntilControlPanelCreated(input *DescribeControlPanelInput) error {
	return c.WaitUntilControlPanelCreatedWithContext(aws.BackgroundContext(), input)
}

// WaitUntilControlPanelCreatedWithContext is an extended version of WaitUntilControlPanelCreated.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryControlConfig) WaitUntilControlPanelCreatedWithContext(ctx aws.Context, input *DescribeControlPanelInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilControlPanelCreated",
		MaxAttempts: 26,
		Delay:       request.ConstantWaiterDelay(5 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "ControlPanel.Status",
				Expected: "DEPLOYED",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "ControlPanel.Status",
				Expected: "PENDING",
			},
			{
				State:    request.RetryWaiterState,
				Matcher:  request.StatusWaiterMatch,
				Expected: 500,
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *DescribeControlPanelInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeControlPanelRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilControlPanelDeleted uses the AWS Route53 Recovery Control Config API operation
// DescribeControlPanel to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Route53RecoveryControlConfig) WaitUntilControlPanelDeleted(input *DescribeControlPanelInput) error {
	return c.WaitUntilControlPanelDeletedWithContext(aws.BackgroundContext(), input)
}

// WaitUntilControlPanelDeletedWithContext is an extended version of WaitUntilControlPanelDeleted.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryControlConfig) WaitUntilControlPanelDeletedWithContext(ctx aws.Context, input *DescribeControlPanelInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilControlPanelDeleted",
		MaxAttempts: 26,
		Delay:       request.ConstantWaiterDelay(5 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:    request.SuccessWaiterState,
				Matcher:  request.StatusWaiterMatch,
				Expected: 404,
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "ControlPanel.Status",
				Expected: "PENDING_DELETION",
			},
			{
				State:    request.RetryWaiterState,
				Matcher:  request.StatusWaiterMatch,
				Expected: 500,
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *DescribeControlPanelInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeControlPanelRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilRoutingControlCreated uses the AWS Route53 Recovery Control Config API operation
// DescribeRoutingControl to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Route53RecoveryControlConfig) WaitUntilRoutingControlCreated(input *DescribeRoutingControlInput) error {
	return c.WaitUntilRoutingControlCreatedWithContext(aws.BackgroundContext(), input)
}

// WaitUntilRoutingControlCreatedWithContext is an extended version of WaitUntilRoutingControlCreated.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryControlConfig) WaitUntilRoutingControlCreatedWithContext(ctx aws.Context, input *DescribeRoutingControlInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilRoutingControlCreated",
		MaxAttempts: 26,
		Delay:       request.ConstantWaiterDelay(5 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "RoutingControl.Status",
				Expected: "DEPLOYED",
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "RoutingControl.Status",
				Expected: "PENDING",
			},
			{
				State:    request.RetryWaiterState,
				Matcher:  request.StatusWaiterMatch,
				Expected: 500,
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *DescribeRoutingControlInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeRoutingControlRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilRoutingControlDeleted uses the AWS Route53 Recovery Control Config API operation
// DescribeRoutingControl to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Route53RecoveryControlConfig) WaitUntilRoutingControlDeleted(input *DescribeRoutingControlInput) error {
	return c.WaitUntilRoutingControlDeletedWithContext(aws.BackgroundContext(), input)
}

// WaitUntilRoutingControlDeletedWithContext is an extended version of WaitUntilRoutingControlDeleted.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryControlConfig) WaitUntilRoutingControlDeletedWithContext(ctx aws.Context, input *DescribeRoutingControlInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilRoutingControlDeleted",
		MaxAttempts: 26,
		Delay:       request.ConstantWaiterDelay(5 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:    request.SuccessWaiterState,
				Matcher:  request.StatusWaiterMatch,
				Expected: 404,
			},
			{
				State:   request.RetryWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "RoutingControl.Status",
				Expected: "PENDING_DELETION",
			},
			{
				State:    request.RetryWaiterState,
				Matcher:  request.StatusWaiterMatch,
				Expected: 500,
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *DescribeRoutingControlInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeRoutingControlRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}
