package sql

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// VulnerabilityAssessmentBaselinesClient is the the Azure SQL Database management API provides a RESTful set of web
// services that interact with Azure SQL Database services to manage your databases. The API enables you to create,
// retrieve, update, and delete databases.
type VulnerabilityAssessmentBaselinesClient struct {
	BaseClient
}

// NewVulnerabilityAssessmentBaselinesClient creates an instance of the VulnerabilityAssessmentBaselinesClient client.
func NewVulnerabilityAssessmentBaselinesClient(subscriptionID string) VulnerabilityAssessmentBaselinesClient {
	return NewVulnerabilityAssessmentBaselinesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewVulnerabilityAssessmentBaselinesClientWithBaseURI creates an instance of the
// VulnerabilityAssessmentBaselinesClient client using a custom endpoint.  Use this when interacting with an Azure
// cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewVulnerabilityAssessmentBaselinesClientWithBaseURI(baseURI string, subscriptionID string) VulnerabilityAssessmentBaselinesClient {
	return VulnerabilityAssessmentBaselinesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdate add a database's vulnerability assessment rule baseline list.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// serverName - the name of the server.
// parameters - the requested rule baseline resource.
func (client VulnerabilityAssessmentBaselinesClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, parameters DatabaseSQLVulnerabilityAssessmentRuleBaselineListInput) (result DatabaseSQLVulnerabilityAssessmentBaselineSet, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VulnerabilityAssessmentBaselinesClient.CreateOrUpdate")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.DatabaseSQLVulnerabilityAssessmentRuleBaselineListInputProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "parameters.DatabaseSQLVulnerabilityAssessmentRuleBaselineListInputProperties.LatestScan", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "parameters.DatabaseSQLVulnerabilityAssessmentRuleBaselineListInputProperties.Results", Name: validation.Null, Rule: true, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("sql.VulnerabilityAssessmentBaselinesClient", "CreateOrUpdate", err.Error())
	}

	req, err := client.CreateOrUpdatePreparer(ctx, resourceGroupName, serverName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.VulnerabilityAssessmentBaselinesClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.VulnerabilityAssessmentBaselinesClient", "CreateOrUpdate", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.VulnerabilityAssessmentBaselinesClient", "CreateOrUpdate", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client VulnerabilityAssessmentBaselinesClient) CreateOrUpdatePreparer(ctx context.Context, resourceGroupName string, serverName string, parameters DatabaseSQLVulnerabilityAssessmentRuleBaselineListInput) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"baselineName":                autorest.Encode("path", "default"),
		"resourceGroupName":           autorest.Encode("path", resourceGroupName),
		"serverName":                  autorest.Encode("path", serverName),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
		"vulnerabilityAssessmentName": autorest.Encode("path", "default"),
	}

	const APIVersion = "2022-02-01-preview"
	queryParameters := map[string]interface{}{
		"api-version":        APIVersion,
		"systemDatabaseName": autorest.Encode("query", "master"),
	}

	parameters.SystemData = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client VulnerabilityAssessmentBaselinesClient) CreateOrUpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client VulnerabilityAssessmentBaselinesClient) CreateOrUpdateResponder(resp *http.Response) (result DatabaseSQLVulnerabilityAssessmentBaselineSet, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
