package policyinsights

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// PolicyMetadataClient is the client for the PolicyMetadata methods of the Policyinsights service.
type PolicyMetadataClient struct {
	BaseClient
}

// NewPolicyMetadataClient creates an instance of the PolicyMetadataClient client.
func NewPolicyMetadataClient() PolicyMetadataClient {
	return NewPolicyMetadataClientWithBaseURI(DefaultBaseURI)
}

// NewPolicyMetadataClientWithBaseURI creates an instance of the PolicyMetadataClient client using a custom endpoint.
// Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewPolicyMetadataClientWithBaseURI(baseURI string) PolicyMetadataClient {
	return PolicyMetadataClient{NewWithBaseURI(baseURI)}
}

// GetResource get policy metadata resource.
// Parameters:
// resourceName - the name of the policy metadata resource.
func (client PolicyMetadataClient) GetResource(ctx context.Context, resourceName string) (result PolicyMetadata, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyMetadataClient.GetResource")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetResourcePreparer(ctx, resourceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyMetadataClient", "GetResource", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetResourceSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyMetadataClient", "GetResource", resp, "Failure sending request")
		return
	}

	result, err = client.GetResourceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyMetadataClient", "GetResource", resp, "Failure responding to request")
		return
	}

	return
}

// GetResourcePreparer prepares the GetResource request.
func (client PolicyMetadataClient) GetResourcePreparer(ctx context.Context, resourceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceName": resourceName,
	}

	const APIVersion = "2019-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.PolicyInsights/policyMetadata/{resourceName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetResourceSender sends the GetResource request. The method will close the
// http.Response Body if it receives an error.
func (client PolicyMetadataClient) GetResourceSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetResourceResponder handles the response to the GetResource request. The method always
// closes the http.Response Body.
func (client PolicyMetadataClient) GetResourceResponder(resp *http.Response) (result PolicyMetadata, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List get a list of the policy metadata resources.
// Parameters:
// top - maximum number of records to return.
func (client PolicyMetadataClient) List(ctx context.Context, top *int32) (result PolicyMetadataCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyMetadataClient.List")
		defer func() {
			sc := -1
			if result.pmc.Response.Response != nil {
				sc = result.pmc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: top,
			Constraints: []validation.Constraint{{Target: "top", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "top", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("policyinsights.PolicyMetadataClient", "List", err.Error())
	}

	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, top)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyMetadataClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.pmc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyMetadataClient", "List", resp, "Failure sending request")
		return
	}

	result.pmc, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyMetadataClient", "List", resp, "Failure responding to request")
		return
	}
	if result.pmc.hasNextLink() && result.pmc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client PolicyMetadataClient) ListPreparer(ctx context.Context, top *int32) (*http.Request, error) {
	const APIVersion = "2019-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/providers/Microsoft.PolicyInsights/policyMetadata"),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client PolicyMetadataClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client PolicyMetadataClient) ListResponder(resp *http.Response) (result PolicyMetadataCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client PolicyMetadataClient) listNextResults(ctx context.Context, lastResults PolicyMetadataCollection) (result PolicyMetadataCollection, err error) {
	req, err := lastResults.policyMetadataCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "policyinsights.PolicyMetadataClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "policyinsights.PolicyMetadataClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyMetadataClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client PolicyMetadataClient) ListComplete(ctx context.Context, top *int32) (result PolicyMetadataCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyMetadataClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx, top)
	return
}
