package devices

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AccessRights enumerates the values for access rights.
type AccessRights string

const (
	// AccessRightsDeviceConnect ...
	AccessRightsDeviceConnect AccessRights = "DeviceConnect"
	// AccessRightsRegistryRead ...
	AccessRightsRegistryRead AccessRights = "RegistryRead"
	// AccessRightsRegistryReadDeviceConnect ...
	AccessRightsRegistryReadDeviceConnect AccessRights = "RegistryRead, DeviceConnect"
	// AccessRightsRegistryReadRegistryWrite ...
	AccessRightsRegistryReadRegistryWrite AccessRights = "RegistryRead, RegistryWrite"
	// AccessRightsRegistryReadRegistryWriteDeviceConnect ...
	AccessRightsRegistryReadRegistryWriteDeviceConnect AccessRights = "RegistryRead, RegistryWrite, DeviceConnect"
	// AccessRightsRegistryReadRegistryWriteServiceConnect ...
	AccessRightsRegistryReadRegistryWriteServiceConnect AccessRights = "RegistryRead, RegistryWrite, ServiceConnect"
	// AccessRightsRegistryReadRegistryWriteServiceConnectDeviceConnect ...
	AccessRightsRegistryReadRegistryWriteServiceConnectDeviceConnect AccessRights = "RegistryRead, RegistryWrite, ServiceConnect, DeviceConnect"
	// AccessRightsRegistryReadServiceConnect ...
	AccessRightsRegistryReadServiceConnect AccessRights = "RegistryRead, ServiceConnect"
	// AccessRightsRegistryReadServiceConnectDeviceConnect ...
	AccessRightsRegistryReadServiceConnectDeviceConnect AccessRights = "RegistryRead, ServiceConnect, DeviceConnect"
	// AccessRightsRegistryWrite ...
	AccessRightsRegistryWrite AccessRights = "RegistryWrite"
	// AccessRightsRegistryWriteDeviceConnect ...
	AccessRightsRegistryWriteDeviceConnect AccessRights = "RegistryWrite, DeviceConnect"
	// AccessRightsRegistryWriteServiceConnect ...
	AccessRightsRegistryWriteServiceConnect AccessRights = "RegistryWrite, ServiceConnect"
	// AccessRightsRegistryWriteServiceConnectDeviceConnect ...
	AccessRightsRegistryWriteServiceConnectDeviceConnect AccessRights = "RegistryWrite, ServiceConnect, DeviceConnect"
	// AccessRightsServiceConnect ...
	AccessRightsServiceConnect AccessRights = "ServiceConnect"
	// AccessRightsServiceConnectDeviceConnect ...
	AccessRightsServiceConnectDeviceConnect AccessRights = "ServiceConnect, DeviceConnect"
)

// PossibleAccessRightsValues returns an array of possible values for the AccessRights const type.
func PossibleAccessRightsValues() []AccessRights {
	return []AccessRights{AccessRightsDeviceConnect, AccessRightsRegistryRead, AccessRightsRegistryReadDeviceConnect, AccessRightsRegistryReadRegistryWrite, AccessRightsRegistryReadRegistryWriteDeviceConnect, AccessRightsRegistryReadRegistryWriteServiceConnect, AccessRightsRegistryReadRegistryWriteServiceConnectDeviceConnect, AccessRightsRegistryReadServiceConnect, AccessRightsRegistryReadServiceConnectDeviceConnect, AccessRightsRegistryWrite, AccessRightsRegistryWriteDeviceConnect, AccessRightsRegistryWriteServiceConnect, AccessRightsRegistryWriteServiceConnectDeviceConnect, AccessRightsServiceConnect, AccessRightsServiceConnectDeviceConnect}
}

// AuthenticationType enumerates the values for authentication type.
type AuthenticationType string

const (
	// AuthenticationTypeIdentityBased ...
	AuthenticationTypeIdentityBased AuthenticationType = "identityBased"
	// AuthenticationTypeKeyBased ...
	AuthenticationTypeKeyBased AuthenticationType = "keyBased"
)

// PossibleAuthenticationTypeValues returns an array of possible values for the AuthenticationType const type.
func PossibleAuthenticationTypeValues() []AuthenticationType {
	return []AuthenticationType{AuthenticationTypeIdentityBased, AuthenticationTypeKeyBased}
}

// Capabilities enumerates the values for capabilities.
type Capabilities string

const (
	// CapabilitiesDeviceManagement ...
	CapabilitiesDeviceManagement Capabilities = "DeviceManagement"
	// CapabilitiesNone ...
	CapabilitiesNone Capabilities = "None"
)

// PossibleCapabilitiesValues returns an array of possible values for the Capabilities const type.
func PossibleCapabilitiesValues() []Capabilities {
	return []Capabilities{CapabilitiesDeviceManagement, CapabilitiesNone}
}

// DefaultAction enumerates the values for default action.
type DefaultAction string

const (
	// DefaultActionAllow ...
	DefaultActionAllow DefaultAction = "Allow"
	// DefaultActionDeny ...
	DefaultActionDeny DefaultAction = "Deny"
)

// PossibleDefaultActionValues returns an array of possible values for the DefaultAction const type.
func PossibleDefaultActionValues() []DefaultAction {
	return []DefaultAction{DefaultActionAllow, DefaultActionDeny}
}

// Encoding enumerates the values for encoding.
type Encoding string

const (
	// EncodingAvro ...
	EncodingAvro Encoding = "Avro"
	// EncodingAvroDeflate ...
	EncodingAvroDeflate Encoding = "AvroDeflate"
	// EncodingJSON ...
	EncodingJSON Encoding = "JSON"
)

// PossibleEncodingValues returns an array of possible values for the Encoding const type.
func PossibleEncodingValues() []Encoding {
	return []Encoding{EncodingAvro, EncodingAvroDeflate, EncodingJSON}
}

// EndpointHealthStatus enumerates the values for endpoint health status.
type EndpointHealthStatus string

const (
	// EndpointHealthStatusDead ...
	EndpointHealthStatusDead EndpointHealthStatus = "dead"
	// EndpointHealthStatusDegraded ...
	EndpointHealthStatusDegraded EndpointHealthStatus = "degraded"
	// EndpointHealthStatusHealthy ...
	EndpointHealthStatusHealthy EndpointHealthStatus = "healthy"
	// EndpointHealthStatusUnhealthy ...
	EndpointHealthStatusUnhealthy EndpointHealthStatus = "unhealthy"
	// EndpointHealthStatusUnknown ...
	EndpointHealthStatusUnknown EndpointHealthStatus = "unknown"
)

// PossibleEndpointHealthStatusValues returns an array of possible values for the EndpointHealthStatus const type.
func PossibleEndpointHealthStatusValues() []EndpointHealthStatus {
	return []EndpointHealthStatus{EndpointHealthStatusDead, EndpointHealthStatusDegraded, EndpointHealthStatusHealthy, EndpointHealthStatusUnhealthy, EndpointHealthStatusUnknown}
}

// IotHubNameUnavailabilityReason enumerates the values for iot hub name unavailability reason.
type IotHubNameUnavailabilityReason string

const (
	// IotHubNameUnavailabilityReasonAlreadyExists ...
	IotHubNameUnavailabilityReasonAlreadyExists IotHubNameUnavailabilityReason = "AlreadyExists"
	// IotHubNameUnavailabilityReasonInvalid ...
	IotHubNameUnavailabilityReasonInvalid IotHubNameUnavailabilityReason = "Invalid"
)

// PossibleIotHubNameUnavailabilityReasonValues returns an array of possible values for the IotHubNameUnavailabilityReason const type.
func PossibleIotHubNameUnavailabilityReasonValues() []IotHubNameUnavailabilityReason {
	return []IotHubNameUnavailabilityReason{IotHubNameUnavailabilityReasonAlreadyExists, IotHubNameUnavailabilityReasonInvalid}
}

// IotHubReplicaRoleType enumerates the values for iot hub replica role type.
type IotHubReplicaRoleType string

const (
	// IotHubReplicaRoleTypePrimary ...
	IotHubReplicaRoleTypePrimary IotHubReplicaRoleType = "primary"
	// IotHubReplicaRoleTypeSecondary ...
	IotHubReplicaRoleTypeSecondary IotHubReplicaRoleType = "secondary"
)

// PossibleIotHubReplicaRoleTypeValues returns an array of possible values for the IotHubReplicaRoleType const type.
func PossibleIotHubReplicaRoleTypeValues() []IotHubReplicaRoleType {
	return []IotHubReplicaRoleType{IotHubReplicaRoleTypePrimary, IotHubReplicaRoleTypeSecondary}
}

// IotHubScaleType enumerates the values for iot hub scale type.
type IotHubScaleType string

const (
	// IotHubScaleTypeAutomatic ...
	IotHubScaleTypeAutomatic IotHubScaleType = "Automatic"
	// IotHubScaleTypeManual ...
	IotHubScaleTypeManual IotHubScaleType = "Manual"
	// IotHubScaleTypeNone ...
	IotHubScaleTypeNone IotHubScaleType = "None"
)

// PossibleIotHubScaleTypeValues returns an array of possible values for the IotHubScaleType const type.
func PossibleIotHubScaleTypeValues() []IotHubScaleType {
	return []IotHubScaleType{IotHubScaleTypeAutomatic, IotHubScaleTypeManual, IotHubScaleTypeNone}
}

// IotHubSku enumerates the values for iot hub sku.
type IotHubSku string

const (
	// IotHubSkuB1 ...
	IotHubSkuB1 IotHubSku = "B1"
	// IotHubSkuB2 ...
	IotHubSkuB2 IotHubSku = "B2"
	// IotHubSkuB3 ...
	IotHubSkuB3 IotHubSku = "B3"
	// IotHubSkuF1 ...
	IotHubSkuF1 IotHubSku = "F1"
	// IotHubSkuS1 ...
	IotHubSkuS1 IotHubSku = "S1"
	// IotHubSkuS2 ...
	IotHubSkuS2 IotHubSku = "S2"
	// IotHubSkuS3 ...
	IotHubSkuS3 IotHubSku = "S3"
)

// PossibleIotHubSkuValues returns an array of possible values for the IotHubSku const type.
func PossibleIotHubSkuValues() []IotHubSku {
	return []IotHubSku{IotHubSkuB1, IotHubSkuB2, IotHubSkuB3, IotHubSkuF1, IotHubSkuS1, IotHubSkuS2, IotHubSkuS3}
}

// IotHubSkuTier enumerates the values for iot hub sku tier.
type IotHubSkuTier string

const (
	// IotHubSkuTierBasic ...
	IotHubSkuTierBasic IotHubSkuTier = "Basic"
	// IotHubSkuTierFree ...
	IotHubSkuTierFree IotHubSkuTier = "Free"
	// IotHubSkuTierStandard ...
	IotHubSkuTierStandard IotHubSkuTier = "Standard"
)

// PossibleIotHubSkuTierValues returns an array of possible values for the IotHubSkuTier const type.
func PossibleIotHubSkuTierValues() []IotHubSkuTier {
	return []IotHubSkuTier{IotHubSkuTierBasic, IotHubSkuTierFree, IotHubSkuTierStandard}
}

// IPFilterActionType enumerates the values for ip filter action type.
type IPFilterActionType string

const (
	// IPFilterActionTypeAccept ...
	IPFilterActionTypeAccept IPFilterActionType = "Accept"
	// IPFilterActionTypeReject ...
	IPFilterActionTypeReject IPFilterActionType = "Reject"
)

// PossibleIPFilterActionTypeValues returns an array of possible values for the IPFilterActionType const type.
func PossibleIPFilterActionTypeValues() []IPFilterActionType {
	return []IPFilterActionType{IPFilterActionTypeAccept, IPFilterActionTypeReject}
}

// JobStatus enumerates the values for job status.
type JobStatus string

const (
	// JobStatusCancelled ...
	JobStatusCancelled JobStatus = "cancelled"
	// JobStatusCompleted ...
	JobStatusCompleted JobStatus = "completed"
	// JobStatusEnqueued ...
	JobStatusEnqueued JobStatus = "enqueued"
	// JobStatusFailed ...
	JobStatusFailed JobStatus = "failed"
	// JobStatusRunning ...
	JobStatusRunning JobStatus = "running"
	// JobStatusUnknown ...
	JobStatusUnknown JobStatus = "unknown"
)

// PossibleJobStatusValues returns an array of possible values for the JobStatus const type.
func PossibleJobStatusValues() []JobStatus {
	return []JobStatus{JobStatusCancelled, JobStatusCompleted, JobStatusEnqueued, JobStatusFailed, JobStatusRunning, JobStatusUnknown}
}

// JobType enumerates the values for job type.
type JobType string

const (
	// JobTypeBackup ...
	JobTypeBackup JobType = "backup"
	// JobTypeExport ...
	JobTypeExport JobType = "export"
	// JobTypeFactoryResetDevice ...
	JobTypeFactoryResetDevice JobType = "factoryResetDevice"
	// JobTypeFirmwareUpdate ...
	JobTypeFirmwareUpdate JobType = "firmwareUpdate"
	// JobTypeImport ...
	JobTypeImport JobType = "import"
	// JobTypeReadDeviceProperties ...
	JobTypeReadDeviceProperties JobType = "readDeviceProperties"
	// JobTypeRebootDevice ...
	JobTypeRebootDevice JobType = "rebootDevice"
	// JobTypeUnknown ...
	JobTypeUnknown JobType = "unknown"
	// JobTypeUpdateDeviceConfiguration ...
	JobTypeUpdateDeviceConfiguration JobType = "updateDeviceConfiguration"
	// JobTypeWriteDeviceProperties ...
	JobTypeWriteDeviceProperties JobType = "writeDeviceProperties"
)

// PossibleJobTypeValues returns an array of possible values for the JobType const type.
func PossibleJobTypeValues() []JobType {
	return []JobType{JobTypeBackup, JobTypeExport, JobTypeFactoryResetDevice, JobTypeFirmwareUpdate, JobTypeImport, JobTypeReadDeviceProperties, JobTypeRebootDevice, JobTypeUnknown, JobTypeUpdateDeviceConfiguration, JobTypeWriteDeviceProperties}
}

// NetworkRuleIPAction enumerates the values for network rule ip action.
type NetworkRuleIPAction string

const (
	// NetworkRuleIPActionAllow ...
	NetworkRuleIPActionAllow NetworkRuleIPAction = "Allow"
)

// PossibleNetworkRuleIPActionValues returns an array of possible values for the NetworkRuleIPAction const type.
func PossibleNetworkRuleIPActionValues() []NetworkRuleIPAction {
	return []NetworkRuleIPAction{NetworkRuleIPActionAllow}
}

// PrivateLinkServiceConnectionStatus enumerates the values for private link service connection status.
type PrivateLinkServiceConnectionStatus string

const (
	// PrivateLinkServiceConnectionStatusApproved ...
	PrivateLinkServiceConnectionStatusApproved PrivateLinkServiceConnectionStatus = "Approved"
	// PrivateLinkServiceConnectionStatusDisconnected ...
	PrivateLinkServiceConnectionStatusDisconnected PrivateLinkServiceConnectionStatus = "Disconnected"
	// PrivateLinkServiceConnectionStatusPending ...
	PrivateLinkServiceConnectionStatusPending PrivateLinkServiceConnectionStatus = "Pending"
	// PrivateLinkServiceConnectionStatusRejected ...
	PrivateLinkServiceConnectionStatusRejected PrivateLinkServiceConnectionStatus = "Rejected"
)

// PossiblePrivateLinkServiceConnectionStatusValues returns an array of possible values for the PrivateLinkServiceConnectionStatus const type.
func PossiblePrivateLinkServiceConnectionStatusValues() []PrivateLinkServiceConnectionStatus {
	return []PrivateLinkServiceConnectionStatus{PrivateLinkServiceConnectionStatusApproved, PrivateLinkServiceConnectionStatusDisconnected, PrivateLinkServiceConnectionStatusPending, PrivateLinkServiceConnectionStatusRejected}
}

// PublicNetworkAccess enumerates the values for public network access.
type PublicNetworkAccess string

const (
	// PublicNetworkAccessDisabled ...
	PublicNetworkAccessDisabled PublicNetworkAccess = "Disabled"
	// PublicNetworkAccessEnabled ...
	PublicNetworkAccessEnabled PublicNetworkAccess = "Enabled"
)

// PossiblePublicNetworkAccessValues returns an array of possible values for the PublicNetworkAccess const type.
func PossiblePublicNetworkAccessValues() []PublicNetworkAccess {
	return []PublicNetworkAccess{PublicNetworkAccessDisabled, PublicNetworkAccessEnabled}
}

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// ResourceIdentityTypeNone ...
	ResourceIdentityTypeNone ResourceIdentityType = "None"
	// ResourceIdentityTypeSystemAssigned ...
	ResourceIdentityTypeSystemAssigned ResourceIdentityType = "SystemAssigned"
	// ResourceIdentityTypeSystemAssignedUserAssigned ...
	ResourceIdentityTypeSystemAssignedUserAssigned ResourceIdentityType = "SystemAssigned, UserAssigned"
	// ResourceIdentityTypeUserAssigned ...
	ResourceIdentityTypeUserAssigned ResourceIdentityType = "UserAssigned"
)

// PossibleResourceIdentityTypeValues returns an array of possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{ResourceIdentityTypeNone, ResourceIdentityTypeSystemAssigned, ResourceIdentityTypeSystemAssignedUserAssigned, ResourceIdentityTypeUserAssigned}
}

// RouteErrorSeverity enumerates the values for route error severity.
type RouteErrorSeverity string

const (
	// RouteErrorSeverityError ...
	RouteErrorSeverityError RouteErrorSeverity = "error"
	// RouteErrorSeverityWarning ...
	RouteErrorSeverityWarning RouteErrorSeverity = "warning"
)

// PossibleRouteErrorSeverityValues returns an array of possible values for the RouteErrorSeverity const type.
func PossibleRouteErrorSeverityValues() []RouteErrorSeverity {
	return []RouteErrorSeverity{RouteErrorSeverityError, RouteErrorSeverityWarning}
}

// RoutingSource enumerates the values for routing source.
type RoutingSource string

const (
	// RoutingSourceDeviceConnectionStateEvents ...
	RoutingSourceDeviceConnectionStateEvents RoutingSource = "DeviceConnectionStateEvents"
	// RoutingSourceDeviceJobLifecycleEvents ...
	RoutingSourceDeviceJobLifecycleEvents RoutingSource = "DeviceJobLifecycleEvents"
	// RoutingSourceDeviceLifecycleEvents ...
	RoutingSourceDeviceLifecycleEvents RoutingSource = "DeviceLifecycleEvents"
	// RoutingSourceDeviceMessages ...
	RoutingSourceDeviceMessages RoutingSource = "DeviceMessages"
	// RoutingSourceInvalid ...
	RoutingSourceInvalid RoutingSource = "Invalid"
	// RoutingSourceTwinChangeEvents ...
	RoutingSourceTwinChangeEvents RoutingSource = "TwinChangeEvents"
)

// PossibleRoutingSourceValues returns an array of possible values for the RoutingSource const type.
func PossibleRoutingSourceValues() []RoutingSource {
	return []RoutingSource{RoutingSourceDeviceConnectionStateEvents, RoutingSourceDeviceJobLifecycleEvents, RoutingSourceDeviceLifecycleEvents, RoutingSourceDeviceMessages, RoutingSourceInvalid, RoutingSourceTwinChangeEvents}
}

// TestResultStatus enumerates the values for test result status.
type TestResultStatus string

const (
	// TestResultStatusFalse ...
	TestResultStatusFalse TestResultStatus = "false"
	// TestResultStatusTrue ...
	TestResultStatusTrue TestResultStatus = "true"
	// TestResultStatusUndefined ...
	TestResultStatusUndefined TestResultStatus = "undefined"
)

// PossibleTestResultStatusValues returns an array of possible values for the TestResultStatus const type.
func PossibleTestResultStatusValues() []TestResultStatus {
	return []TestResultStatus{TestResultStatusFalse, TestResultStatusTrue, TestResultStatusUndefined}
}
