package predictionapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/cognitiveservices/v1.1/customvision/prediction"
	"github.com/gofrs/uuid"
	"io"
)

// BaseClientAPI contains the set of methods on the BaseClient type.
type BaseClientAPI interface {
	PredictImage(ctx context.Context, projectID uuid.UUID, imageData io.ReadCloser, iterationID *uuid.UUID, application string) (result prediction.ImagePrediction, err error)
	PredictImageURL(ctx context.Context, projectID uuid.UUID, imageURL prediction.ImageURL, iterationID *uuid.UUID, application string) (result prediction.ImagePrediction, err error)
	PredictImageURLWithNoStore(ctx context.Context, projectID uuid.UUID, imageURL prediction.ImageURL, iterationID *uuid.UUID, application string) (result prediction.ImagePrediction, err error)
	PredictImageWithNoStore(ctx context.Context, projectID uuid.UUID, imageData io.ReadCloser, iterationID *uuid.UUID, application string) (result prediction.ImagePrediction, err error)
}

var _ BaseClientAPI = (*prediction.BaseClient)(nil)
