package cdn

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ActionType enumerates the values for action type.
type ActionType string

const (
	// ActionTypeAllow ...
	ActionTypeAllow ActionType = "Allow"
	// ActionTypeBlock ...
	ActionTypeBlock ActionType = "Block"
	// ActionTypeLog ...
	ActionTypeLog ActionType = "Log"
	// ActionTypeRedirect ...
	ActionTypeRedirect ActionType = "Redirect"
)

// PossibleActionTypeValues returns an array of possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{ActionTypeAllow, ActionTypeBlock, ActionTypeLog, ActionTypeRedirect}
}

// AfdCertificateType enumerates the values for afd certificate type.
type AfdCertificateType string

const (
	// AfdCertificateTypeCustomerCertificate ...
	AfdCertificateTypeCustomerCertificate AfdCertificateType = "CustomerCertificate"
	// AfdCertificateTypeManagedCertificate ...
	AfdCertificateTypeManagedCertificate AfdCertificateType = "ManagedCertificate"
)

// PossibleAfdCertificateTypeValues returns an array of possible values for the AfdCertificateType const type.
func PossibleAfdCertificateTypeValues() []AfdCertificateType {
	return []AfdCertificateType{AfdCertificateTypeCustomerCertificate, AfdCertificateTypeManagedCertificate}
}

// AFDEndpointProtocols enumerates the values for afd endpoint protocols.
type AFDEndpointProtocols string

const (
	// AFDEndpointProtocolsHTTP ...
	AFDEndpointProtocolsHTTP AFDEndpointProtocols = "Http"
	// AFDEndpointProtocolsHTTPS ...
	AFDEndpointProtocolsHTTPS AFDEndpointProtocols = "Https"
)

// PossibleAFDEndpointProtocolsValues returns an array of possible values for the AFDEndpointProtocols const type.
func PossibleAFDEndpointProtocolsValues() []AFDEndpointProtocols {
	return []AFDEndpointProtocols{AFDEndpointProtocolsHTTP, AFDEndpointProtocolsHTTPS}
}

// AfdMinimumTLSVersion enumerates the values for afd minimum tls version.
type AfdMinimumTLSVersion string

const (
	// AfdMinimumTLSVersionTLS10 ...
	AfdMinimumTLSVersionTLS10 AfdMinimumTLSVersion = "TLS10"
	// AfdMinimumTLSVersionTLS12 ...
	AfdMinimumTLSVersionTLS12 AfdMinimumTLSVersion = "TLS12"
)

// PossibleAfdMinimumTLSVersionValues returns an array of possible values for the AfdMinimumTLSVersion const type.
func PossibleAfdMinimumTLSVersionValues() []AfdMinimumTLSVersion {
	return []AfdMinimumTLSVersion{AfdMinimumTLSVersionTLS10, AfdMinimumTLSVersionTLS12}
}

// AfdProvisioningState enumerates the values for afd provisioning state.
type AfdProvisioningState string

const (
	// AfdProvisioningStateCreating ...
	AfdProvisioningStateCreating AfdProvisioningState = "Creating"
	// AfdProvisioningStateDeleting ...
	AfdProvisioningStateDeleting AfdProvisioningState = "Deleting"
	// AfdProvisioningStateFailed ...
	AfdProvisioningStateFailed AfdProvisioningState = "Failed"
	// AfdProvisioningStateSucceeded ...
	AfdProvisioningStateSucceeded AfdProvisioningState = "Succeeded"
	// AfdProvisioningStateUpdating ...
	AfdProvisioningStateUpdating AfdProvisioningState = "Updating"
)

// PossibleAfdProvisioningStateValues returns an array of possible values for the AfdProvisioningState const type.
func PossibleAfdProvisioningStateValues() []AfdProvisioningState {
	return []AfdProvisioningState{AfdProvisioningStateCreating, AfdProvisioningStateDeleting, AfdProvisioningStateFailed, AfdProvisioningStateSucceeded, AfdProvisioningStateUpdating}
}

// AfdQueryStringCachingBehavior enumerates the values for afd query string caching behavior.
type AfdQueryStringCachingBehavior string

const (
	// AfdQueryStringCachingBehaviorIgnoreQueryString ...
	AfdQueryStringCachingBehaviorIgnoreQueryString AfdQueryStringCachingBehavior = "IgnoreQueryString"
	// AfdQueryStringCachingBehaviorNotSet ...
	AfdQueryStringCachingBehaviorNotSet AfdQueryStringCachingBehavior = "NotSet"
	// AfdQueryStringCachingBehaviorUseQueryString ...
	AfdQueryStringCachingBehaviorUseQueryString AfdQueryStringCachingBehavior = "UseQueryString"
)

// PossibleAfdQueryStringCachingBehaviorValues returns an array of possible values for the AfdQueryStringCachingBehavior const type.
func PossibleAfdQueryStringCachingBehaviorValues() []AfdQueryStringCachingBehavior {
	return []AfdQueryStringCachingBehavior{AfdQueryStringCachingBehaviorIgnoreQueryString, AfdQueryStringCachingBehaviorNotSet, AfdQueryStringCachingBehaviorUseQueryString}
}

// Algorithm enumerates the values for algorithm.
type Algorithm string

const (
	// AlgorithmSHA256 ...
	AlgorithmSHA256 Algorithm = "SHA256"
)

// PossibleAlgorithmValues returns an array of possible values for the Algorithm const type.
func PossibleAlgorithmValues() []Algorithm {
	return []Algorithm{AlgorithmSHA256}
}

// CacheBehavior enumerates the values for cache behavior.
type CacheBehavior string

const (
	// CacheBehaviorBypassCache ...
	CacheBehaviorBypassCache CacheBehavior = "BypassCache"
	// CacheBehaviorOverride ...
	CacheBehaviorOverride CacheBehavior = "Override"
	// CacheBehaviorSetIfMissing ...
	CacheBehaviorSetIfMissing CacheBehavior = "SetIfMissing"
)

// PossibleCacheBehaviorValues returns an array of possible values for the CacheBehavior const type.
func PossibleCacheBehaviorValues() []CacheBehavior {
	return []CacheBehavior{CacheBehaviorBypassCache, CacheBehaviorOverride, CacheBehaviorSetIfMissing}
}

// CertificateSource enumerates the values for certificate source.
type CertificateSource string

const (
	// CertificateSourceAzureKeyVault ...
	CertificateSourceAzureKeyVault CertificateSource = "AzureKeyVault"
	// CertificateSourceCdn ...
	CertificateSourceCdn CertificateSource = "Cdn"
	// CertificateSourceCustomDomainHTTPSParameters ...
	CertificateSourceCustomDomainHTTPSParameters CertificateSource = "CustomDomainHttpsParameters"
)

// PossibleCertificateSourceValues returns an array of possible values for the CertificateSource const type.
func PossibleCertificateSourceValues() []CertificateSource {
	return []CertificateSource{CertificateSourceAzureKeyVault, CertificateSourceCdn, CertificateSourceCustomDomainHTTPSParameters}
}

// CertificateType enumerates the values for certificate type.
type CertificateType string

const (
	// CertificateTypeDedicated ...
	CertificateTypeDedicated CertificateType = "Dedicated"
	// CertificateTypeShared ...
	CertificateTypeShared CertificateType = "Shared"
)

// PossibleCertificateTypeValues returns an array of possible values for the CertificateType const type.
func PossibleCertificateTypeValues() []CertificateType {
	return []CertificateType{CertificateTypeDedicated, CertificateTypeShared}
}

// CookiesOperator enumerates the values for cookies operator.
type CookiesOperator string

const (
	// CookiesOperatorAny ...
	CookiesOperatorAny CookiesOperator = "Any"
	// CookiesOperatorBeginsWith ...
	CookiesOperatorBeginsWith CookiesOperator = "BeginsWith"
	// CookiesOperatorContains ...
	CookiesOperatorContains CookiesOperator = "Contains"
	// CookiesOperatorEndsWith ...
	CookiesOperatorEndsWith CookiesOperator = "EndsWith"
	// CookiesOperatorEqual ...
	CookiesOperatorEqual CookiesOperator = "Equal"
	// CookiesOperatorGreaterThan ...
	CookiesOperatorGreaterThan CookiesOperator = "GreaterThan"
	// CookiesOperatorGreaterThanOrEqual ...
	CookiesOperatorGreaterThanOrEqual CookiesOperator = "GreaterThanOrEqual"
	// CookiesOperatorLessThan ...
	CookiesOperatorLessThan CookiesOperator = "LessThan"
	// CookiesOperatorLessThanOrEqual ...
	CookiesOperatorLessThanOrEqual CookiesOperator = "LessThanOrEqual"
	// CookiesOperatorRegEx ...
	CookiesOperatorRegEx CookiesOperator = "RegEx"
)

// PossibleCookiesOperatorValues returns an array of possible values for the CookiesOperator const type.
func PossibleCookiesOperatorValues() []CookiesOperator {
	return []CookiesOperator{CookiesOperatorAny, CookiesOperatorBeginsWith, CookiesOperatorContains, CookiesOperatorEndsWith, CookiesOperatorEqual, CookiesOperatorGreaterThan, CookiesOperatorGreaterThanOrEqual, CookiesOperatorLessThan, CookiesOperatorLessThanOrEqual, CookiesOperatorRegEx}
}

// CustomDomainResourceState enumerates the values for custom domain resource state.
type CustomDomainResourceState string

const (
	// CustomDomainResourceStateActive ...
	CustomDomainResourceStateActive CustomDomainResourceState = "Active"
	// CustomDomainResourceStateCreating ...
	CustomDomainResourceStateCreating CustomDomainResourceState = "Creating"
	// CustomDomainResourceStateDeleting ...
	CustomDomainResourceStateDeleting CustomDomainResourceState = "Deleting"
)

// PossibleCustomDomainResourceStateValues returns an array of possible values for the CustomDomainResourceState const type.
func PossibleCustomDomainResourceStateValues() []CustomDomainResourceState {
	return []CustomDomainResourceState{CustomDomainResourceStateActive, CustomDomainResourceStateCreating, CustomDomainResourceStateDeleting}
}

// CustomHTTPSProvisioningState enumerates the values for custom https provisioning state.
type CustomHTTPSProvisioningState string

const (
	// CustomHTTPSProvisioningStateDisabled ...
	CustomHTTPSProvisioningStateDisabled CustomHTTPSProvisioningState = "Disabled"
	// CustomHTTPSProvisioningStateDisabling ...
	CustomHTTPSProvisioningStateDisabling CustomHTTPSProvisioningState = "Disabling"
	// CustomHTTPSProvisioningStateEnabled ...
	CustomHTTPSProvisioningStateEnabled CustomHTTPSProvisioningState = "Enabled"
	// CustomHTTPSProvisioningStateEnabling ...
	CustomHTTPSProvisioningStateEnabling CustomHTTPSProvisioningState = "Enabling"
	// CustomHTTPSProvisioningStateFailed ...
	CustomHTTPSProvisioningStateFailed CustomHTTPSProvisioningState = "Failed"
)

// PossibleCustomHTTPSProvisioningStateValues returns an array of possible values for the CustomHTTPSProvisioningState const type.
func PossibleCustomHTTPSProvisioningStateValues() []CustomHTTPSProvisioningState {
	return []CustomHTTPSProvisioningState{CustomHTTPSProvisioningStateDisabled, CustomHTTPSProvisioningStateDisabling, CustomHTTPSProvisioningStateEnabled, CustomHTTPSProvisioningStateEnabling, CustomHTTPSProvisioningStateFailed}
}

// CustomHTTPSProvisioningSubstate enumerates the values for custom https provisioning substate.
type CustomHTTPSProvisioningSubstate string

const (
	// CustomHTTPSProvisioningSubstateCertificateDeleted ...
	CustomHTTPSProvisioningSubstateCertificateDeleted CustomHTTPSProvisioningSubstate = "CertificateDeleted"
	// CustomHTTPSProvisioningSubstateCertificateDeployed ...
	CustomHTTPSProvisioningSubstateCertificateDeployed CustomHTTPSProvisioningSubstate = "CertificateDeployed"
	// CustomHTTPSProvisioningSubstateDeletingCertificate ...
	CustomHTTPSProvisioningSubstateDeletingCertificate CustomHTTPSProvisioningSubstate = "DeletingCertificate"
	// CustomHTTPSProvisioningSubstateDeployingCertificate ...
	CustomHTTPSProvisioningSubstateDeployingCertificate CustomHTTPSProvisioningSubstate = "DeployingCertificate"
	// CustomHTTPSProvisioningSubstateDomainControlValidationRequestApproved ...
	CustomHTTPSProvisioningSubstateDomainControlValidationRequestApproved CustomHTTPSProvisioningSubstate = "DomainControlValidationRequestApproved"
	// CustomHTTPSProvisioningSubstateDomainControlValidationRequestRejected ...
	CustomHTTPSProvisioningSubstateDomainControlValidationRequestRejected CustomHTTPSProvisioningSubstate = "DomainControlValidationRequestRejected"
	// CustomHTTPSProvisioningSubstateDomainControlValidationRequestTimedOut ...
	CustomHTTPSProvisioningSubstateDomainControlValidationRequestTimedOut CustomHTTPSProvisioningSubstate = "DomainControlValidationRequestTimedOut"
	// CustomHTTPSProvisioningSubstateIssuingCertificate ...
	CustomHTTPSProvisioningSubstateIssuingCertificate CustomHTTPSProvisioningSubstate = "IssuingCertificate"
	// CustomHTTPSProvisioningSubstatePendingDomainControlValidationREquestApproval ...
	CustomHTTPSProvisioningSubstatePendingDomainControlValidationREquestApproval CustomHTTPSProvisioningSubstate = "PendingDomainControlValidationREquestApproval"
	// CustomHTTPSProvisioningSubstateSubmittingDomainControlValidationRequest ...
	CustomHTTPSProvisioningSubstateSubmittingDomainControlValidationRequest CustomHTTPSProvisioningSubstate = "SubmittingDomainControlValidationRequest"
)

// PossibleCustomHTTPSProvisioningSubstateValues returns an array of possible values for the CustomHTTPSProvisioningSubstate const type.
func PossibleCustomHTTPSProvisioningSubstateValues() []CustomHTTPSProvisioningSubstate {
	return []CustomHTTPSProvisioningSubstate{CustomHTTPSProvisioningSubstateCertificateDeleted, CustomHTTPSProvisioningSubstateCertificateDeployed, CustomHTTPSProvisioningSubstateDeletingCertificate, CustomHTTPSProvisioningSubstateDeployingCertificate, CustomHTTPSProvisioningSubstateDomainControlValidationRequestApproved, CustomHTTPSProvisioningSubstateDomainControlValidationRequestRejected, CustomHTTPSProvisioningSubstateDomainControlValidationRequestTimedOut, CustomHTTPSProvisioningSubstateIssuingCertificate, CustomHTTPSProvisioningSubstatePendingDomainControlValidationREquestApproval, CustomHTTPSProvisioningSubstateSubmittingDomainControlValidationRequest}
}

// CustomRuleEnabledState enumerates the values for custom rule enabled state.
type CustomRuleEnabledState string

const (
	// CustomRuleEnabledStateDisabled ...
	CustomRuleEnabledStateDisabled CustomRuleEnabledState = "Disabled"
	// CustomRuleEnabledStateEnabled ...
	CustomRuleEnabledStateEnabled CustomRuleEnabledState = "Enabled"
)

// PossibleCustomRuleEnabledStateValues returns an array of possible values for the CustomRuleEnabledState const type.
func PossibleCustomRuleEnabledStateValues() []CustomRuleEnabledState {
	return []CustomRuleEnabledState{CustomRuleEnabledStateDisabled, CustomRuleEnabledStateEnabled}
}

// DeploymentStatus enumerates the values for deployment status.
type DeploymentStatus string

const (
	// DeploymentStatusFailed ...
	DeploymentStatusFailed DeploymentStatus = "Failed"
	// DeploymentStatusInProgress ...
	DeploymentStatusInProgress DeploymentStatus = "InProgress"
	// DeploymentStatusNotStarted ...
	DeploymentStatusNotStarted DeploymentStatus = "NotStarted"
	// DeploymentStatusSucceeded ...
	DeploymentStatusSucceeded DeploymentStatus = "Succeeded"
)

// PossibleDeploymentStatusValues returns an array of possible values for the DeploymentStatus const type.
func PossibleDeploymentStatusValues() []DeploymentStatus {
	return []DeploymentStatus{DeploymentStatusFailed, DeploymentStatusInProgress, DeploymentStatusNotStarted, DeploymentStatusSucceeded}
}

// DestinationProtocol enumerates the values for destination protocol.
type DestinationProtocol string

const (
	// DestinationProtocolHTTP ...
	DestinationProtocolHTTP DestinationProtocol = "Http"
	// DestinationProtocolHTTPS ...
	DestinationProtocolHTTPS DestinationProtocol = "Https"
	// DestinationProtocolMatchRequest ...
	DestinationProtocolMatchRequest DestinationProtocol = "MatchRequest"
)

// PossibleDestinationProtocolValues returns an array of possible values for the DestinationProtocol const type.
func PossibleDestinationProtocolValues() []DestinationProtocol {
	return []DestinationProtocol{DestinationProtocolHTTP, DestinationProtocolHTTPS, DestinationProtocolMatchRequest}
}

// DomainValidationState enumerates the values for domain validation state.
type DomainValidationState string

const (
	// DomainValidationStateApproved ...
	DomainValidationStateApproved DomainValidationState = "Approved"
	// DomainValidationStatePending ...
	DomainValidationStatePending DomainValidationState = "Pending"
	// DomainValidationStatePendingRevalidation ...
	DomainValidationStatePendingRevalidation DomainValidationState = "PendingRevalidation"
	// DomainValidationStateSubmitting ...
	DomainValidationStateSubmitting DomainValidationState = "Submitting"
	// DomainValidationStateTimedOut ...
	DomainValidationStateTimedOut DomainValidationState = "TimedOut"
	// DomainValidationStateUnknown ...
	DomainValidationStateUnknown DomainValidationState = "Unknown"
)

// PossibleDomainValidationStateValues returns an array of possible values for the DomainValidationState const type.
func PossibleDomainValidationStateValues() []DomainValidationState {
	return []DomainValidationState{DomainValidationStateApproved, DomainValidationStatePending, DomainValidationStatePendingRevalidation, DomainValidationStateSubmitting, DomainValidationStateTimedOut, DomainValidationStateUnknown}
}

// EnabledState enumerates the values for enabled state.
type EnabledState string

const (
	// EnabledStateDisabled ...
	EnabledStateDisabled EnabledState = "Disabled"
	// EnabledStateEnabled ...
	EnabledStateEnabled EnabledState = "Enabled"
)

// PossibleEnabledStateValues returns an array of possible values for the EnabledState const type.
func PossibleEnabledStateValues() []EnabledState {
	return []EnabledState{EnabledStateDisabled, EnabledStateEnabled}
}

// EndpointResourceState enumerates the values for endpoint resource state.
type EndpointResourceState string

const (
	// EndpointResourceStateCreating ...
	EndpointResourceStateCreating EndpointResourceState = "Creating"
	// EndpointResourceStateDeleting ...
	EndpointResourceStateDeleting EndpointResourceState = "Deleting"
	// EndpointResourceStateRunning ...
	EndpointResourceStateRunning EndpointResourceState = "Running"
	// EndpointResourceStateStarting ...
	EndpointResourceStateStarting EndpointResourceState = "Starting"
	// EndpointResourceStateStopped ...
	EndpointResourceStateStopped EndpointResourceState = "Stopped"
	// EndpointResourceStateStopping ...
	EndpointResourceStateStopping EndpointResourceState = "Stopping"
)

// PossibleEndpointResourceStateValues returns an array of possible values for the EndpointResourceState const type.
func PossibleEndpointResourceStateValues() []EndpointResourceState {
	return []EndpointResourceState{EndpointResourceStateCreating, EndpointResourceStateDeleting, EndpointResourceStateRunning, EndpointResourceStateStarting, EndpointResourceStateStopped, EndpointResourceStateStopping}
}

// ForwardingProtocol enumerates the values for forwarding protocol.
type ForwardingProtocol string

const (
	// ForwardingProtocolHTTPOnly ...
	ForwardingProtocolHTTPOnly ForwardingProtocol = "HttpOnly"
	// ForwardingProtocolHTTPSOnly ...
	ForwardingProtocolHTTPSOnly ForwardingProtocol = "HttpsOnly"
	// ForwardingProtocolMatchRequest ...
	ForwardingProtocolMatchRequest ForwardingProtocol = "MatchRequest"
)

// PossibleForwardingProtocolValues returns an array of possible values for the ForwardingProtocol const type.
func PossibleForwardingProtocolValues() []ForwardingProtocol {
	return []ForwardingProtocol{ForwardingProtocolHTTPOnly, ForwardingProtocolHTTPSOnly, ForwardingProtocolMatchRequest}
}

// GeoFilterActions enumerates the values for geo filter actions.
type GeoFilterActions string

const (
	// GeoFilterActionsAllow ...
	GeoFilterActionsAllow GeoFilterActions = "Allow"
	// GeoFilterActionsBlock ...
	GeoFilterActionsBlock GeoFilterActions = "Block"
)

// PossibleGeoFilterActionsValues returns an array of possible values for the GeoFilterActions const type.
func PossibleGeoFilterActionsValues() []GeoFilterActions {
	return []GeoFilterActions{GeoFilterActionsAllow, GeoFilterActionsBlock}
}

// Granularity enumerates the values for granularity.
type Granularity string

const (
	// GranularityP1D ...
	GranularityP1D Granularity = "P1D"
	// GranularityPT1H ...
	GranularityPT1H Granularity = "PT1H"
	// GranularityPT5M ...
	GranularityPT5M Granularity = "PT5M"
)

// PossibleGranularityValues returns an array of possible values for the Granularity const type.
func PossibleGranularityValues() []Granularity {
	return []Granularity{GranularityP1D, GranularityPT1H, GranularityPT5M}
}

// Granularity1 enumerates the values for granularity 1.
type Granularity1 string

const (
	// Granularity1P1D ...
	Granularity1P1D Granularity1 = "P1D"
	// Granularity1PT1H ...
	Granularity1PT1H Granularity1 = "PT1H"
	// Granularity1PT5M ...
	Granularity1PT5M Granularity1 = "PT5M"
)

// PossibleGranularity1Values returns an array of possible values for the Granularity1 const type.
func PossibleGranularity1Values() []Granularity1 {
	return []Granularity1{Granularity1P1D, Granularity1PT1H, Granularity1PT5M}
}

// HeaderAction enumerates the values for header action.
type HeaderAction string

const (
	// HeaderActionAppend ...
	HeaderActionAppend HeaderAction = "Append"
	// HeaderActionDelete ...
	HeaderActionDelete HeaderAction = "Delete"
	// HeaderActionOverwrite ...
	HeaderActionOverwrite HeaderAction = "Overwrite"
)

// PossibleHeaderActionValues returns an array of possible values for the HeaderAction const type.
func PossibleHeaderActionValues() []HeaderAction {
	return []HeaderAction{HeaderActionAppend, HeaderActionDelete, HeaderActionOverwrite}
}

// HealthProbeRequestType enumerates the values for health probe request type.
type HealthProbeRequestType string

const (
	// HealthProbeRequestTypeGET ...
	HealthProbeRequestTypeGET HealthProbeRequestType = "GET"
	// HealthProbeRequestTypeHEAD ...
	HealthProbeRequestTypeHEAD HealthProbeRequestType = "HEAD"
	// HealthProbeRequestTypeNotSet ...
	HealthProbeRequestTypeNotSet HealthProbeRequestType = "NotSet"
)

// PossibleHealthProbeRequestTypeValues returns an array of possible values for the HealthProbeRequestType const type.
func PossibleHealthProbeRequestTypeValues() []HealthProbeRequestType {
	return []HealthProbeRequestType{HealthProbeRequestTypeGET, HealthProbeRequestTypeHEAD, HealthProbeRequestTypeNotSet}
}

// HTTPSRedirect enumerates the values for https redirect.
type HTTPSRedirect string

const (
	// HTTPSRedirectDisabled ...
	HTTPSRedirectDisabled HTTPSRedirect = "Disabled"
	// HTTPSRedirectEnabled ...
	HTTPSRedirectEnabled HTTPSRedirect = "Enabled"
)

// PossibleHTTPSRedirectValues returns an array of possible values for the HTTPSRedirect const type.
func PossibleHTTPSRedirectValues() []HTTPSRedirect {
	return []HTTPSRedirect{HTTPSRedirectDisabled, HTTPSRedirectEnabled}
}

// IdentityType enumerates the values for identity type.
type IdentityType string

const (
	// IdentityTypeApplication ...
	IdentityTypeApplication IdentityType = "application"
	// IdentityTypeKey ...
	IdentityTypeKey IdentityType = "key"
	// IdentityTypeManagedIdentity ...
	IdentityTypeManagedIdentity IdentityType = "managedIdentity"
	// IdentityTypeUser ...
	IdentityTypeUser IdentityType = "user"
)

// PossibleIdentityTypeValues returns an array of possible values for the IdentityType const type.
func PossibleIdentityTypeValues() []IdentityType {
	return []IdentityType{IdentityTypeApplication, IdentityTypeKey, IdentityTypeManagedIdentity, IdentityTypeUser}
}

// LinkToDefaultDomain enumerates the values for link to default domain.
type LinkToDefaultDomain string

const (
	// LinkToDefaultDomainDisabled ...
	LinkToDefaultDomainDisabled LinkToDefaultDomain = "Disabled"
	// LinkToDefaultDomainEnabled ...
	LinkToDefaultDomainEnabled LinkToDefaultDomain = "Enabled"
)

// PossibleLinkToDefaultDomainValues returns an array of possible values for the LinkToDefaultDomain const type.
func PossibleLinkToDefaultDomainValues() []LinkToDefaultDomain {
	return []LinkToDefaultDomain{LinkToDefaultDomainDisabled, LinkToDefaultDomainEnabled}
}

// LogMetric enumerates the values for log metric.
type LogMetric string

const (
	// LogMetricClientRequestBandwidth ...
	LogMetricClientRequestBandwidth LogMetric = "clientRequestBandwidth"
	// LogMetricClientRequestCount ...
	LogMetricClientRequestCount LogMetric = "clientRequestCount"
	// LogMetricClientRequestTraffic ...
	LogMetricClientRequestTraffic LogMetric = "clientRequestTraffic"
	// LogMetricOriginRequestBandwidth ...
	LogMetricOriginRequestBandwidth LogMetric = "originRequestBandwidth"
	// LogMetricOriginRequestTraffic ...
	LogMetricOriginRequestTraffic LogMetric = "originRequestTraffic"
	// LogMetricTotalLatency ...
	LogMetricTotalLatency LogMetric = "totalLatency"
)

// PossibleLogMetricValues returns an array of possible values for the LogMetric const type.
func PossibleLogMetricValues() []LogMetric {
	return []LogMetric{LogMetricClientRequestBandwidth, LogMetricClientRequestCount, LogMetricClientRequestTraffic, LogMetricOriginRequestBandwidth, LogMetricOriginRequestTraffic, LogMetricTotalLatency}
}

// LogMetricsGranularity enumerates the values for log metrics granularity.
type LogMetricsGranularity string

const (
	// LogMetricsGranularityP1D ...
	LogMetricsGranularityP1D LogMetricsGranularity = "P1D"
	// LogMetricsGranularityPT1H ...
	LogMetricsGranularityPT1H LogMetricsGranularity = "PT1H"
	// LogMetricsGranularityPT5M ...
	LogMetricsGranularityPT5M LogMetricsGranularity = "PT5M"
)

// PossibleLogMetricsGranularityValues returns an array of possible values for the LogMetricsGranularity const type.
func PossibleLogMetricsGranularityValues() []LogMetricsGranularity {
	return []LogMetricsGranularity{LogMetricsGranularityP1D, LogMetricsGranularityPT1H, LogMetricsGranularityPT5M}
}

// LogMetricsGroupBy enumerates the values for log metrics group by.
type LogMetricsGroupBy string

const (
	// LogMetricsGroupByCacheStatus ...
	LogMetricsGroupByCacheStatus LogMetricsGroupBy = "cacheStatus"
	// LogMetricsGroupByCountry ...
	LogMetricsGroupByCountry LogMetricsGroupBy = "country"
	// LogMetricsGroupByCustomDomain ...
	LogMetricsGroupByCustomDomain LogMetricsGroupBy = "customDomain"
	// LogMetricsGroupByHTTPStatusCode ...
	LogMetricsGroupByHTTPStatusCode LogMetricsGroupBy = "httpStatusCode"
	// LogMetricsGroupByProtocol ...
	LogMetricsGroupByProtocol LogMetricsGroupBy = "protocol"
)

// PossibleLogMetricsGroupByValues returns an array of possible values for the LogMetricsGroupBy const type.
func PossibleLogMetricsGroupByValues() []LogMetricsGroupBy {
	return []LogMetricsGroupBy{LogMetricsGroupByCacheStatus, LogMetricsGroupByCountry, LogMetricsGroupByCustomDomain, LogMetricsGroupByHTTPStatusCode, LogMetricsGroupByProtocol}
}

// LogRanking enumerates the values for log ranking.
type LogRanking string

const (
	// LogRankingBrowser ...
	LogRankingBrowser LogRanking = "browser"
	// LogRankingCountryOrRegion ...
	LogRankingCountryOrRegion LogRanking = "countryOrRegion"
	// LogRankingReferrer ...
	LogRankingReferrer LogRanking = "referrer"
	// LogRankingURL ...
	LogRankingURL LogRanking = "url"
	// LogRankingUserAgent ...
	LogRankingUserAgent LogRanking = "userAgent"
)

// PossibleLogRankingValues returns an array of possible values for the LogRanking const type.
func PossibleLogRankingValues() []LogRanking {
	return []LogRanking{LogRankingBrowser, LogRankingCountryOrRegion, LogRankingReferrer, LogRankingURL, LogRankingUserAgent}
}

// LogRankingMetric enumerates the values for log ranking metric.
type LogRankingMetric string

const (
	// LogRankingMetricClientRequestCount ...
	LogRankingMetricClientRequestCount LogRankingMetric = "clientRequestCount"
	// LogRankingMetricClientRequestTraffic ...
	LogRankingMetricClientRequestTraffic LogRankingMetric = "clientRequestTraffic"
	// LogRankingMetricErrorCount ...
	LogRankingMetricErrorCount LogRankingMetric = "errorCount"
	// LogRankingMetricHitCount ...
	LogRankingMetricHitCount LogRankingMetric = "hitCount"
	// LogRankingMetricMissCount ...
	LogRankingMetricMissCount LogRankingMetric = "missCount"
	// LogRankingMetricUserErrorCount ...
	LogRankingMetricUserErrorCount LogRankingMetric = "userErrorCount"
)

// PossibleLogRankingMetricValues returns an array of possible values for the LogRankingMetric const type.
func PossibleLogRankingMetricValues() []LogRankingMetric {
	return []LogRankingMetric{LogRankingMetricClientRequestCount, LogRankingMetricClientRequestTraffic, LogRankingMetricErrorCount, LogRankingMetricHitCount, LogRankingMetricMissCount, LogRankingMetricUserErrorCount}
}

// ManagedRuleEnabledState enumerates the values for managed rule enabled state.
type ManagedRuleEnabledState string

const (
	// ManagedRuleEnabledStateDisabled ...
	ManagedRuleEnabledStateDisabled ManagedRuleEnabledState = "Disabled"
	// ManagedRuleEnabledStateEnabled ...
	ManagedRuleEnabledStateEnabled ManagedRuleEnabledState = "Enabled"
)

// PossibleManagedRuleEnabledStateValues returns an array of possible values for the ManagedRuleEnabledState const type.
func PossibleManagedRuleEnabledStateValues() []ManagedRuleEnabledState {
	return []ManagedRuleEnabledState{ManagedRuleEnabledStateDisabled, ManagedRuleEnabledStateEnabled}
}

// MatchProcessingBehavior enumerates the values for match processing behavior.
type MatchProcessingBehavior string

const (
	// MatchProcessingBehaviorContinue ...
	MatchProcessingBehaviorContinue MatchProcessingBehavior = "Continue"
	// MatchProcessingBehaviorStop ...
	MatchProcessingBehaviorStop MatchProcessingBehavior = "Stop"
)

// PossibleMatchProcessingBehaviorValues returns an array of possible values for the MatchProcessingBehavior const type.
func PossibleMatchProcessingBehaviorValues() []MatchProcessingBehavior {
	return []MatchProcessingBehavior{MatchProcessingBehaviorContinue, MatchProcessingBehaviorStop}
}

// MatchVariable enumerates the values for match variable.
type MatchVariable string

const (
	// MatchVariableCookies ...
	MatchVariableCookies MatchVariable = "Cookies"
	// MatchVariablePostArgs ...
	MatchVariablePostArgs MatchVariable = "PostArgs"
	// MatchVariableQueryString ...
	MatchVariableQueryString MatchVariable = "QueryString"
	// MatchVariableRemoteAddr ...
	MatchVariableRemoteAddr MatchVariable = "RemoteAddr"
	// MatchVariableRequestBody ...
	MatchVariableRequestBody MatchVariable = "RequestBody"
	// MatchVariableRequestHeader ...
	MatchVariableRequestHeader MatchVariable = "RequestHeader"
	// MatchVariableRequestMethod ...
	MatchVariableRequestMethod MatchVariable = "RequestMethod"
	// MatchVariableRequestURI ...
	MatchVariableRequestURI MatchVariable = "RequestUri"
	// MatchVariableSocketAddr ...
	MatchVariableSocketAddr MatchVariable = "SocketAddr"
)

// PossibleMatchVariableValues returns an array of possible values for the MatchVariable const type.
func PossibleMatchVariableValues() []MatchVariable {
	return []MatchVariable{MatchVariableCookies, MatchVariablePostArgs, MatchVariableQueryString, MatchVariableRemoteAddr, MatchVariableRequestBody, MatchVariableRequestHeader, MatchVariableRequestMethod, MatchVariableRequestURI, MatchVariableSocketAddr}
}

// MinimumTLSVersion enumerates the values for minimum tls version.
type MinimumTLSVersion string

const (
	// MinimumTLSVersionNone ...
	MinimumTLSVersionNone MinimumTLSVersion = "None"
	// MinimumTLSVersionTLS10 ...
	MinimumTLSVersionTLS10 MinimumTLSVersion = "TLS10"
	// MinimumTLSVersionTLS12 ...
	MinimumTLSVersionTLS12 MinimumTLSVersion = "TLS12"
)

// PossibleMinimumTLSVersionValues returns an array of possible values for the MinimumTLSVersion const type.
func PossibleMinimumTLSVersionValues() []MinimumTLSVersion {
	return []MinimumTLSVersion{MinimumTLSVersionNone, MinimumTLSVersionTLS10, MinimumTLSVersionTLS12}
}

// Name enumerates the values for name.
type Name string

const (
	// NameCookies ...
	NameCookies Name = "Cookies"
	// NameDeliveryRuleCondition ...
	NameDeliveryRuleCondition Name = "DeliveryRuleCondition"
	// NameHTTPVersion ...
	NameHTTPVersion Name = "HttpVersion"
	// NameIsDevice ...
	NameIsDevice Name = "IsDevice"
	// NamePostArgs ...
	NamePostArgs Name = "PostArgs"
	// NameQueryString ...
	NameQueryString Name = "QueryString"
	// NameRemoteAddress ...
	NameRemoteAddress Name = "RemoteAddress"
	// NameRequestBody ...
	NameRequestBody Name = "RequestBody"
	// NameRequestHeader ...
	NameRequestHeader Name = "RequestHeader"
	// NameRequestMethod ...
	NameRequestMethod Name = "RequestMethod"
	// NameRequestScheme ...
	NameRequestScheme Name = "RequestScheme"
	// NameRequestURI ...
	NameRequestURI Name = "RequestUri"
	// NameURLFileExtension ...
	NameURLFileExtension Name = "UrlFileExtension"
	// NameURLFileName ...
	NameURLFileName Name = "UrlFileName"
	// NameURLPath ...
	NameURLPath Name = "UrlPath"
)

// PossibleNameValues returns an array of possible values for the Name const type.
func PossibleNameValues() []Name {
	return []Name{NameCookies, NameDeliveryRuleCondition, NameHTTPVersion, NameIsDevice, NamePostArgs, NameQueryString, NameRemoteAddress, NameRequestBody, NameRequestHeader, NameRequestMethod, NameRequestScheme, NameRequestURI, NameURLFileExtension, NameURLFileName, NameURLPath}
}

// NameBasicDeliveryRuleAction enumerates the values for name basic delivery rule action.
type NameBasicDeliveryRuleAction string

const (
	// NameBasicDeliveryRuleActionNameCacheExpiration ...
	NameBasicDeliveryRuleActionNameCacheExpiration NameBasicDeliveryRuleAction = "CacheExpiration"
	// NameBasicDeliveryRuleActionNameCacheKeyQueryString ...
	NameBasicDeliveryRuleActionNameCacheKeyQueryString NameBasicDeliveryRuleAction = "CacheKeyQueryString"
	// NameBasicDeliveryRuleActionNameDeliveryRuleAction ...
	NameBasicDeliveryRuleActionNameDeliveryRuleAction NameBasicDeliveryRuleAction = "DeliveryRuleAction"
	// NameBasicDeliveryRuleActionNameModifyRequestHeader ...
	NameBasicDeliveryRuleActionNameModifyRequestHeader NameBasicDeliveryRuleAction = "ModifyRequestHeader"
	// NameBasicDeliveryRuleActionNameModifyResponseHeader ...
	NameBasicDeliveryRuleActionNameModifyResponseHeader NameBasicDeliveryRuleAction = "ModifyResponseHeader"
	// NameBasicDeliveryRuleActionNameOriginGroupOverride ...
	NameBasicDeliveryRuleActionNameOriginGroupOverride NameBasicDeliveryRuleAction = "OriginGroupOverride"
	// NameBasicDeliveryRuleActionNameURLRedirect ...
	NameBasicDeliveryRuleActionNameURLRedirect NameBasicDeliveryRuleAction = "UrlRedirect"
	// NameBasicDeliveryRuleActionNameURLRewrite ...
	NameBasicDeliveryRuleActionNameURLRewrite NameBasicDeliveryRuleAction = "UrlRewrite"
	// NameBasicDeliveryRuleActionNameURLSigning ...
	NameBasicDeliveryRuleActionNameURLSigning NameBasicDeliveryRuleAction = "UrlSigning"
)

// PossibleNameBasicDeliveryRuleActionValues returns an array of possible values for the NameBasicDeliveryRuleAction const type.
func PossibleNameBasicDeliveryRuleActionValues() []NameBasicDeliveryRuleAction {
	return []NameBasicDeliveryRuleAction{NameBasicDeliveryRuleActionNameCacheExpiration, NameBasicDeliveryRuleActionNameCacheKeyQueryString, NameBasicDeliveryRuleActionNameDeliveryRuleAction, NameBasicDeliveryRuleActionNameModifyRequestHeader, NameBasicDeliveryRuleActionNameModifyResponseHeader, NameBasicDeliveryRuleActionNameOriginGroupOverride, NameBasicDeliveryRuleActionNameURLRedirect, NameBasicDeliveryRuleActionNameURLRewrite, NameBasicDeliveryRuleActionNameURLSigning}
}

// Operator enumerates the values for operator.
type Operator string

const (
	// OperatorAny ...
	OperatorAny Operator = "Any"
	// OperatorBeginsWith ...
	OperatorBeginsWith Operator = "BeginsWith"
	// OperatorContains ...
	OperatorContains Operator = "Contains"
	// OperatorEndsWith ...
	OperatorEndsWith Operator = "EndsWith"
	// OperatorEqual ...
	OperatorEqual Operator = "Equal"
	// OperatorGeoMatch ...
	OperatorGeoMatch Operator = "GeoMatch"
	// OperatorGreaterThan ...
	OperatorGreaterThan Operator = "GreaterThan"
	// OperatorGreaterThanOrEqual ...
	OperatorGreaterThanOrEqual Operator = "GreaterThanOrEqual"
	// OperatorIPMatch ...
	OperatorIPMatch Operator = "IPMatch"
	// OperatorLessThan ...
	OperatorLessThan Operator = "LessThan"
	// OperatorLessThanOrEqual ...
	OperatorLessThanOrEqual Operator = "LessThanOrEqual"
	// OperatorRegEx ...
	OperatorRegEx Operator = "RegEx"
)

// PossibleOperatorValues returns an array of possible values for the Operator const type.
func PossibleOperatorValues() []Operator {
	return []Operator{OperatorAny, OperatorBeginsWith, OperatorContains, OperatorEndsWith, OperatorEqual, OperatorGeoMatch, OperatorGreaterThan, OperatorGreaterThanOrEqual, OperatorIPMatch, OperatorLessThan, OperatorLessThanOrEqual, OperatorRegEx}
}

// OptimizationType enumerates the values for optimization type.
type OptimizationType string

const (
	// OptimizationTypeDynamicSiteAcceleration ...
	OptimizationTypeDynamicSiteAcceleration OptimizationType = "DynamicSiteAcceleration"
	// OptimizationTypeGeneralMediaStreaming ...
	OptimizationTypeGeneralMediaStreaming OptimizationType = "GeneralMediaStreaming"
	// OptimizationTypeGeneralWebDelivery ...
	OptimizationTypeGeneralWebDelivery OptimizationType = "GeneralWebDelivery"
	// OptimizationTypeLargeFileDownload ...
	OptimizationTypeLargeFileDownload OptimizationType = "LargeFileDownload"
	// OptimizationTypeVideoOnDemandMediaStreaming ...
	OptimizationTypeVideoOnDemandMediaStreaming OptimizationType = "VideoOnDemandMediaStreaming"
)

// PossibleOptimizationTypeValues returns an array of possible values for the OptimizationType const type.
func PossibleOptimizationTypeValues() []OptimizationType {
	return []OptimizationType{OptimizationTypeDynamicSiteAcceleration, OptimizationTypeGeneralMediaStreaming, OptimizationTypeGeneralWebDelivery, OptimizationTypeLargeFileDownload, OptimizationTypeVideoOnDemandMediaStreaming}
}

// OriginGroupResourceState enumerates the values for origin group resource state.
type OriginGroupResourceState string

const (
	// OriginGroupResourceStateActive ...
	OriginGroupResourceStateActive OriginGroupResourceState = "Active"
	// OriginGroupResourceStateCreating ...
	OriginGroupResourceStateCreating OriginGroupResourceState = "Creating"
	// OriginGroupResourceStateDeleting ...
	OriginGroupResourceStateDeleting OriginGroupResourceState = "Deleting"
)

// PossibleOriginGroupResourceStateValues returns an array of possible values for the OriginGroupResourceState const type.
func PossibleOriginGroupResourceStateValues() []OriginGroupResourceState {
	return []OriginGroupResourceState{OriginGroupResourceStateActive, OriginGroupResourceStateCreating, OriginGroupResourceStateDeleting}
}

// OriginResourceState enumerates the values for origin resource state.
type OriginResourceState string

const (
	// OriginResourceStateActive ...
	OriginResourceStateActive OriginResourceState = "Active"
	// OriginResourceStateCreating ...
	OriginResourceStateCreating OriginResourceState = "Creating"
	// OriginResourceStateDeleting ...
	OriginResourceStateDeleting OriginResourceState = "Deleting"
)

// PossibleOriginResourceStateValues returns an array of possible values for the OriginResourceState const type.
func PossibleOriginResourceStateValues() []OriginResourceState {
	return []OriginResourceState{OriginResourceStateActive, OriginResourceStateCreating, OriginResourceStateDeleting}
}

// ParamIndicator enumerates the values for param indicator.
type ParamIndicator string

const (
	// ParamIndicatorExpires ...
	ParamIndicatorExpires ParamIndicator = "Expires"
	// ParamIndicatorKeyID ...
	ParamIndicatorKeyID ParamIndicator = "KeyId"
	// ParamIndicatorSignature ...
	ParamIndicatorSignature ParamIndicator = "Signature"
)

// PossibleParamIndicatorValues returns an array of possible values for the ParamIndicator const type.
func PossibleParamIndicatorValues() []ParamIndicator {
	return []ParamIndicator{ParamIndicatorExpires, ParamIndicatorKeyID, ParamIndicatorSignature}
}

// PolicyEnabledState enumerates the values for policy enabled state.
type PolicyEnabledState string

const (
	// PolicyEnabledStateDisabled ...
	PolicyEnabledStateDisabled PolicyEnabledState = "Disabled"
	// PolicyEnabledStateEnabled ...
	PolicyEnabledStateEnabled PolicyEnabledState = "Enabled"
)

// PossiblePolicyEnabledStateValues returns an array of possible values for the PolicyEnabledState const type.
func PossiblePolicyEnabledStateValues() []PolicyEnabledState {
	return []PolicyEnabledState{PolicyEnabledStateDisabled, PolicyEnabledStateEnabled}
}

// PolicyMode enumerates the values for policy mode.
type PolicyMode string

const (
	// PolicyModeDetection ...
	PolicyModeDetection PolicyMode = "Detection"
	// PolicyModePrevention ...
	PolicyModePrevention PolicyMode = "Prevention"
)

// PossiblePolicyModeValues returns an array of possible values for the PolicyMode const type.
func PossiblePolicyModeValues() []PolicyMode {
	return []PolicyMode{PolicyModeDetection, PolicyModePrevention}
}

// PolicyResourceState enumerates the values for policy resource state.
type PolicyResourceState string

const (
	// PolicyResourceStateCreating ...
	PolicyResourceStateCreating PolicyResourceState = "Creating"
	// PolicyResourceStateDeleting ...
	PolicyResourceStateDeleting PolicyResourceState = "Deleting"
	// PolicyResourceStateDisabled ...
	PolicyResourceStateDisabled PolicyResourceState = "Disabled"
	// PolicyResourceStateDisabling ...
	PolicyResourceStateDisabling PolicyResourceState = "Disabling"
	// PolicyResourceStateEnabled ...
	PolicyResourceStateEnabled PolicyResourceState = "Enabled"
	// PolicyResourceStateEnabling ...
	PolicyResourceStateEnabling PolicyResourceState = "Enabling"
)

// PossiblePolicyResourceStateValues returns an array of possible values for the PolicyResourceState const type.
func PossiblePolicyResourceStateValues() []PolicyResourceState {
	return []PolicyResourceState{PolicyResourceStateCreating, PolicyResourceStateDeleting, PolicyResourceStateDisabled, PolicyResourceStateDisabling, PolicyResourceStateEnabled, PolicyResourceStateEnabling}
}

// PostArgsOperator enumerates the values for post args operator.
type PostArgsOperator string

const (
	// PostArgsOperatorAny ...
	PostArgsOperatorAny PostArgsOperator = "Any"
	// PostArgsOperatorBeginsWith ...
	PostArgsOperatorBeginsWith PostArgsOperator = "BeginsWith"
	// PostArgsOperatorContains ...
	PostArgsOperatorContains PostArgsOperator = "Contains"
	// PostArgsOperatorEndsWith ...
	PostArgsOperatorEndsWith PostArgsOperator = "EndsWith"
	// PostArgsOperatorEqual ...
	PostArgsOperatorEqual PostArgsOperator = "Equal"
	// PostArgsOperatorGreaterThan ...
	PostArgsOperatorGreaterThan PostArgsOperator = "GreaterThan"
	// PostArgsOperatorGreaterThanOrEqual ...
	PostArgsOperatorGreaterThanOrEqual PostArgsOperator = "GreaterThanOrEqual"
	// PostArgsOperatorLessThan ...
	PostArgsOperatorLessThan PostArgsOperator = "LessThan"
	// PostArgsOperatorLessThanOrEqual ...
	PostArgsOperatorLessThanOrEqual PostArgsOperator = "LessThanOrEqual"
	// PostArgsOperatorRegEx ...
	PostArgsOperatorRegEx PostArgsOperator = "RegEx"
)

// PossiblePostArgsOperatorValues returns an array of possible values for the PostArgsOperator const type.
func PossiblePostArgsOperatorValues() []PostArgsOperator {
	return []PostArgsOperator{PostArgsOperatorAny, PostArgsOperatorBeginsWith, PostArgsOperatorContains, PostArgsOperatorEndsWith, PostArgsOperatorEqual, PostArgsOperatorGreaterThan, PostArgsOperatorGreaterThanOrEqual, PostArgsOperatorLessThan, PostArgsOperatorLessThanOrEqual, PostArgsOperatorRegEx}
}

// PrivateEndpointStatus enumerates the values for private endpoint status.
type PrivateEndpointStatus string

const (
	// PrivateEndpointStatusApproved ...
	PrivateEndpointStatusApproved PrivateEndpointStatus = "Approved"
	// PrivateEndpointStatusDisconnected ...
	PrivateEndpointStatusDisconnected PrivateEndpointStatus = "Disconnected"
	// PrivateEndpointStatusPending ...
	PrivateEndpointStatusPending PrivateEndpointStatus = "Pending"
	// PrivateEndpointStatusRejected ...
	PrivateEndpointStatusRejected PrivateEndpointStatus = "Rejected"
	// PrivateEndpointStatusTimeout ...
	PrivateEndpointStatusTimeout PrivateEndpointStatus = "Timeout"
)

// PossiblePrivateEndpointStatusValues returns an array of possible values for the PrivateEndpointStatus const type.
func PossiblePrivateEndpointStatusValues() []PrivateEndpointStatus {
	return []PrivateEndpointStatus{PrivateEndpointStatusApproved, PrivateEndpointStatusDisconnected, PrivateEndpointStatusPending, PrivateEndpointStatusRejected, PrivateEndpointStatusTimeout}
}

// ProbeProtocol enumerates the values for probe protocol.
type ProbeProtocol string

const (
	// ProbeProtocolHTTP ...
	ProbeProtocolHTTP ProbeProtocol = "Http"
	// ProbeProtocolHTTPS ...
	ProbeProtocolHTTPS ProbeProtocol = "Https"
	// ProbeProtocolNotSet ...
	ProbeProtocolNotSet ProbeProtocol = "NotSet"
)

// PossibleProbeProtocolValues returns an array of possible values for the ProbeProtocol const type.
func PossibleProbeProtocolValues() []ProbeProtocol {
	return []ProbeProtocol{ProbeProtocolHTTP, ProbeProtocolHTTPS, ProbeProtocolNotSet}
}

// ProfileResourceState enumerates the values for profile resource state.
type ProfileResourceState string

const (
	// ProfileResourceStateActive ...
	ProfileResourceStateActive ProfileResourceState = "Active"
	// ProfileResourceStateCreating ...
	ProfileResourceStateCreating ProfileResourceState = "Creating"
	// ProfileResourceStateDeleting ...
	ProfileResourceStateDeleting ProfileResourceState = "Deleting"
	// ProfileResourceStateDisabled ...
	ProfileResourceStateDisabled ProfileResourceState = "Disabled"
)

// PossibleProfileResourceStateValues returns an array of possible values for the ProfileResourceState const type.
func PossibleProfileResourceStateValues() []ProfileResourceState {
	return []ProfileResourceState{ProfileResourceStateActive, ProfileResourceStateCreating, ProfileResourceStateDeleting, ProfileResourceStateDisabled}
}

// ProtocolType enumerates the values for protocol type.
type ProtocolType string

const (
	// ProtocolTypeIPBased ...
	ProtocolTypeIPBased ProtocolType = "IPBased"
	// ProtocolTypeServerNameIndication ...
	ProtocolTypeServerNameIndication ProtocolType = "ServerNameIndication"
)

// PossibleProtocolTypeValues returns an array of possible values for the ProtocolType const type.
func PossibleProtocolTypeValues() []ProtocolType {
	return []ProtocolType{ProtocolTypeIPBased, ProtocolTypeServerNameIndication}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCreating ...
	ProvisioningStateCreating ProvisioningState = "Creating"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateCreating, ProvisioningStateFailed, ProvisioningStateSucceeded}
}

// QueryStringBehavior enumerates the values for query string behavior.
type QueryStringBehavior string

const (
	// QueryStringBehaviorExclude ...
	QueryStringBehaviorExclude QueryStringBehavior = "Exclude"
	// QueryStringBehaviorExcludeAll ...
	QueryStringBehaviorExcludeAll QueryStringBehavior = "ExcludeAll"
	// QueryStringBehaviorInclude ...
	QueryStringBehaviorInclude QueryStringBehavior = "Include"
	// QueryStringBehaviorIncludeAll ...
	QueryStringBehaviorIncludeAll QueryStringBehavior = "IncludeAll"
)

// PossibleQueryStringBehaviorValues returns an array of possible values for the QueryStringBehavior const type.
func PossibleQueryStringBehaviorValues() []QueryStringBehavior {
	return []QueryStringBehavior{QueryStringBehaviorExclude, QueryStringBehaviorExcludeAll, QueryStringBehaviorInclude, QueryStringBehaviorIncludeAll}
}

// QueryStringCachingBehavior enumerates the values for query string caching behavior.
type QueryStringCachingBehavior string

const (
	// QueryStringCachingBehaviorBypassCaching ...
	QueryStringCachingBehaviorBypassCaching QueryStringCachingBehavior = "BypassCaching"
	// QueryStringCachingBehaviorIgnoreQueryString ...
	QueryStringCachingBehaviorIgnoreQueryString QueryStringCachingBehavior = "IgnoreQueryString"
	// QueryStringCachingBehaviorNotSet ...
	QueryStringCachingBehaviorNotSet QueryStringCachingBehavior = "NotSet"
	// QueryStringCachingBehaviorUseQueryString ...
	QueryStringCachingBehaviorUseQueryString QueryStringCachingBehavior = "UseQueryString"
)

// PossibleQueryStringCachingBehaviorValues returns an array of possible values for the QueryStringCachingBehavior const type.
func PossibleQueryStringCachingBehaviorValues() []QueryStringCachingBehavior {
	return []QueryStringCachingBehavior{QueryStringCachingBehaviorBypassCaching, QueryStringCachingBehaviorIgnoreQueryString, QueryStringCachingBehaviorNotSet, QueryStringCachingBehaviorUseQueryString}
}

// QueryStringOperator enumerates the values for query string operator.
type QueryStringOperator string

const (
	// QueryStringOperatorAny ...
	QueryStringOperatorAny QueryStringOperator = "Any"
	// QueryStringOperatorBeginsWith ...
	QueryStringOperatorBeginsWith QueryStringOperator = "BeginsWith"
	// QueryStringOperatorContains ...
	QueryStringOperatorContains QueryStringOperator = "Contains"
	// QueryStringOperatorEndsWith ...
	QueryStringOperatorEndsWith QueryStringOperator = "EndsWith"
	// QueryStringOperatorEqual ...
	QueryStringOperatorEqual QueryStringOperator = "Equal"
	// QueryStringOperatorGreaterThan ...
	QueryStringOperatorGreaterThan QueryStringOperator = "GreaterThan"
	// QueryStringOperatorGreaterThanOrEqual ...
	QueryStringOperatorGreaterThanOrEqual QueryStringOperator = "GreaterThanOrEqual"
	// QueryStringOperatorLessThan ...
	QueryStringOperatorLessThan QueryStringOperator = "LessThan"
	// QueryStringOperatorLessThanOrEqual ...
	QueryStringOperatorLessThanOrEqual QueryStringOperator = "LessThanOrEqual"
	// QueryStringOperatorRegEx ...
	QueryStringOperatorRegEx QueryStringOperator = "RegEx"
)

// PossibleQueryStringOperatorValues returns an array of possible values for the QueryStringOperator const type.
func PossibleQueryStringOperatorValues() []QueryStringOperator {
	return []QueryStringOperator{QueryStringOperatorAny, QueryStringOperatorBeginsWith, QueryStringOperatorContains, QueryStringOperatorEndsWith, QueryStringOperatorEqual, QueryStringOperatorGreaterThan, QueryStringOperatorGreaterThanOrEqual, QueryStringOperatorLessThan, QueryStringOperatorLessThanOrEqual, QueryStringOperatorRegEx}
}

// RedirectType enumerates the values for redirect type.
type RedirectType string

const (
	// RedirectTypeFound ...
	RedirectTypeFound RedirectType = "Found"
	// RedirectTypeMoved ...
	RedirectTypeMoved RedirectType = "Moved"
	// RedirectTypePermanentRedirect ...
	RedirectTypePermanentRedirect RedirectType = "PermanentRedirect"
	// RedirectTypeTemporaryRedirect ...
	RedirectTypeTemporaryRedirect RedirectType = "TemporaryRedirect"
)

// PossibleRedirectTypeValues returns an array of possible values for the RedirectType const type.
func PossibleRedirectTypeValues() []RedirectType {
	return []RedirectType{RedirectTypeFound, RedirectTypeMoved, RedirectTypePermanentRedirect, RedirectTypeTemporaryRedirect}
}

// RemoteAddressOperator enumerates the values for remote address operator.
type RemoteAddressOperator string

const (
	// RemoteAddressOperatorAny ...
	RemoteAddressOperatorAny RemoteAddressOperator = "Any"
	// RemoteAddressOperatorGeoMatch ...
	RemoteAddressOperatorGeoMatch RemoteAddressOperator = "GeoMatch"
	// RemoteAddressOperatorIPMatch ...
	RemoteAddressOperatorIPMatch RemoteAddressOperator = "IPMatch"
)

// PossibleRemoteAddressOperatorValues returns an array of possible values for the RemoteAddressOperator const type.
func PossibleRemoteAddressOperatorValues() []RemoteAddressOperator {
	return []RemoteAddressOperator{RemoteAddressOperatorAny, RemoteAddressOperatorGeoMatch, RemoteAddressOperatorIPMatch}
}

// RequestBodyOperator enumerates the values for request body operator.
type RequestBodyOperator string

const (
	// RequestBodyOperatorAny ...
	RequestBodyOperatorAny RequestBodyOperator = "Any"
	// RequestBodyOperatorBeginsWith ...
	RequestBodyOperatorBeginsWith RequestBodyOperator = "BeginsWith"
	// RequestBodyOperatorContains ...
	RequestBodyOperatorContains RequestBodyOperator = "Contains"
	// RequestBodyOperatorEndsWith ...
	RequestBodyOperatorEndsWith RequestBodyOperator = "EndsWith"
	// RequestBodyOperatorEqual ...
	RequestBodyOperatorEqual RequestBodyOperator = "Equal"
	// RequestBodyOperatorGreaterThan ...
	RequestBodyOperatorGreaterThan RequestBodyOperator = "GreaterThan"
	// RequestBodyOperatorGreaterThanOrEqual ...
	RequestBodyOperatorGreaterThanOrEqual RequestBodyOperator = "GreaterThanOrEqual"
	// RequestBodyOperatorLessThan ...
	RequestBodyOperatorLessThan RequestBodyOperator = "LessThan"
	// RequestBodyOperatorLessThanOrEqual ...
	RequestBodyOperatorLessThanOrEqual RequestBodyOperator = "LessThanOrEqual"
	// RequestBodyOperatorRegEx ...
	RequestBodyOperatorRegEx RequestBodyOperator = "RegEx"
)

// PossibleRequestBodyOperatorValues returns an array of possible values for the RequestBodyOperator const type.
func PossibleRequestBodyOperatorValues() []RequestBodyOperator {
	return []RequestBodyOperator{RequestBodyOperatorAny, RequestBodyOperatorBeginsWith, RequestBodyOperatorContains, RequestBodyOperatorEndsWith, RequestBodyOperatorEqual, RequestBodyOperatorGreaterThan, RequestBodyOperatorGreaterThanOrEqual, RequestBodyOperatorLessThan, RequestBodyOperatorLessThanOrEqual, RequestBodyOperatorRegEx}
}

// RequestHeaderOperator enumerates the values for request header operator.
type RequestHeaderOperator string

const (
	// RequestHeaderOperatorAny ...
	RequestHeaderOperatorAny RequestHeaderOperator = "Any"
	// RequestHeaderOperatorBeginsWith ...
	RequestHeaderOperatorBeginsWith RequestHeaderOperator = "BeginsWith"
	// RequestHeaderOperatorContains ...
	RequestHeaderOperatorContains RequestHeaderOperator = "Contains"
	// RequestHeaderOperatorEndsWith ...
	RequestHeaderOperatorEndsWith RequestHeaderOperator = "EndsWith"
	// RequestHeaderOperatorEqual ...
	RequestHeaderOperatorEqual RequestHeaderOperator = "Equal"
	// RequestHeaderOperatorGreaterThan ...
	RequestHeaderOperatorGreaterThan RequestHeaderOperator = "GreaterThan"
	// RequestHeaderOperatorGreaterThanOrEqual ...
	RequestHeaderOperatorGreaterThanOrEqual RequestHeaderOperator = "GreaterThanOrEqual"
	// RequestHeaderOperatorLessThan ...
	RequestHeaderOperatorLessThan RequestHeaderOperator = "LessThan"
	// RequestHeaderOperatorLessThanOrEqual ...
	RequestHeaderOperatorLessThanOrEqual RequestHeaderOperator = "LessThanOrEqual"
	// RequestHeaderOperatorRegEx ...
	RequestHeaderOperatorRegEx RequestHeaderOperator = "RegEx"
)

// PossibleRequestHeaderOperatorValues returns an array of possible values for the RequestHeaderOperator const type.
func PossibleRequestHeaderOperatorValues() []RequestHeaderOperator {
	return []RequestHeaderOperator{RequestHeaderOperatorAny, RequestHeaderOperatorBeginsWith, RequestHeaderOperatorContains, RequestHeaderOperatorEndsWith, RequestHeaderOperatorEqual, RequestHeaderOperatorGreaterThan, RequestHeaderOperatorGreaterThanOrEqual, RequestHeaderOperatorLessThan, RequestHeaderOperatorLessThanOrEqual, RequestHeaderOperatorRegEx}
}

// RequestURIOperator enumerates the values for request uri operator.
type RequestURIOperator string

const (
	// RequestURIOperatorAny ...
	RequestURIOperatorAny RequestURIOperator = "Any"
	// RequestURIOperatorBeginsWith ...
	RequestURIOperatorBeginsWith RequestURIOperator = "BeginsWith"
	// RequestURIOperatorContains ...
	RequestURIOperatorContains RequestURIOperator = "Contains"
	// RequestURIOperatorEndsWith ...
	RequestURIOperatorEndsWith RequestURIOperator = "EndsWith"
	// RequestURIOperatorEqual ...
	RequestURIOperatorEqual RequestURIOperator = "Equal"
	// RequestURIOperatorGreaterThan ...
	RequestURIOperatorGreaterThan RequestURIOperator = "GreaterThan"
	// RequestURIOperatorGreaterThanOrEqual ...
	RequestURIOperatorGreaterThanOrEqual RequestURIOperator = "GreaterThanOrEqual"
	// RequestURIOperatorLessThan ...
	RequestURIOperatorLessThan RequestURIOperator = "LessThan"
	// RequestURIOperatorLessThanOrEqual ...
	RequestURIOperatorLessThanOrEqual RequestURIOperator = "LessThanOrEqual"
	// RequestURIOperatorRegEx ...
	RequestURIOperatorRegEx RequestURIOperator = "RegEx"
)

// PossibleRequestURIOperatorValues returns an array of possible values for the RequestURIOperator const type.
func PossibleRequestURIOperatorValues() []RequestURIOperator {
	return []RequestURIOperator{RequestURIOperatorAny, RequestURIOperatorBeginsWith, RequestURIOperatorContains, RequestURIOperatorEndsWith, RequestURIOperatorEqual, RequestURIOperatorGreaterThan, RequestURIOperatorGreaterThanOrEqual, RequestURIOperatorLessThan, RequestURIOperatorLessThanOrEqual, RequestURIOperatorRegEx}
}

// ResourceType enumerates the values for resource type.
type ResourceType string

const (
	// ResourceTypeMicrosoftCdnProfilesEndpoints ...
	ResourceTypeMicrosoftCdnProfilesEndpoints ResourceType = "Microsoft.Cdn/Profiles/Endpoints"
)

// PossibleResourceTypeValues returns an array of possible values for the ResourceType const type.
func PossibleResourceTypeValues() []ResourceType {
	return []ResourceType{ResourceTypeMicrosoftCdnProfilesEndpoints}
}

// ResponseBasedDetectedErrorTypes enumerates the values for response based detected error types.
type ResponseBasedDetectedErrorTypes string

const (
	// ResponseBasedDetectedErrorTypesNone ...
	ResponseBasedDetectedErrorTypesNone ResponseBasedDetectedErrorTypes = "None"
	// ResponseBasedDetectedErrorTypesTCPAndHTTPErrors ...
	ResponseBasedDetectedErrorTypesTCPAndHTTPErrors ResponseBasedDetectedErrorTypes = "TcpAndHttpErrors"
	// ResponseBasedDetectedErrorTypesTCPErrorsOnly ...
	ResponseBasedDetectedErrorTypesTCPErrorsOnly ResponseBasedDetectedErrorTypes = "TcpErrorsOnly"
)

// PossibleResponseBasedDetectedErrorTypesValues returns an array of possible values for the ResponseBasedDetectedErrorTypes const type.
func PossibleResponseBasedDetectedErrorTypesValues() []ResponseBasedDetectedErrorTypes {
	return []ResponseBasedDetectedErrorTypes{ResponseBasedDetectedErrorTypesNone, ResponseBasedDetectedErrorTypesTCPAndHTTPErrors, ResponseBasedDetectedErrorTypesTCPErrorsOnly}
}

// SharedPrivateLinkResourceStatus enumerates the values for shared private link resource status.
type SharedPrivateLinkResourceStatus string

const (
	// SharedPrivateLinkResourceStatusApproved ...
	SharedPrivateLinkResourceStatusApproved SharedPrivateLinkResourceStatus = "Approved"
	// SharedPrivateLinkResourceStatusDisconnected ...
	SharedPrivateLinkResourceStatusDisconnected SharedPrivateLinkResourceStatus = "Disconnected"
	// SharedPrivateLinkResourceStatusPending ...
	SharedPrivateLinkResourceStatusPending SharedPrivateLinkResourceStatus = "Pending"
	// SharedPrivateLinkResourceStatusRejected ...
	SharedPrivateLinkResourceStatusRejected SharedPrivateLinkResourceStatus = "Rejected"
	// SharedPrivateLinkResourceStatusTimeout ...
	SharedPrivateLinkResourceStatusTimeout SharedPrivateLinkResourceStatus = "Timeout"
)

// PossibleSharedPrivateLinkResourceStatusValues returns an array of possible values for the SharedPrivateLinkResourceStatus const type.
func PossibleSharedPrivateLinkResourceStatusValues() []SharedPrivateLinkResourceStatus {
	return []SharedPrivateLinkResourceStatus{SharedPrivateLinkResourceStatusApproved, SharedPrivateLinkResourceStatusDisconnected, SharedPrivateLinkResourceStatusPending, SharedPrivateLinkResourceStatusRejected, SharedPrivateLinkResourceStatusTimeout}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// SkuNameCustomVerizon ...
	SkuNameCustomVerizon SkuName = "Custom_Verizon"
	// SkuNamePremiumAzureFrontDoor ...
	SkuNamePremiumAzureFrontDoor SkuName = "Premium_AzureFrontDoor"
	// SkuNamePremiumChinaCdn ...
	SkuNamePremiumChinaCdn SkuName = "Premium_ChinaCdn"
	// SkuNamePremiumVerizon ...
	SkuNamePremiumVerizon SkuName = "Premium_Verizon"
	// SkuNameStandard955BandWidthChinaCdn ...
	SkuNameStandard955BandWidthChinaCdn SkuName = "Standard_955BandWidth_ChinaCdn"
	// SkuNameStandardAkamai ...
	SkuNameStandardAkamai SkuName = "Standard_Akamai"
	// SkuNameStandardAvgBandWidthChinaCdn ...
	SkuNameStandardAvgBandWidthChinaCdn SkuName = "Standard_AvgBandWidth_ChinaCdn"
	// SkuNameStandardAzureFrontDoor ...
	SkuNameStandardAzureFrontDoor SkuName = "Standard_AzureFrontDoor"
	// SkuNameStandardChinaCdn ...
	SkuNameStandardChinaCdn SkuName = "Standard_ChinaCdn"
	// SkuNameStandardMicrosoft ...
	SkuNameStandardMicrosoft SkuName = "Standard_Microsoft"
	// SkuNameStandardPlus955BandWidthChinaCdn ...
	SkuNameStandardPlus955BandWidthChinaCdn SkuName = "StandardPlus_955BandWidth_ChinaCdn"
	// SkuNameStandardPlusAvgBandWidthChinaCdn ...
	SkuNameStandardPlusAvgBandWidthChinaCdn SkuName = "StandardPlus_AvgBandWidth_ChinaCdn"
	// SkuNameStandardPlusChinaCdn ...
	SkuNameStandardPlusChinaCdn SkuName = "StandardPlus_ChinaCdn"
	// SkuNameStandardVerizon ...
	SkuNameStandardVerizon SkuName = "Standard_Verizon"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{SkuNameCustomVerizon, SkuNamePremiumAzureFrontDoor, SkuNamePremiumChinaCdn, SkuNamePremiumVerizon, SkuNameStandard955BandWidthChinaCdn, SkuNameStandardAkamai, SkuNameStandardAvgBandWidthChinaCdn, SkuNameStandardAzureFrontDoor, SkuNameStandardChinaCdn, SkuNameStandardMicrosoft, SkuNameStandardPlus955BandWidthChinaCdn, SkuNameStandardPlusAvgBandWidthChinaCdn, SkuNameStandardPlusChinaCdn, SkuNameStandardVerizon}
}

// Status enumerates the values for status.
type Status string

const (
	// StatusAccessDenied ...
	StatusAccessDenied Status = "AccessDenied"
	// StatusCertificateExpired ...
	StatusCertificateExpired Status = "CertificateExpired"
	// StatusInvalid ...
	StatusInvalid Status = "Invalid"
	// StatusValid ...
	StatusValid Status = "Valid"
)

// PossibleStatusValues returns an array of possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{StatusAccessDenied, StatusCertificateExpired, StatusInvalid, StatusValid}
}

// Transform enumerates the values for transform.
type Transform string

const (
	// TransformLowercase ...
	TransformLowercase Transform = "Lowercase"
	// TransformUppercase ...
	TransformUppercase Transform = "Uppercase"
)

// PossibleTransformValues returns an array of possible values for the Transform const type.
func PossibleTransformValues() []Transform {
	return []Transform{TransformLowercase, TransformUppercase}
}

// TransformType enumerates the values for transform type.
type TransformType string

const (
	// TransformTypeLowercase ...
	TransformTypeLowercase TransformType = "Lowercase"
	// TransformTypeRemoveNulls ...
	TransformTypeRemoveNulls TransformType = "RemoveNulls"
	// TransformTypeTrim ...
	TransformTypeTrim TransformType = "Trim"
	// TransformTypeUppercase ...
	TransformTypeUppercase TransformType = "Uppercase"
	// TransformTypeURLDecode ...
	TransformTypeURLDecode TransformType = "UrlDecode"
	// TransformTypeURLEncode ...
	TransformTypeURLEncode TransformType = "UrlEncode"
)

// PossibleTransformTypeValues returns an array of possible values for the TransformType const type.
func PossibleTransformTypeValues() []TransformType {
	return []TransformType{TransformTypeLowercase, TransformTypeRemoveNulls, TransformTypeTrim, TransformTypeUppercase, TransformTypeURLDecode, TransformTypeURLEncode}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeSecurityPolicyParameters ...
	TypeSecurityPolicyParameters Type = "SecurityPolicyParameters"
	// TypeWebApplicationFirewall ...
	TypeWebApplicationFirewall Type = "WebApplicationFirewall"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeSecurityPolicyParameters, TypeWebApplicationFirewall}
}

// TypeBasicSecretParameters enumerates the values for type basic secret parameters.
type TypeBasicSecretParameters string

const (
	// TypeBasicSecretParametersTypeCustomerCertificate ...
	TypeBasicSecretParametersTypeCustomerCertificate TypeBasicSecretParameters = "CustomerCertificate"
	// TypeBasicSecretParametersTypeManagedCertificate ...
	TypeBasicSecretParametersTypeManagedCertificate TypeBasicSecretParameters = "ManagedCertificate"
	// TypeBasicSecretParametersTypeSecretParameters ...
	TypeBasicSecretParametersTypeSecretParameters TypeBasicSecretParameters = "SecretParameters"
	// TypeBasicSecretParametersTypeURLSigningKey ...
	TypeBasicSecretParametersTypeURLSigningKey TypeBasicSecretParameters = "UrlSigningKey"
)

// PossibleTypeBasicSecretParametersValues returns an array of possible values for the TypeBasicSecretParameters const type.
func PossibleTypeBasicSecretParametersValues() []TypeBasicSecretParameters {
	return []TypeBasicSecretParameters{TypeBasicSecretParametersTypeCustomerCertificate, TypeBasicSecretParametersTypeManagedCertificate, TypeBasicSecretParametersTypeSecretParameters, TypeBasicSecretParametersTypeURLSigningKey}
}

// Unit enumerates the values for unit.
type Unit string

const (
	// UnitBitsPerSecond ...
	UnitBitsPerSecond Unit = "bitsPerSecond"
	// UnitBytes ...
	UnitBytes Unit = "bytes"
	// UnitCount ...
	UnitCount Unit = "count"
)

// PossibleUnitValues returns an array of possible values for the Unit const type.
func PossibleUnitValues() []Unit {
	return []Unit{UnitBitsPerSecond, UnitBytes, UnitCount}
}

// Unit1 enumerates the values for unit 1.
type Unit1 string

const (
	// Unit1Count ...
	Unit1Count Unit1 = "count"
)

// PossibleUnit1Values returns an array of possible values for the Unit1 const type.
func PossibleUnit1Values() []Unit1 {
	return []Unit1{Unit1Count}
}

// URLFileExtensionOperator enumerates the values for url file extension operator.
type URLFileExtensionOperator string

const (
	// URLFileExtensionOperatorAny ...
	URLFileExtensionOperatorAny URLFileExtensionOperator = "Any"
	// URLFileExtensionOperatorBeginsWith ...
	URLFileExtensionOperatorBeginsWith URLFileExtensionOperator = "BeginsWith"
	// URLFileExtensionOperatorContains ...
	URLFileExtensionOperatorContains URLFileExtensionOperator = "Contains"
	// URLFileExtensionOperatorEndsWith ...
	URLFileExtensionOperatorEndsWith URLFileExtensionOperator = "EndsWith"
	// URLFileExtensionOperatorEqual ...
	URLFileExtensionOperatorEqual URLFileExtensionOperator = "Equal"
	// URLFileExtensionOperatorGreaterThan ...
	URLFileExtensionOperatorGreaterThan URLFileExtensionOperator = "GreaterThan"
	// URLFileExtensionOperatorGreaterThanOrEqual ...
	URLFileExtensionOperatorGreaterThanOrEqual URLFileExtensionOperator = "GreaterThanOrEqual"
	// URLFileExtensionOperatorLessThan ...
	URLFileExtensionOperatorLessThan URLFileExtensionOperator = "LessThan"
	// URLFileExtensionOperatorLessThanOrEqual ...
	URLFileExtensionOperatorLessThanOrEqual URLFileExtensionOperator = "LessThanOrEqual"
	// URLFileExtensionOperatorRegEx ...
	URLFileExtensionOperatorRegEx URLFileExtensionOperator = "RegEx"
)

// PossibleURLFileExtensionOperatorValues returns an array of possible values for the URLFileExtensionOperator const type.
func PossibleURLFileExtensionOperatorValues() []URLFileExtensionOperator {
	return []URLFileExtensionOperator{URLFileExtensionOperatorAny, URLFileExtensionOperatorBeginsWith, URLFileExtensionOperatorContains, URLFileExtensionOperatorEndsWith, URLFileExtensionOperatorEqual, URLFileExtensionOperatorGreaterThan, URLFileExtensionOperatorGreaterThanOrEqual, URLFileExtensionOperatorLessThan, URLFileExtensionOperatorLessThanOrEqual, URLFileExtensionOperatorRegEx}
}

// URLFileNameOperator enumerates the values for url file name operator.
type URLFileNameOperator string

const (
	// URLFileNameOperatorAny ...
	URLFileNameOperatorAny URLFileNameOperator = "Any"
	// URLFileNameOperatorBeginsWith ...
	URLFileNameOperatorBeginsWith URLFileNameOperator = "BeginsWith"
	// URLFileNameOperatorContains ...
	URLFileNameOperatorContains URLFileNameOperator = "Contains"
	// URLFileNameOperatorEndsWith ...
	URLFileNameOperatorEndsWith URLFileNameOperator = "EndsWith"
	// URLFileNameOperatorEqual ...
	URLFileNameOperatorEqual URLFileNameOperator = "Equal"
	// URLFileNameOperatorGreaterThan ...
	URLFileNameOperatorGreaterThan URLFileNameOperator = "GreaterThan"
	// URLFileNameOperatorGreaterThanOrEqual ...
	URLFileNameOperatorGreaterThanOrEqual URLFileNameOperator = "GreaterThanOrEqual"
	// URLFileNameOperatorLessThan ...
	URLFileNameOperatorLessThan URLFileNameOperator = "LessThan"
	// URLFileNameOperatorLessThanOrEqual ...
	URLFileNameOperatorLessThanOrEqual URLFileNameOperator = "LessThanOrEqual"
	// URLFileNameOperatorRegEx ...
	URLFileNameOperatorRegEx URLFileNameOperator = "RegEx"
)

// PossibleURLFileNameOperatorValues returns an array of possible values for the URLFileNameOperator const type.
func PossibleURLFileNameOperatorValues() []URLFileNameOperator {
	return []URLFileNameOperator{URLFileNameOperatorAny, URLFileNameOperatorBeginsWith, URLFileNameOperatorContains, URLFileNameOperatorEndsWith, URLFileNameOperatorEqual, URLFileNameOperatorGreaterThan, URLFileNameOperatorGreaterThanOrEqual, URLFileNameOperatorLessThan, URLFileNameOperatorLessThanOrEqual, URLFileNameOperatorRegEx}
}

// URLPathOperator enumerates the values for url path operator.
type URLPathOperator string

const (
	// URLPathOperatorAny ...
	URLPathOperatorAny URLPathOperator = "Any"
	// URLPathOperatorBeginsWith ...
	URLPathOperatorBeginsWith URLPathOperator = "BeginsWith"
	// URLPathOperatorContains ...
	URLPathOperatorContains URLPathOperator = "Contains"
	// URLPathOperatorEndsWith ...
	URLPathOperatorEndsWith URLPathOperator = "EndsWith"
	// URLPathOperatorEqual ...
	URLPathOperatorEqual URLPathOperator = "Equal"
	// URLPathOperatorGreaterThan ...
	URLPathOperatorGreaterThan URLPathOperator = "GreaterThan"
	// URLPathOperatorGreaterThanOrEqual ...
	URLPathOperatorGreaterThanOrEqual URLPathOperator = "GreaterThanOrEqual"
	// URLPathOperatorLessThan ...
	URLPathOperatorLessThan URLPathOperator = "LessThan"
	// URLPathOperatorLessThanOrEqual ...
	URLPathOperatorLessThanOrEqual URLPathOperator = "LessThanOrEqual"
	// URLPathOperatorRegEx ...
	URLPathOperatorRegEx URLPathOperator = "RegEx"
	// URLPathOperatorWildcard ...
	URLPathOperatorWildcard URLPathOperator = "Wildcard"
)

// PossibleURLPathOperatorValues returns an array of possible values for the URLPathOperator const type.
func PossibleURLPathOperatorValues() []URLPathOperator {
	return []URLPathOperator{URLPathOperatorAny, URLPathOperatorBeginsWith, URLPathOperatorContains, URLPathOperatorEndsWith, URLPathOperatorEqual, URLPathOperatorGreaterThan, URLPathOperatorGreaterThanOrEqual, URLPathOperatorLessThan, URLPathOperatorLessThanOrEqual, URLPathOperatorRegEx, URLPathOperatorWildcard}
}

// ValidateSecretType enumerates the values for validate secret type.
type ValidateSecretType string

const (
	// ValidateSecretTypeCustomerCertificate ...
	ValidateSecretTypeCustomerCertificate ValidateSecretType = "CustomerCertificate"
	// ValidateSecretTypeManagedCertificate ...
	ValidateSecretTypeManagedCertificate ValidateSecretType = "ManagedCertificate"
	// ValidateSecretTypeURLSigningKey ...
	ValidateSecretTypeURLSigningKey ValidateSecretType = "UrlSigningKey"
)

// PossibleValidateSecretTypeValues returns an array of possible values for the ValidateSecretType const type.
func PossibleValidateSecretTypeValues() []ValidateSecretType {
	return []ValidateSecretType{ValidateSecretTypeCustomerCertificate, ValidateSecretTypeManagedCertificate, ValidateSecretTypeURLSigningKey}
}

// WafAction enumerates the values for waf action.
type WafAction string

const (
	// WafActionAllow ...
	WafActionAllow WafAction = "allow"
	// WafActionBlock ...
	WafActionBlock WafAction = "block"
	// WafActionLog ...
	WafActionLog WafAction = "log"
	// WafActionRedirect ...
	WafActionRedirect WafAction = "redirect"
)

// PossibleWafActionValues returns an array of possible values for the WafAction const type.
func PossibleWafActionValues() []WafAction {
	return []WafAction{WafActionAllow, WafActionBlock, WafActionLog, WafActionRedirect}
}

// WafGranularity enumerates the values for waf granularity.
type WafGranularity string

const (
	// WafGranularityP1D ...
	WafGranularityP1D WafGranularity = "P1D"
	// WafGranularityPT1H ...
	WafGranularityPT1H WafGranularity = "PT1H"
	// WafGranularityPT5M ...
	WafGranularityPT5M WafGranularity = "PT5M"
)

// PossibleWafGranularityValues returns an array of possible values for the WafGranularity const type.
func PossibleWafGranularityValues() []WafGranularity {
	return []WafGranularity{WafGranularityP1D, WafGranularityPT1H, WafGranularityPT5M}
}

// WafMetric enumerates the values for waf metric.
type WafMetric string

const (
	// WafMetricClientRequestCount ...
	WafMetricClientRequestCount WafMetric = "clientRequestCount"
)

// PossibleWafMetricValues returns an array of possible values for the WafMetric const type.
func PossibleWafMetricValues() []WafMetric {
	return []WafMetric{WafMetricClientRequestCount}
}

// WafRankingGroupBy enumerates the values for waf ranking group by.
type WafRankingGroupBy string

const (
	// WafRankingGroupByCustomDomain ...
	WafRankingGroupByCustomDomain WafRankingGroupBy = "customDomain"
	// WafRankingGroupByHTTPStatusCode ...
	WafRankingGroupByHTTPStatusCode WafRankingGroupBy = "httpStatusCode"
)

// PossibleWafRankingGroupByValues returns an array of possible values for the WafRankingGroupBy const type.
func PossibleWafRankingGroupByValues() []WafRankingGroupBy {
	return []WafRankingGroupBy{WafRankingGroupByCustomDomain, WafRankingGroupByHTTPStatusCode}
}

// WafRankingType enumerates the values for waf ranking type.
type WafRankingType string

const (
	// WafRankingTypeAction ...
	WafRankingTypeAction WafRankingType = "action"
	// WafRankingTypeClientIP ...
	WafRankingTypeClientIP WafRankingType = "clientIp"
	// WafRankingTypeCountry ...
	WafRankingTypeCountry WafRankingType = "country"
	// WafRankingTypeRuleGroup ...
	WafRankingTypeRuleGroup WafRankingType = "ruleGroup"
	// WafRankingTypeRuleID ...
	WafRankingTypeRuleID WafRankingType = "ruleId"
	// WafRankingTypeRuleType ...
	WafRankingTypeRuleType WafRankingType = "ruleType"
	// WafRankingTypeURL ...
	WafRankingTypeURL WafRankingType = "url"
	// WafRankingTypeUserAgent ...
	WafRankingTypeUserAgent WafRankingType = "userAgent"
)

// PossibleWafRankingTypeValues returns an array of possible values for the WafRankingType const type.
func PossibleWafRankingTypeValues() []WafRankingType {
	return []WafRankingType{WafRankingTypeAction, WafRankingTypeClientIP, WafRankingTypeCountry, WafRankingTypeRuleGroup, WafRankingTypeRuleID, WafRankingTypeRuleType, WafRankingTypeURL, WafRankingTypeUserAgent}
}

// WafRuleType enumerates the values for waf rule type.
type WafRuleType string

const (
	// WafRuleTypeBot ...
	WafRuleTypeBot WafRuleType = "bot"
	// WafRuleTypeCustom ...
	WafRuleTypeCustom WafRuleType = "custom"
	// WafRuleTypeManaged ...
	WafRuleTypeManaged WafRuleType = "managed"
)

// PossibleWafRuleTypeValues returns an array of possible values for the WafRuleType const type.
func PossibleWafRuleTypeValues() []WafRuleType {
	return []WafRuleType{WafRuleTypeBot, WafRuleTypeCustom, WafRuleTypeManaged}
}
