package attestation

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// MetadataConfigurationClient is the describes the interface for the per-tenant enclave service.
type MetadataConfigurationClient struct {
	BaseClient
}

// NewMetadataConfigurationClient creates an instance of the MetadataConfigurationClient client.
func NewMetadataConfigurationClient() MetadataConfigurationClient {
	return MetadataConfigurationClient{New()}
}

// Get retrieves metadata about the attestation signing keys in use by the attestation service
// Parameters:
// instanceURL - the attestation instance base URI, for example https://mytenant.attest.azure.net.
func (client MetadataConfigurationClient) Get(ctx context.Context, instanceURL string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MetadataConfigurationClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, instanceURL)
	if err != nil {
		err = autorest.NewErrorWithError(err, "attestation.MetadataConfigurationClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "attestation.MetadataConfigurationClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "attestation.MetadataConfigurationClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client MetadataConfigurationClient) GetPreparer(ctx context.Context, instanceURL string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"instanceUrl": instanceURL,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{instanceUrl}", urlParameters),
		autorest.WithPath("/.well-known/openid-configuration"))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client MetadataConfigurationClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client MetadataConfigurationClient) GetResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
