/*
 *    WMAcpiLoad - A dockapp to monitor ACPI status
 *    Copyright (C) 2002  Thomas Nemeth <tnemeth@free.fr>
 *
 *    Patch by Alan Carriou <cariou_alan@yahoo.fr> (C) 2004-2005
 *
 *    Based on work by Seiichi SATO <ssato@sh.rim.or.jp>
 *    Copyright (C) 2001,2002  Seiichi SATO <ssato@sh.rim.or.jp>
 *    and on work by Mark Staggs <me@markstaggs.net>
 *    Copyright (C) 2002  Mark Staggs <me@markstaggs.net>

 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.

 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.

 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef H_MAIN
#  define H_MAIN

/************************************************************************
 * Type definitions
 ************************************************************************/

typedef struct s_state state;
struct s_state {
    int bat_percentage;
    int bat_plugged;
    temperature temp;
    bat_status bat_status;
    ac_power AC_power;
};

/************************************************************************
 * Function prototypes for main.c
 ************************************************************************/

/*
 * Handles only the SIGCHLD signal, to let exit properly the fork()ed children
 * that have ended and become zombies.
 */
static void signal_handler(int);

/*
 * Initiates the global variables such as verbosity, the AcpiInfos strucure,
 * and so on to their default values.
 */
static void init_global_variables(void);

/*
 * Stores the current acpi state in previous_state.
 *
 * If the state or the AcpiInfos is null, then it does nothing.
 */
static void backup_to_previous_state(state *, AcpiInfos *);

/*
 * Reads up-to-date ACPI status and updates the display.
 * If necessary, raises or lowers alarm mode, and launches notif_cmd.
 *
 * The int parameter should be set at a non-zero value if this is the first time
 * the function is called.
 */
static void update(AcpiInfos *, int, state *, DrawConfig *);

/* Parse the arguments passed to the program */
static void parse_arguments(int, char **, AcpiInfos *, DrawConfig *);

/* Prints the usage of the program on standard output. */
static void print_help(char *);

/*
 * Calls sh to execute an external command (alarm).
 *      
 * Return code is :
 *    0 if everything goes fine
 *    1 if the given command is invalid
 *    2 if fork()ing is impossible
 *      
 * Once created, the child tries to execve() the given command. If it can't,
 * then the child exit()s right away with EXIT_FAILURE.
 */
static int my_system(char *);

/* Returns a non-null value if the alarm should be raised */
static int check_alarm(AcpiInfos *);

#endif                          /* H_MAIN */
