% Ultralytics 🚀 AGPL-3.0 License - https://ultralytics.com/license

function intOut = fcnRandomPoisson(L) 
%This function generates on random number using a Poisson Distribution if
%the mean/variance is 50 or less, and a normal distribution if the mean is
%greater than 50. 
%L=lambda, the poisson distribution mean AND variance.

 if L<20 %L<=15, USE POISSON DISTRIBUTION
     x = 0:99; %VALUES TO EVALUATE MASS FUNCTION OVER
     factorial0to99=[         1
                         1
                         2
                         6
                        24
                       120
                       720
                      5040
                     40320
                    362880
                   3628800
                  39916800
                 479001600
                6227020800
               87178291200
             1307674368000
            20922789888000
           355687428096000
       6.402373705728e+015
     1.21645100408832e+017
     2.43290200817664e+018
     5.10909421717094e+019
     1.12400072777761e+021
      2.5852016738885e+022
     6.20448401733239e+023
      1.5511210043331e+025
     4.03291461126606e+026
     1.08888694504184e+028
     3.04888344611714e+029
      8.8417619937397e+030
     2.65252859812191e+032
     8.22283865417792e+033
     2.63130836933694e+035
     8.68331761881189e+036
     2.95232799039604e+038
     1.03331479663861e+040
     3.71993326789901e+041
     1.37637530912263e+043
     5.23022617466601e+044
     2.03978820811974e+046
     8.15915283247898e+047
     3.34525266131638e+049
     1.40500611775288e+051
     6.04152630633738e+052
     2.65827157478845e+054
      1.1962222086548e+056
     5.50262215981209e+057
     2.58623241511168e+059
     1.24139155925361e+061
     6.08281864034268e+062
     3.04140932017134e+064
     1.55111875328738e+066
     8.06581751709439e+067
     4.27488328406003e+069
     2.30843697339241e+071
     1.26964033536583e+073
     7.10998587804863e+074
     4.05269195048772e+076
     2.35056133128288e+078
      1.3868311854569e+080
     8.32098711274139e+081
     5.07580213877225e+083
     3.14699732603879e+085
     1.98260831540444e+087
     1.26886932185884e+089
     8.24765059208247e+090
     5.44344939077443e+092
     3.64711109181887e+094
     2.48003554243683e+096
     1.71122452428141e+098
     1.19785716699699e+100
     8.50478588567862e+101
     6.12344583768861e+103
     4.47011546151268e+105
     3.30788544151939e+107
     2.48091408113954e+109
     1.88549470166605e+111
     1.45183092028286e+113
     1.13242811782063e+115
     8.94618213078297e+116
     7.15694570462638e+118
     5.79712602074737e+120
     4.75364333701284e+122
     3.94552396972066e+124
     3.31424013456535e+126
     2.81710411438055e+128
     2.42270953836727e+130
     2.10775729837953e+132
     1.85482642257398e+134
     1.65079551609085e+136
     1.48571596448176e+138
      1.3520015276784e+140
     1.24384140546413e+142
     1.15677250708164e+144
     1.08736615665674e+146
     1.03299784882391e+148
     9.91677934870949e+149
     9.61927596824821e+151
     9.42689044888324e+153
     9.33262154439441e+155];

% inverseFactorial=[       1
%                          1
%                        0.5
%          0.166666666666667
%         0.0416666666666667
%        0.00833333333333333
%        0.00138888888888889
%       0.000198412698412698
%      2.48015873015873e-005
%      2.75573192239859e-006
%      2.75573192239859e-007
%      2.50521083854417e-008
%      2.08767569878681e-009
%      1.60590438368216e-010
%      1.14707455977297e-011
%      7.64716373181982e-013
%      4.77947733238739e-014
%      2.81145725434552e-015
%      1.56192069685862e-016
%      8.22063524662433e-018
%      4.11031762331216e-019
%      1.95729410633913e-020
%      8.89679139245056e-022
%      3.86817017063068e-023
%      1.61173757109612e-024
%      6.44695028438447e-026
%       2.4795962632248e-027
%      9.18368986379551e-029
%      3.27988923706984e-030
%      1.13099628864477e-031
%      3.76998762881591e-033
%      1.21612504155352e-034
%      3.80039075485474e-036
%      1.15163356207719e-037
%      3.38715753552116e-039
%      9.67759295863193e-041
%      2.68822026628664e-042
%      7.26546017915309e-044
%      1.91196320504028e-045
%      4.90246975651355e-047
%      1.22561743912839e-048
%      2.98931082714241e-050
%      7.11740673129144e-052
%       1.6552108677422e-053
%      3.76184288123226e-055
%      8.35965084718282e-057
%      1.81731540156148e-058
%       3.8666285139606e-060
%      8.05547607075122e-062
%      1.64397470831658e-063
%      3.28794941663316e-065
%      6.44695964045718e-067
%      1.23979993085715e-068
%      2.33924515256066e-070
%      4.33193546770493e-072
%      7.87624630491803e-074
%      1.40647255444965e-075
%      2.46749570956079e-077
%       4.2543029475186e-079
%      7.21068296189593e-081
%      1.20178049364932e-082
%      1.97013195680217e-084
%       3.1776321883906e-086
%      5.04386061649301e-088
%      7.88103221327033e-090
%      1.21246649434928e-091
%      1.83707044598376e-093
%      2.74189618803546e-095
%      4.03220027652274e-097
%      5.84376851669963e-099
%       8.3482407381423e-101
%      1.17580855466793e-102
%      1.63306743703879e-104
%      2.23707868087506e-106
%      3.02307929847981e-108
%      4.03077239797308e-110
%      5.30364789206984e-112
%       6.8878544052855e-114
%      8.83058257087885e-116
%      1.11779526213656e-117
%      1.39724407767071e-119
%      1.72499268848235e-121
%      2.10364962010043e-123
%      2.53451761457883e-125
%      3.01728287449861e-127
%      3.54974455823366e-129
%      4.12760995143449e-131
%      4.74437925452239e-133
%      5.39134006195728e-135
%      6.05768546287332e-137
%      6.73076162541482e-139
%       7.3964413466097e-141
%      8.03961015935836e-143
%      8.64474210683695e-145
%      9.19653415620954e-147
%      9.68056226969418e-149
%      1.00839190309315e-150
%      1.03957928153933e-152
%      1.06079518524421e-154
%      1.07151028812547e-156];
     
     n=0;
     cdf=0;
     enL = exp(-L); %exp negative L
     uniformrand=rand; %uniform random number from 0 to 1.
     while uniformrand>cdf
         n=n+1;
         %cdf = cdf + L^x(n)*enL*inverseFactorial(n);
         cdf = cdf + L^x(n)*enL/factorial0to99(n);
         %cdf = cdf + exp(x(n)*log(L) - L - gammaln(x(n)+1)); %approximation
     end
     intOut = n-1;
 else %NORMAL DISTRIBUTION
     intOut = round(L+randn*sqrt(L));
 end

   


% %COMPARE POISSON WITH NORMAL DIST -----------------------------------------
% clc; clear
% L=50; %MEAN AND VARIANCE OF POISSON DISTRIBUTION 
% sig = sqrt(L); %GAUSSIAN DISTRIBUTION SIGMA
% x = 0:200; %X VALUES TO EVALUATE DISCRETE PROBABILITY MASS FUNCTION
% y = L.^x*exp(-L)./factorial(x); %MASS AS A FUNCTION OF X VALUE
% y2 = 1/(sig*sqrt(2*pi)) * exp(-(x-L).^2/(2*sig^2)); %CONTINUOUS NORMAL PROBABILITY DENSITY FUNCTION
% %y3 = pdf('Poisson',x,L); STATISTICS TOOLBOX FUNCTION
% plot(x,y,'.b')
% hold on
% plot(x,y2,'.r')
% legend('Poisson','Normal')





