% Ultralytics 🚀 AGPL-3.0 License - https://ultralytics.com/license

function density = fcnPREM(r)
%https://docs.google.com/spreadsheets/d/1teHQhwHQu2Wo3789YnPQB1poeDJ1plCgc5Fowr_Y7oU/edit#gid=0

sr = size(r);

a=PREM;
rp = a(:,1); %PREM ranges (km)
j=find(diff(rp)==0)+1; rp(j)=rp(j)+.001;

x=interp1(rp,a(:,2:end),r(:),'linear');
density = x(:,3)./1000; %convert to g/cm^3

density = reshape(density,sr);
end

function x=PREM()
x=[0	11266.2     3667.8	13088.48	1425.3	176.1	0.4407	363.85	0
200     11255.93	3663.42	13079.77	1423.1	175.5	0.4408	362.9	0.7311
400     11237.12	3650.27	13053.64	1416.4	173.9	0.441	360.03	1.4604
600     11205.76	3628.35	13010.09	1405.3	171.3	0.4414	355.28	2.1862
800     11161.86	3597.67	12949.12	1389.8	167.6	0.442	348.67	2.9068
1000	11105.42	3558.23	12870.73	1370.1	163     0.4428	340.24	3.6203
1200	11036.43	3510.02	12774.93	1346.2	157.4	0.4437	330.05	4.3251
1221.5	11028.27	3504.32	12763.6     1343.4	156.7	0.4438	328.85	4.4002
1221.5	10355.68	0       12166.34	1304.7	0       0.5	328.85	4.4002
1400	10249.59	0       12069.24	1267.9	0       0.5	318.75	4.9413
1600	10122.91	0       11946.82	1224.2	0	0.5	306.15	5.5548
1800	9985.54     0       11809       1177.5	0	0.5	292.22	6.1669
2000	9834.96     0       11654.78	1127.3	0	0.5	277.04	6.7715
2200	9668.65     0       11483.11	1073.5	0	0.5	260.68	7.3645
2400	9484.09     0       11292.98	1015.8	0	0.5	243.25	7.9425
2600	9278.76     0       11083.35	954.2	0	0.5	224.85	8.5023
2800	9050.15     0       10853.21	888.9	0	0.5	205.6	9.0414
3000	8795.73     0       10601.52	820.2	0	0.5	185.64	9.557
3200	8512.98     0       10327.26	748.4	0	0.5	165.12	10.0464
3400	8199.39     0       10029.4     674.3	0	0.5	144.19	10.5065
3480	8064.82     0       9903.49 	644.1	0	0.5	135.75	10.6823
3480	13716.6     7264.66	5566.45 	655.6	293.8	0.3051	135.75	10.6823
3600	13687.53	7265.75	5506.42 	644     290.7	0.3038	128.71	10.5204
3630	13680.41	7265.97	5491.45 	641.2	289.9	0.3035	126.97	10.4844
3630	13680.41	7265.97	5491.45 	641.2	289.9	0.3035	126.97	10.4844
3800	13447.42	7188.92	5406.81 	609.5	279.4	0.3012	117.35	10.3095
4000	13245.32	7099.74	5307.24 	574.4	267.5	0.2984	106.39	10.158
4200	13015.79	7010.53	5207.13 	540.9	255.9	0.2957	95.76	10.0535
4400	12783.89	6919.57	5105.9  	508.5	244.5	0.2928	85.43	9.9859
4600	12544.66	6825.12	5002.99 	476.6	233.1	0.2898	75.36	9.9474
4800	12293.16	6725.48	4897.83 	444.8	221.5	0.2864	65.52	9.9314
5000	12024.45	6618.91	4789.83 	412.8	209.8	0.2826	55.9	9.9326
5200	11733.57	6563.7	4678.44 	380.3	197.9	0.2783	46.49	9.9467
5400	11415.6     6378.13	4563.07 	347.1	185.6	0.2731	37.29	9.9698
5600	11065.57	6240.46	4443.17 	313.3	173	0.2668	28.29	9.9985
5600	11065.57	6240.46	4443.17 	313.3	173	0.2668	28.29	9.9985
5701	10751.31	5945.08	4380.71 	299.9	154.8	0.2798	23.83	10.0143
5701	10266.22	5570.2	3992.14 	255.6	123.9	0.2914	23.83	10.0143
5771	10157.82	5516.01	3975.84 	248.9	121	0.2909	21.04	10.0038
5771	10157.82	5516.01	3975.84 	248.9	121	0.2909	21.04	10.0038
5871	9645.88     5224.28	3849.8  	218.1	105.1	0.2924	17.13	9.9883
5971	9133.97     4932.59	3723.78 	189.9	90.6	0.2942	13.35	9.9686
5971	8905.22     4769.89	3543.25 	173.5	80.6	0.2988	13.35	9.9686
6061	8732.09     4706.9	3489.51 	163     77.3	0.2952	10.2	9.9361
6151	8558.96     4643.91	3435.78 	152.9	74.1	0.2914	7.11	9.9048
6151	7989.7      4418.85	3359.5  	127     65.6	0.2797	7.11	9.9048
6221	8033.7      4443.61	3367.1  	128.7	66.5	0.2796	4.78	9.8783
6291	8076.88     4469.53	3374.71 	130.3	67.4	0.2793	2.45	9.8553
6291	8076.88     4469.53	3374.71 	130.3	67.4	0.2793	2.45	9.8553
6346.6	8110.61     4490.94	3380.76 	131.5	68.2	0.2789	0.604	9.8394
6346.6	6800        3900	2900    	75.3	44.1	0.2549	0.604	9.8394
6356	6800        3900	2900    	75.3	44.1	0.2549	0.337	9.8332
6356	5800        3200	2600    	52      26.6	0.2812	0.337	9.8332
6368	5800        3200	2600    	52      26.6	0.2812	0.3	9.8222
6368	1450        0       1020        2.1	0	0.5	0.3	9.8222
6371	1450        0       1020        2.1	0	0.5	0	9.8156];
end
