package kms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSecretPolicy invokes the kms.GetSecretPolicy API synchronously
func (client *Client) GetSecretPolicy(request *GetSecretPolicyRequest) (response *GetSecretPolicyResponse, err error) {
	response = CreateGetSecretPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// GetSecretPolicyWithChan invokes the kms.GetSecretPolicy API asynchronously
func (client *Client) GetSecretPolicyWithChan(request *GetSecretPolicyRequest) (<-chan *GetSecretPolicyResponse, <-chan error) {
	responseChan := make(chan *GetSecretPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSecretPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSecretPolicyWithCallback invokes the kms.GetSecretPolicy API asynchronously
func (client *Client) GetSecretPolicyWithCallback(request *GetSecretPolicyRequest, callback func(response *GetSecretPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSecretPolicyResponse
		var err error
		defer close(result)
		response, err = client.GetSecretPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSecretPolicyRequest is the request struct for api GetSecretPolicy
type GetSecretPolicyRequest struct {
	*requests.RpcRequest
	PolicyName string `position:"Query" name:"PolicyName"`
	SecretName string `position:"Query" name:"SecretName"`
}

// GetSecretPolicyResponse is the response struct for api GetSecretPolicy
type GetSecretPolicyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Policy    string `json:"Policy" xml:"Policy"`
}

// CreateGetSecretPolicyRequest creates a request to invoke GetSecretPolicy API
func CreateGetSecretPolicyRequest() (request *GetSecretPolicyRequest) {
	request = &GetSecretPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Kms", "2016-01-20", "GetSecretPolicy", "kms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetSecretPolicyResponse creates a response to parse from GetSecretPolicy response
func CreateGetSecretPolicyResponse() (response *GetSecretPolicyResponse) {
	response = &GetSecretPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
