[![License: GPL v2](https://img.shields.io/badge/License-GPL%20v2-blue.svg)](https://www.gnu.org/licenses/old-licenses/gpl-2.0.en.html)

|Branch|CI status|
|------|---------|
|Master|[![CI](https://github.com/wesnoth/wesnoth/actions/workflows/ci-main.yml/badge.svg)](https://github.com/wesnoth/wesnoth/actions/workflows/ci-main.yml?query=branch%3Amaster)|
|1.18|[![CI](https://github.com/wesnoth/wesnoth/actions/workflows/ci-main.yml/badge.svg?branch=1.18)](https://github.com/wesnoth/wesnoth/actions/workflows/ci-main.yml?query=branch%3A1.18)|

About
=====

**The Battle for Wesnoth** is an Open Source, turn-based tactical strategy game with a high fantasy theme, featuring both singleplayer and online/hotseat multiplayer combat. Fight a desperate battle to reclaim the throne of Wesnoth, search for the key to immortality, or take part in any number of other adventures.

Community
---------

The official Battle for Wesnoth Forums:
  <https://forums.wesnoth.org/>

Discord:
  <https://discord.gg/battleforwesnoth>

IRC:
  <https://wiki.wesnoth.org/Support#IRC>

Mastodon:
  <https://fosstodon.org/@wesnoth>

Steam forums:
  <https://steamcommunity.com/app/599390/discussions/>

Features
--------

* A variety of different campaigns, each with their own tactical challenges, emotionally charged story, and multiple difficulty levels.
* A detailed world and storytelling with hundreds of sprites, animations, and characters.
* Many different unit skills and traits across several factions.
* A map editor with multiple tools, hundreds types of terrain, and the ability for you to save and share maps with others. Create your own scenarios/battles for near infinite replayability.
* Highly moddable, allowing a wide array of community created map packs, eras, and entire campaigns.
* Online and local multiplayer gameplay to play with friends, strangers, or against the AI.
* Changeable settings for base gameplay, with nearly limitless options for different hotkey configurations.
* Beautifully composed playlist that captures the era and grandiosity of this lore-filled high-fantasy world.

Installing
----------

Wesnoth can be played on Windows, macOS, and Linux, and can be installed using:
* [Steam](https://store.steampowered.com/app/599390/Battle_for_Wesnoth/) (all)
* [itch.io](https://wesnoth.itch.io/battle-for-wesnoth) (Windows and macOS)
* The [macOS App Store](https://apps.apple.com/us/app/the-battle-for-wesnoth/id1450738104)
* standalone installers on [SourceForge](https://sourceforge.net/projects/wesnoth/files/) (Windows and macOS)
* [Flatpak](https://flathub.org/apps/details/org.wesnoth.Wesnoth) (Linux)

Additionally, third-party ports are available for [iOS](https://apps.apple.com/us/app/battle-for-wesnoth/id575852062) and [Android](https://sourceforge.net/projects/wesnoth-on-android/files/). Both ports are currently unmaintained.

To build the game from source, see [INSTALL](/INSTALL.md) for instructions.

Contributing
------------

Wesnoth is most in need of skilled C++ developers (C++14 and later), however there are things that nearly anyone can help with:
* Simple tasks in C++. 
* The Lua and WML used for content scripting. 
* Python used by various external tools.
* Even play testing and giving feedback on updated campaigns! 

Additionally, Wesnoth lacks art for a variety of unit animations - anyone who would be interested in lending a hand in updating existing unit sprites or creating animations should take a look at the [Art Contributions](https://forums.wesnoth.org/viewforum.php?f=9) forum as well as contact our current art director.

See also: [CONTRIBUTING](/CONTRIBUTING.md)

For any questions, the best place to start is to simply join Wesnoth's forums, Discord, or IRC and start asking!


Donations
---------

Donations can be sent via [Software in the Public Interest](https://www.spi-inc.org/projects/wesnoth/), [Liberapay](https://liberapay.com/Wesnoth), as well as when downloading through itch.io. All money donated is used to pay for project expenses such as server rent and art commissions, and is very much appreciated.


License
-------

All source code is licensed under the GNU GPL v2+. Most art and music is also licensed under the GNU GPL v2+, however new contributions are now licensed under the Creative Commons BY-SA v4.0. For more detailed information on Wesnoth's licensing, see the wiki:

  <https://wiki.wesnoth.org/Wesnoth:Copyrights>


More Information
----------------

For extensive documentation about all aspects of the game, see the official Battle for Wesnoth web site:

  <https://www.wesnoth.org/>
  <https://wiki.wesnoth.org/>

A (translated) description of how to play the game can be found in doc/manual/manual.*.html, or online at:

  <https://wiki.wesnoth.org/WesnothManual>

For information on creating your own maps, scenarios, and other content, see:

  <https://wiki.wesnoth.org/Create>

Gallery
-------

![screenshot_main_menu](https://www.wesnoth.org/images/sshots/wesnoth-1.16.0-1.jpg)
![scrreenshot_isars_cross](https://www.wesnoth.org/images/sshots/wesnoth-1.16.0-2.jpg)
![screenshot_campaign_menu](https://www.wesnoth.org/images/sshots/wesnoth-1.16.0-5.jpg)
![screenshot_map](https://www.wesnoth.org/images/sshots/wesnoth-1.16.0-8.jpg)
