/* vim: set tabstop=4: */
/*
 * This file is part of TraceProto.
 * Copyright 2004-2005 Eric Hope and others; see the AUTHORS file for details.
 *
 * TraceProto is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * TraceProto is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with TraceProto; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef TP_MISCFUNC_H
#define TP_MISCFUNC_H 1

#include "config.h"

struct cleanup {
	unsigned int skips_free : 1;
	unsigned int payload_free : 1;
	unsigned int free_list_free : 1;
	unsigned int hop_record_free : 1;
	unsigned int fake_psocket_free : 1;
	unsigned int curses_end : 1;
	unsigned int libnet_cleanup : 1;
	unsigned int pcap_cleanup : 1;
	unsigned int addrinfo_cleanup : 1;
} tixe_cleanup;

int parse_skips ( char * );

void ctrl_c( __attribute__((__unused__)) int unused );

void ctrl_z( __attribute__((__unused__)) int unused );

double diff_time ( struct timeval *, struct timeval * );

int do_filter ( void );

int account_packet ( double return_time );

void hop_audit( void );

int reg_name ( char * );

void tixe ( struct cleanup clean_list, int exit_status ) __attribute__((__noreturn__));

void version( void );

unsigned char parse_flags ( char * );

int make_timestamp ( char * );

u_char * tp_align ( const u_char *, unsigned int, unsigned int );

void dropexcesscapabilities( void );

void parse_debug ( char * optarg );

void debug_packet ( const u_int8_t * const raw, const u_int bytes );

#endif /* TP_MISCFUNC_H */
