//Barry Kauler may 2008, for Puppy Linux.
//I got this program from 'hotplug.txt' on the Internet, titled 'hotplug and firmware loading with sysfs'
//Everitt 10 may 2008: solution for weird stdout delay.

  #include <stdio.h>
  #include <stdlib.h>
  #include <string.h>

  #include <sys/poll.h>
  #include <sys/socket.h>
  #include <sys/types.h>
  #include <unistd.h>

  #include <linux/types.h>
  #include <linux/netlink.h>

  void die(char *s)
  {
	write(2,s,strlen(s));
	exit(1);
  }

  int main(int argc, char *argv[])
  {
	struct sockaddr_nl nls;
	struct pollfd pfd;
	char buf[512];
	int eventstatus;

	// Open hotplug event netlink socket

	memset(&nls,0,sizeof(struct sockaddr_nl));
	nls.nl_family = AF_NETLINK;
	nls.nl_pid = getpid();
	nls.nl_groups = -1;

	pfd.events = POLLIN;
	pfd.fd = socket(PF_NETLINK, SOCK_DGRAM, NETLINK_KOBJECT_UEVENT);
	if (pfd.fd==-1)
		die("Not root\n");

	// Listen to netlink socket

	if (bind(pfd.fd, (void *)&nls, sizeof(struct sockaddr_nl)))
		die("Bind failed\n");
	while (1) {
		eventstatus=poll(&pfd, 1, 2000); //2 second timeout. note, -1 is wait indefinitely.
		if (eventstatus == -1) break; //error.
		if (eventstatus == 0) { //timeout, and no event.
		 printf("TWOSECTIMEOUT\n");
		 fflush(stdout);
		 continue;
		}
		int i, len = recv(pfd.fd, buf, sizeof(buf), MSG_DONTWAIT);
		if (len == -1) die("recv\n");

		// Print the data to stdout.
		i = 0;
/*BK		while (i<len) {
			printf("%s\n", buf+i);
			i += strlen(buf+i)+1;
		} */
		/*BK only prints add/remove/mount/umount summary lines...*/
		/*BK really twisted weird, but need to print twice for pup_ueventd to work properly... */
		//fprintf(stderr, "%s\n", buf+i);
		printf("%s\n", buf+i);
		//BK, no need for weird fix, everitt has a better solution...
		/*everitt: It seems that some data is being buffered for some reason. Flush the stdout buffer to push it along to where we need it*/
		fflush(stdout); 
	}
	die("poll\n");

	// Dear gcc: shut up.
	return 0;
  }
