/* 
 * Library of useful functions for check_danssec
 * 
 * License: GPL
 * Copyright (c) 2009 Marius Rieder <marius.rieder@durchmesser.ch>
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include <ldns/ldns.h>

#include "config.h"
 
#define STATE_OK 0
#define STATE_WARNING 1
#define STATE_CRITICAL 2
#define STATE_UNKNOWN 3

#define AP_OK 0
#define AP_EXIT 1
#define AP_WARN 2

#define DEFAULT_SOCKET_TIMEOUT 10

void ok(const char *fmt, ...);
void warning(const char *fmt, ...);
void critical(const char *fmt, ...);
void unknown(const char *fmt, ...);

ldns_resolver* createResolver(const  char *dns_server);
void timeout_alarm_handler(int sig);

void print_version(void);

// Args parser
int getTime(const char *optarg);
void setHostname(const char *optarg, char **dns_server);
void setDomainname(const char *optarg, char **domain_name);
void loadKeyfile(const char *optarg, ldns_rr_list **trusted_keys);
void loadAnchorfile(const char *optarg, ldns_rr_list **trusted_keys);
