## Introduction

In order to use SSL with ntopng (i.e. HTTPS) you need a certificate; you can create your own self signed certificate (1) or obtain it by a Certification Authorities (CA) (2):
- obtain the .pem files
- concatenate the privateKeyFile(.pem) and the certificate/certificateChainFile(.pem)
- Rename it in ntopng-cert.pem and put inside ntopng/httpdocs/ssl/.

The HTTPS server will start on port 3001

Below you can find instructions on how to run ntopng with either a self signed or a CA certificate generated by Let's Encrypt (https://letsencrypt.org)

## SELFSIGNED CERTIFICATE

1	To create the self-signed certificate you need to:

1.1	Install OpenSSL

	On Debian/Ubuntu: sudo apt-get install openssl
	OnRedHat/CentOS: sudo yum install openssl

  	On OSX do: brew install openssl

1.2 Create your SSL certificate

		inside the ntopng folder execute the command: make cert
		and follow the instruction

1.3	Edit ntop.conf to enable https
		Edit the /etc/ntopng/ntopng.conf file to include the text --https-port=3001
		You may choose ports other than 3001 but it must be a different port to the http port which is port 3000 by default
		Alternatively you can disable insecure http altogether by replacing the line -w=3000 with --http-port=0
		(-w and --http-port are interchangeable)
   

1.5	Start ntopng

1.6 OPTIONAL
  	"make cert" will create the certificate but you can see below the
  	exact steps if you want to generate the certificate manually.
  
		You now need to locate your ntopng `share` directory. It is usually located at `/usr/share/ntopng` or at `/usr/local/share/ntopng`.
		The next instructions assume it's located at `/usr/local/share/ntopng`.

		== Ubuntu and Centos packages ==

		cd /tmp/
		openssl req -new -x509 -sha256 -extensions v3_ca -nodes -days 365 -out cert.pem
		cat privkey.pem cert.pem > /usr/share/ntopng/httpdocs/ssl/ntopng-cert.pem
		/bin/rm -f privkey.pem cert.pem
		cd /usr/local/bin/
		ln -s /usr/lib/x86_64-linux-gnu/libssl.so .
		ntopng

		== HomeBrew Formula ==

		cd /tmp/
		openssl req -new -x509 -sha256 -extensions v3_ca -nodes -days 365 -out cert.pem
		mkdir /usr/share/ntopng/httpdocs/ssl/
		cat privkey.pem cert.pem > /usr/share/ntopng/httpdocs/ssl/ntopng-cert.pem
		/bin/rm -f privkey.pem cert.pem
		cd /usr/local/bin/
		ln -s /opt/local/lib/libssl.dylib /opt/local/lib/libcrypto.dylib .
		ntopng



## CA CERTIFICATE [ Let's Encrypt ]

Please read https://www.ntop.org/ntopng/securing-ntopng-with-ssl-and-lets-encrypt/ for
a complete tutorial on using Let's Encrypt to secure ntopng.


## HTTPS Client Authentication

By enabling this feature you may grant access to ntopng by the means of X.509 client certificates.

Clients that provides a valid certificate, issued by a trusted CA, are authenticated 
without the need of a password, if the X.509 Common Name (CN) matches an existing ntopng user.

Clients that otherwise fails to provide a certificate or a valid one, fallback to the usual 
login process.

Trusted CAs are read from httpdocs/ssl/ntopng-ca.crt, this file must contain the concatenated 
list of CAs certificates, in PEM format. Any change to this file requires a restart of ntopng
to take effect.

Using openssl you may easily activate the feature and create client certificates 
with the following instructions.

1. Create your own CA:

	- openssl genrsa -des3 -out ca.key 2048				# create key
	- openssl req -new -x509 -days 365 -key ca.key -out ca.crt 	# create CA self-signed cert

	- cat ca.crt >> ntopng/httpdocs/ssl/ntopng-ca.crt			# add cert to trusted CAs
	

2. Create one or more Client Certificates:

	- openssl genrsa -des3 -out client.key 2048			# create key
	- openssl req -new -key client.key -out client.csr		# create client cert request
	- openssl x509 -req -days 365 -in client.csr -CA ca.crt -CAkey ca.key -CAcreateserial -out client.crt														# create client cert signed by CA
	
3. Export Client to preferred browser format (usually pkcs12):

	- openssl pkcs12 -export -clcerts -in client.crt -inkey client.key -out client.p12

Then import client certificate in the browser and restart ntopng. 
Remember first to enable HTTPS Client Authentication in the Preferences->User Authetication.

