#include <unistd.h>
#include <src/includes.hpp>
#include <sstream>
#include <any>

#define private public
#include <src/config/ConfigManager.hpp>
#include <src/config/ConfigDescriptions.hpp>
#include <src/layout/IHyprLayout.hpp>
#include <src/managers/LayoutManager.hpp>
#include <src/Compositor.hpp>
#undef private

#include "globals.hpp"

// Do NOT change this function.
APICALL EXPORT std::string PLUGIN_API_VERSION() {
    return HYPRLAND_API_VERSION;
}

static SDispatchResult test(std::string in) {
    bool        success = true;
    std::string errors  = "";

    if (g_pConfigManager->m_configValueNumber != CONFIG_OPTIONS.size() + 1 /* autogenerated is special */) {
        errors += "config value number mismatches descriptions size\n";
        success = false;
    }

    return SDispatchResult{
        .success = success,
        .error   = errors,
    };
}

// Trigger a snap move event for the active window
static SDispatchResult snapMove(std::string in) {
    const auto PLASTWINDOW = g_pCompositor->m_lastWindow.lock();
    if (!PLASTWINDOW->m_isFloating)
        return {.success = false, .error = "Window must be floating"};

    Vector2D pos  = PLASTWINDOW->m_realPosition->goal();
    Vector2D size = PLASTWINDOW->m_realSize->goal();

    g_pLayoutManager->getCurrentLayout()->performSnap(pos, size, PLASTWINDOW, MBIND_MOVE, -1, size);
    *PLASTWINDOW->m_realPosition = pos.round();

    return {};
}

APICALL EXPORT PLUGIN_DESCRIPTION_INFO PLUGIN_INIT(HANDLE handle) {
    PHANDLE = handle;

    HyprlandAPI::addDispatcherV2(PHANDLE, "plugin:test:test", ::test);
    HyprlandAPI::addDispatcherV2(PHANDLE, "plugin:test:snapmove", ::snapMove);

    return {"hyprtestplugin", "hyprtestplugin", "Vaxry", "1.0"};
}

APICALL EXPORT void PLUGIN_EXIT() {
    ;
}
