/*
 * idcmd.h -- definitions for the char module
 *
 *********/

#include <linux/ioctl.h>

/*
 * Macros to help debugging
 */

#undef PDEBUG			/* undef it, just in case */
#ifdef CPCMD_DEBUG
#  ifdef __KERNEL__
     /* This one if debugging is on, and kernel space */
#    define PDEBUG(fmt, args...) printk( KERN_DEBUG "cpcmd: " fmt, ## args)
#  else
     /* This one for user space */
#    define PDEBUG(fmt, args...) fprintf(stderr, fmt, ## args)
#  endif
#else
#  define PDEBUG(fmt, args...)	/* not debugging: nothing */
#endif

#undef PDEBUGG
#define PDEBUGG(fmt, args...)	/* nothing: it's a placeholder */

typedef struct IDCmd_Dev {
	CPInt_Dev *dev;		/* Pointer to the base device     */
	int rc;			/* Return code from CP command    */
} IDCmd_Dev;

#ifndef min
#  define min(a,b) ((a)<(b) ? (a) : (b))
#endif

/*
 * Ioctl definitions
 */

/* Use 'r' as magic number */
#define IDCMD_IOC_MAGIC  'r'

#define IDCMD_IOCRESET    _IO(IDCMD_IOC_MAGIC, 0)
#define IDGETBF		  _IOR(IDCMD_IOC_MAGIC, 1, char*)

/*
 * S means "Set" through a ptr,
 * T means "Tell" directly with the argument value
 * G means "Get": reply by setting through a pointer
 * Q means "Query": response is on the return value
 * X means "eXchange": G and S atomically
 * H means "sHift": T and Q atomically
 */

/* ... more to come */

#define IDCMD_IOCHARDRESET _IO(IDCMD_IOC_MAGIC, 2)	/* debugging tool */

#define IDCMD_IOC_MAXNR 2
