/************************************************************/
/*                                                          */
/* Module ID  - actgen.                                     */
/*                                                          */
/* Function   - Generate CP ACCOUNT data.                   */
/*                                                          */
/* Called By  - N/A.                                        */
/*                                                          */
/* Calling To - N/A.                                        */
/*                                                          */
/* Parameters - None.                                       */
/*                                                          */
/* Notes      - (1) Uses /dev/cpact to communicate.         */
/*                                                          */
/*              (2) ....................................... */
/*                                                          */
/*                                                          */
/* Name       - Neale Ferguson.                             */
/*                                                          */
/* Date       - April, 2003.                                */
/*                                                          */
/*                                                          */
/* Associated    - (1) Refer To ........................... */
/* Documentation                                            */
/*                 (2) Refer To ........................... */
/*                                                          */
/************************************************************/

/************************************************************/
/*                                                          */
/*                     DEFINES                              */
/*                     -------                              */
/*                                                          */
/************************************************************/

#define ACTDEV "/dev/cpact"

/*=============== End of Defines ===========================*/

/************************************************************/
/*                                                          */
/*              INCLUDE STATEMENTS                          */
/*              ------------------                          */
/*                                                          */
/************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#include <string.h>

/*================== End of Include Statements =============*/

/************************************************************/
/*                                                          */
/*              TYPE DEFINITIONS                            */
/*              ----------------                            */
/*                                                          */
/************************************************************/

/*================== End of Type Definitions ===============*/

/************************************************************/
/*                                                          */
/*             FUNCTION PROTOTYPES                          */
/*             -------------------                          */
/*                                                          */
/************************************************************/

/*================== End of Prototypes =====================*/

/************************************************************/
/*                                                          */
/*           GLOBAL VARIABLE DECLARATIONS                   */
/*           ----------------------------                   */
/*                                                          */
/************************************************************/

/*============== End of Variable Declarations ==============*/

/************************************************************/
/*                                                          */
/* Name       - main.                                       */
/*                                                          */
/* Function   - Open the CP account device.                 */
/*                                                          */
/* Parameters -                                             */
/*                                                          */
/************************************************************/

int
main(int argc, char **argv)
{
	int fd, rc, l_account, i_arg, exitRc = 0;
	char actData[70];

	if (argc < 2) {
		exitRc = -1;
		fprintf(stderr, "Correct form: actgen <actdata>\n");
	} else {
		actData[0] = 0;
		l_account = sizeof (actData);
		for (i_arg = 1;
		     strlen(actData) < sizeof (actData) && i_arg < argc;
		     i_arg++) {
			strncat(actData, argv[i_arg], l_account);
			l_account -= strlen(argv[i_arg]);
			strncat(actData, " ", l_account);
			l_account -= 1;
		}
		l_account = strlen(actData);
		fd = open(ACTDEV, O_RDWR);
		if (fd >= 0) {
			rc = write(fd, actData, l_account);
			if (rc < 0) {
				exitRc = errno;
				fprintf(stderr, "Write: %s\n", strerror(errno));
			}
		} else {
			exitRc = errno;
			fprintf(stderr, "Open: %s\n", strerror(errno));
		}
		if (close(fd) < 0)
			fprintf(stderr, "Close: %s\n", strerror(errno));
	}
	exit(exitRc);
}

/*===================== End of Function ====================*/
