/*
 *  Copyright (C) 2005-2007 Renier Roth
 *  www.renier.de
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package de.renier.vdr.channel.editor.container;

import java.awt.Component;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

import de.renier.vdr.channel.Channel;
import de.renier.vdr.channel.ChannelCategory;
import de.renier.vdr.channel.ChannelElement;
import de.renier.vdr.channel.editor.util.LocalProperties;
import de.renier.vdr.channel.editor.util.Utils;

/**
 * ChannelTreeRenderer
 * 
 * @author <a href="mailto:editor@renier.de">Renier Roth</a>
 */
public class ChannelTreeRenderer extends DefaultTreeCellRenderer {

  private static final long serialVersionUID = -2745334818811786036L;

  /**
   * Overidden method to set icon
   */
  public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf,
      int row, boolean hasFocusBool) {
    super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);

    // get ChannelElement
    if (value instanceof DefaultMutableTreeNode) {
      DefaultMutableTreeNode node = (DefaultMutableTreeNode) value;
      if (node.getUserObject() instanceof ChannelElement) {
        ChannelElement channelElement = (ChannelElement) node.getUserObject();
        // set special icons
        if (channelElement.isCategory()) {
          this.setIcon(Utils.iconCategory);
        } else if (channelElement.isTelevision()) {
          Channel channel = (Channel) channelElement;
          if ("0".equals(channel.getCaId())) {
            this.setIcon(Utils.iconTelevision);
          } else {
            this.setIcon(Utils.iconTelevisionCrypt);
          }
        } else if (channelElement.isRadio()) {
          Channel channel = (Channel) channelElement;
          if ("0".equals(channel.getCaId())) {
            this.setIcon(Utils.iconRadio);
          } else {
            this.setIcon(Utils.iconRadioCrypt);
          }
        } else if (channelElement.isService()) {
          Channel channel = (Channel) channelElement;
          if ("0".equals(channel.getCaId())) {
            this.setIcon(Utils.iconService);
          } else {
            this.setIcon(Utils.iconServiceCrypt);
          }
        } else if (node.isRoot()) {
          this.setIcon(Utils.iconRoot);
        }
        // get font size
        int fontSize = Integer.parseInt(LocalProperties.getInstance().getProperty(LocalProperties.PROP_FONTSIZE));
        if (fontSize > 0) {
          this.setFont(this.getFont().deriveFont((float) fontSize));
        }
      }
      // set channel number for channel
      if (node.getUserObject() instanceof Channel) {
        Channel channel = (Channel) node.getUserObject();
        int channelNumber = channel.getNumber();
        this.setText(String.valueOf(channelNumber) + " - " + this.getText());
      } else if (node.getUserObject() instanceof ChannelCategory) {
        ChannelCategory channelCategory = (ChannelCategory) node.getUserObject();
        if (channelCategory.getNumberAt() > 0) {
          this.setText(this.getText() + " (@" + String.valueOf(channelCategory.getNumberAt()) + ")");
        }
      }
    }

    return this;
  }

}
