/*
 *  Copyright (C) 2005-2007 Renier Roth
 *  www.renier.de
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package de.renier.vdr.channel.editor.actions;

import java.util.Comparator;

import javax.swing.tree.DefaultMutableTreeNode;

import de.renier.vdr.channel.Channel;
import de.renier.vdr.channel.editor.Messages;

/**
 * SortBouqetAction
 * 
 * @author <a href="mailto:editor@renier.de">Renier Roth</a>
 */
public class SortBouqetAction extends AbstractSortAction {

  private static final long serialVersionUID = -2159290526438407601L;

  public SortBouqetAction() {
    super(Messages.getString("SortBouqetAction.0")); //$NON-NLS-1$
  }

  protected Comparator createSortComparator() {
    return new Comparator() {

      public int compare(Object o1, Object o2) {
        // only channels
        if (((DefaultMutableTreeNode) o1).getUserObject() instanceof Channel
            && ((DefaultMutableTreeNode) o2).getUserObject() instanceof Channel) {
          Channel element1 = (Channel) ((DefaultMutableTreeNode) o1).getUserObject();
          Channel element2 = (Channel) ((DefaultMutableTreeNode) o2).getUserObject();
          return element1.getBouqet().compareTo(element2.getBouqet());
        }
        return 0;
      }
    };
  }

}
